/***************************************************************** 
 * FILE        : DCU.h
 * 
 * DESCRIPTION : This is the header file describing the register
 *               set for:
 *               FARADAY
 *
 *               Please enter any bugs on GFORGE:
 * 				 http://gforge.freescale.net/projects/faraday-header/
 *				 Ensure you are logged in to enter bugs (top right of screen  use OneIT pass).
 *				 Tracker -> Bugs -> Submit New
 *				 Only the title (including the header name e.g. ADC.h) and description are 
 * 			 	 required  the rest can be left as default. 
 *				
 *               Alternatively send bugs to b06321@freescale.com
 *               using [FARADAY_HEADER] in subject        
 * 
 * COPYRIGHT   :(c) 2011, Freescale Semiconductor
 * 
 * VERSION     : 0
 * DATE        : 07 September 2011
 * AUTHOR      : b06321 
 * HISTORY     : 
 * v0: 	Alpha release made up from currently available BG. Not yet  
 * 		fully tested. Regs and bits are liable to change up until
 * 		tape-out.
 * v0.1: Added additonal bit 12 to INT_MASK
 * 
 *
 ******************************************************************/
 
/* ================================================================================
   ==============================        DCU         ==============================  
   ================================================================================ */
#ifndef DCU_H
#define DCU_H
#include "typedefs.h"

typedef struct{

        union {
            vuint32_t R;
            struct {
              vuint32_t WIDTH:11;
              vuint32_t:5;
              vuint32_t HEIGHT:11;
              vuint32_t:5;
            } B;
        } CTRLDESCL1;                   /* LAYER[X].CTRLDESCL1 */

        union {
            vuint32_t R;
            struct {
                vuint32_t POSX:12;
                vuint32_t:4;
                vuint32_t POSY:12;
                vuint32_t:4;
            } B;
        } CTRLDESCL2;                   /* LAYER[X].CTRLDESCL2 */

        union {
            vuint32_t R;
            struct {
                vuint32_t ADDR:32;
            } B;
        } CTRLDESCL3;                   /* LAYER[X].CTRLDESCL3 */

        union {
            vuint32_t R;
            struct {
                vuint32_t AB:2;
                vuint32_t BB:1;
                vuint32_t:1;
                vuint32_t LUOFFS:11;
                vuint32_t RLE_EN:1;
                vuint32_t BPP:4;
                vuint32_t TRANS:8;
                vuint32_t SAFETY_EN:1;
				vuint32_t DATA_SE:1;
				vuint32_t TILE_EN:1;
                vuint32_t EN:1;
            } B;
        } CTRLDESCL4;                   /* LAYER[X].CTRLDESCL4 */

        union {
            vuint32_t R;
            struct {
                vuint32_t CKMAX_B:8;
                vuint32_t CKMAX_G:8;
                vuint32_t CKMAX_R:8;
                vuint32_t:8;
            } B;
        } CTRLDESCL5;                   /* LAYER[X].CTRLDESCL5 */

        union {
            vuint32_t R;
            struct {
                vuint32_t CKMIN_B:8;
                vuint32_t CKMIN_G:8;
                vuint32_t CKMIN_R:8;
                vuint32_t:8;
            } B;
        } CTRLDESCL6;                   /* LAYER[X].CTRLDESCL6 */

        union {
            vuint32_t R;
            struct {
                vuint32_t TILE_HOR_SIZE:7;
                vuint32_t:9;
                vuint32_t TILE_VER_SIZE:11;
                vuint32_t:5;
            } B;
        } CTRLDESCL7;                   /* LAYER[X].CTRLDESCL7 */
        
        union {
            vuint32_t R;
            struct {
                  vuint32_t FG_FCOLOR:24;
                  vuint32_t:8;
            } B;
        } CTRLDESCL8;                   /* LAYER[X].CTRLDESCL8 */
        
        union {
            vuint32_t R;
            struct {
              vuint32_t FG_BCOLOR:24;
              vuint32_t:8;
            } B;
        } CTRLDESCL9;                   /* LAYER[X].CTRLDESCL9 */
        
        vuint8_t RESERVED[28];
    }DCU_LAYER_tag;                                  /* end of DCU_LAYER_tag */

struct DCUx_tag {
  //vuint32_t CTRLDESCCURSOR1;   /* offset: 0x00000000*/
  union {
            vuint32_t R;
            struct {
                vuint32_t WIDTH:11;
                vuint32_t:5;
                vuint32_t HEIGHT:11;
                vuint32_t:5;
            } B;
        } CTRLDESCCURSOR1;              /* Cursor Control Descriptor 1 Register */
  
  //vuint32_t CTRLDESCCURSOR2;   /* offset: 0x00000004*/
  
  union {
            vuint32_t R;
            struct {
                vint32_t POSX:11;
                vuint32_t:5;
                vint32_t POSY:11;                
                vuint32_t:5;
            } B;
        } CTRLDESCCURSOR2;              /* Cursor Control Descriptor 2 Register */
  
  
  //vuint32_t CTRLDESCCURSOR3;   /* offset: 0x00000008*/
  union {
            vuint32_t R;
            struct {
              vuint32_t CURSOR_DEFAULT_COLOR:24;  
              vuint32_t:7;
              vuint32_t CUR_EN:1;
         } B;
        } CTRLDESCCURSOR3;              /* Cursor Control Descriptor 3 Register */
  
  //vuint32_t CTRLDESCCURSOR4;   /* offset: 0x0000000C*/
  union {
            vuint32_t R;
            struct {
                vuint32_t HWC_BLINK_ON:8;
                vuint32_t EN_BLINK:1;
                vuint32_t:7;
                vuint32_t HWC_BLINK_OFF:8;
                vuint32_t:8;
            } B;
        } CTRLDESCCURSOR4;              /* Cursor Control Descriptor 4 Register */
  
 // vuint32_t DCU_MODE;           /* offset: 0x00000010*/
  union {
            vuint32_t R;
            struct {
              vuint32_t DCU_MODE:2;
              vuint32_t EN_GAMMA:1;
              vuint32_t:1;
              vuint32_t PDI_SYNC:1;
              vuint32_t SIG_EN:1;
              vuint32_t TAG_EN:1;
              vuint32_t PDI_SLAVE_MODE:1;
              vuint32_t PDI_MODE:2;
              vuint32_t PDI_NARROW_MODE:1;
              vuint32_t PDI_DE_MODE:1;
              vuint32_t PDI_BYTE_REV:1;
              vuint32_t PDI_EN:1;
              vuint32_t RASTER_EN:1;
              vuint32_t PDI_INTERPOL_EN:1;
              vuint32_t PDI_SYNC_LOCK:4;
              vuint32_t BLEND_ITER:3;
              vuint32_t DDR_MODE:1;
              vuint32_t ADDR:2;
              vuint32_t ADDG:2;
              vuint32_t ADDB:2;
              vuint32_t DITHER_EN:1;
              vuint32_t DCU_SW_RESET:1;
            } B;
        } DCU_MODE;                     /* Mode Register */
  
  //vuint32_t BGND;               /* offset: 0x00000014*/
  union {
            vuint32_t R;
            struct {
                vuint32_t BGND_B:8;
                vuint32_t BGND_G:8;
                vuint32_t BGND_R:8;    
                vuint32_t:8;
            } B;
        } BGND;                         /* Background Register */
  
  
  //vuint32_t DISP_SIZE;          /* offset: 0x00000018*/
  union {
            vuint32_t R;
            struct {
                vuint32_t DELTA_X:7;
                vuint32_t:9;
                vuint32_t DELTA_Y:11;
                vuint32_t:5;
         } B;
        } DISP_SIZE;                    /* Display Size Register */
  
  //vuint32_t HSYN_PARA;          /* offset: 0x0000001C*/
 union {
            vuint32_t R;
            struct {
               vuint32_t FP_H:9;  
               vuint32_t:2;
               vuint32_t PW_H:9;
               vuint32_t:2;
               vuint32_t BP_H:9;
               vuint32_t:1;
            } B;
        } HSYN_PARA;                    /* Horizontal Synchronisation Parameters Register */ 
  
 
 //vuint32_t VSYN_PARA;          /* offset: 0x00000020*/
 union {
            vuint32_t R;
            struct {
                vuint32_t FP_V:9;
                vuint32_t:2;
                vuint32_t PW_V:9;
                vuint32_t:2;
                vuint32_t BP_V:9;
                vuint32_t:1;
            } B;
        } VSYN_PARA;                    /* Vertical Synchronisation Parameters Register */
 
  //vuint32_t SYNPOL;             /* offset: 0x00000024*/
  union {
            vuint32_t R;
            struct {
                vuint32_t INV_HS:1;
                vuint32_t INV_VS:1;
                vuint32_t RESERVED:3;
                vuint32_t NEG:1;
                vuint32_t INV_PXCK:1;
                vuint32_t INV_PDI_CLK:1;
                vuint32_t INV_PDI_VS:1;
                vuint32_t INV_PDI_HS:1;
                vuint32_t INV_PDI_DE:1;
                vuint32_t:21;
          } B;
        } SYN_POL;                      /* Synchronisation Polarity Register */
 
  //vuint32_t THRESHOLD;          /* offset: 0x00000028*/ //NORRIS
  union {
            vuint32_t R;
            struct {
                vuint32_t OUT_BUF_LOW:8;
                vuint32_t OUT_BUF_HIGH:8;
                vuint32_t LS_BF_VS:11;            
                vuint32_t:5;
            } B;
        } THRESHOLD;                    /* Threshold Register */
  
  //vuint32_t INT_STATUS;         /* offset: 0x0000002C*/
  union {
            vuint32_t R;
            struct {
                vuint32_t VSYNC:1;
                vuint32_t UNDRUN:1;
                vuint32_t LS_BF_VS:1;
                vuint32_t VS_BLANK:1;
                vuint32_t CRC_READY:1;
                vuint32_t CRC_OVERFLOW:1;
                vuint32_t P1_FIFO_LO_FLAG:1;
                vuint32_t P1_FIFO_HI_FLAG:1;
                vuint32_t P2_FIFO_LO_FLAG:1;
                vuint32_t P2_FIFO_HI_FLAG:1;
                vuint32_t PROG_END:1;
                vuint32_t IPM_ERROR:1;
                vuint32_t LYR_TRANS_FINISH:1;
                vuint32_t:1;
                vuint32_t DMA_TRANS_FINISH:1;
                vuint32_t:1;
                vuint32_t P3_FIFO_LO_FLAG:1;
                vuint32_t P3_FIFO_HI_FLAG:1;
                vuint32_t P4_FIFO_LO_FLAG:1;
                vuint32_t P4_FIFO_HI_FLAG:1;
                vuint32_t P5_FIFO_LO_FLAG:1;
                vuint32_t P5_FIFO_HI_FLAG:1;
                vuint32_t P6_FIFO_LO_FLAG:1;
                vuint32_t P6_FIFO_HI_FLAG:1;
                vuint32_t:2;
                vuint32_t P1_EMPTY:1;
                vuint32_t P2_EMPTY:1;
                vuint32_t P3_EMPTY:1;
                vuint32_t P4_EMPTY:1;
                vuint32_t P5_EMPTY:1;
                vuint32_t P6_EMPTY:1;
 
            } B;
        } INT_STATUS;                   /* Interrupt Status Register */
  
  //vuint32_t INT_MASK;           /* offset: 0x00000030*/
  union {
            vuint32_t R;
            struct {
                vuint32_t M_VSYNC:1;
                vuint32_t M_UNDRUN:1;
                vuint32_t M_LS_BF_VS:1;
                vuint32_t M_VS_BLANK:1;
                vuint32_t M_CRC_READY:1;
                vuint32_t M_CRC_OVERFLOW:1;
                vuint32_t M_P1_FIFO_LO_FLAG:1;
                vuint32_t M_P1_FIFO_HI_FLAG:1;
                vuint32_t M_P2_FIFO_LO_FLAG:1;
                vuint32_t M_P2_FIFO_HI_FLAG:1;
                vuint32_t M_PROG_END:1;
                vuint32_t M_IPM_ERROR:1;
                vuint32_t M_LYR_TRANS_FINISH:1;
                vuint32_t:1;
                vuint32_t M_DMA_TRANS_FINISH:1;
                vuint32_t:1;
                vuint32_t M_P3_FIFO_LO_FLAG:1;
                vuint32_t M_P3_FIFO_HI_FLAG:1;
                vuint32_t M_P4_FIFO_LO_FLAG:1;
                vuint32_t M_P4_FIFO_HI_FLAG:1;
                vuint32_t M_P5_FIFO_LO_FLAG:1;
                vuint32_t M_P5_FIFO_HI_FLAG:1;
                vuint32_t M_P6_FIFO_LO_FLAG:1;
                vuint32_t M_P6_FIFO_HI_FLAG:1;
                vuint32_t:2;
                vuint32_t M_P1_EMPTY:1;
                vuint32_t M_P2_EMPTY:1;
                vuint32_t M_P3_EMPTY:1;
                vuint32_t M_P4_EMPTY:1;
                vuint32_t M_P5_EMPTY:1;
                vuint32_t M_P6_EMPTY:1;
            } B;
        } INT_MASK;                     /* Interrupt Mask Register */
  
  //vuint32_t COLBAR_1;           /* offset: 0x00000034*/
  //vuint32_t COLBAR_2;           /* offset: 0x00000038*/
  //vuint32_t COLBAR_3;           /* offset: 0x0000003C*/
  //vuint32_t COLBAR_4;           /* offset: 0x00000040*/
  //vuint32_t COLBAR_5;           /* offset: 0x00000044*/
  //vuint32_t COLBAR_6;           /* offset: 0x00000048*/
  //vuint32_t COLBAR_7;           /* offset: 0x0000004C*/
  //vuint32_t COLBAR_8;           /* offset: 0x00000050*/
  union {
            vuint32_t R;
            struct {
                vuint32_t COLBAR_B:8;
                vuint32_t COLBAR_G:8;
                vuint32_t COLBAR_R:8;
                vuint32_t:8;
            } B;
        } COLBAR[8];                    /* Color Bar 1-8 Register */
  
  //vuint32_t DIV_RATIO;          /* offset: 0x00000054*/
  union {
            vuint32_t R;
            struct {
                  vuint32_t DIV_RATIO:8;
                  vuint32_t:24;
                  
            } B;
        } DIV_RATIO;                    /* Clock Divider Register */
  
  //vuint32_t SIGN_CALC_1;        /* offset: 0x00000058*/
  union {
            vuint32_t R;
            struct {
                vuint32_t SIG_HOR_SIZE:11;
                vuint32_t:5;
                vuint32_t SIG_VER_SIZE:11;
                vuint32_t:5;
            } B;
        } SIGN_CALC_1;                  /* CRC size configuration */

  
  //vuint32_t SIGN_CALC_2;        /* offset: 0x0000005C*/
  union {
            vuint32_t R;
            struct {
                vuint32_t SIG_HOR_POS:11;
                vuint32_t:5;
                vuint32_t SIG_VER_POS:11;
                vuint32_t:5;
            } B;
        } SIGN_CALC_2;                  /* CRC position configuration */
  
  //vuint32_t CRC_VAL;            /* offset: 0x00000060*/
  union {
            vuint32_t R;
            struct {
                vuint32_t CRC_VAL:32;
            } B;
        } CRC_VAL;                      /* CRC Result register */
  
  //vuint32_t PDI_STATUS      /* offset: 0x00000064*/
  union {
            vuint32_t R;
            struct {
                vuint32_t PDI_CLK_DET:1;
                vuint32_t PDI_CLK_LOST:1;
                vuint32_t PDI_DE_DET:1;
                vuint32_t PDI_HSYNC_DET:1;
                vuint32_t PDI_VSYNC_DET:1;
                vuint32_t PDI_LOCK_DET:1;
                vuint32_t PDI_LOCK_LOST:1;
                vuint32_t PDI_ECC_ERR1:1;
                vuint32_t PDI_ECC_ERR2:1;
                vuint32_t PDI_BLANKING_ERR:1;
                vuint32_t:22;
             } B;
        } PDI_STATUS;                   /* PDI status Register */ 
  //vuint32_t MASK_PDI_STATUS      /* offset: 0x00000068*/
  union {
            vuint32_t R;
            struct {
                vuint32_t M_PDI_CLK_DET:1;
                vuint32_t M_PDI_CLK_LOST:1;
                vuint32_t M_PDI_DE_DET:1;
                vuint32_t M_PDI_HSYNC_DET:1;
                vuint32_t M_PDI_VSYNC_DET:1;
                vuint32_t M_PDI_LOCK_DET:1;
                vuint32_t M_PDI_LOCK_LOST:1;
                vuint32_t M_PDI_ECC_ERR1:1;
                vuint32_t M_PDI_ECC_ERR2:1;
                vuint32_t M_PDI_BLANKING_ERR:1;
                vuint32_t:22;
            } B;
        } MASK_PDI_STATUS;              /* PDI Status Mask Register */
  
  vuint32_t PARR_ERR_STATUS1;   /* offset: 0x0000006C*/
  vuint32_t PARR_ERR_STATUS2;   /* offset: 0x00000070*/
  vuint8_t RESERVED0[8];	
  
  
  //vuint32_t PARR_ERR_STATUS3;   /* offset: 0x0000007C*/
  union {
    vuint32_t R;
      struct{
        vuint32_t DISP_ERR:1;
        vuint32_t SIG_ERR:1;
        vuint32_t HWC_ERR:1;
        vuint32_t RLE_ERR:1;
      }  B;
  } PARR_ERR_STATUS3;
  
  vuint32_t MASK_PARR_ERR_STATUS1;	/* offset: 0x00000080*/
  vuint32_t MASK_PARR_ERR_STATUS2;	/* offset: 0x00000084*/
  vuint8_t RESERVED1[8];
  //vuint32_t MASK_PARR_ERR_STATUS3;	/* offset: 0x00000090*/
  union {
    vuint32_t R;
      struct{
        vuint32_t M_DISP_ERR:1;
        vuint32_t M_SIG_ERR:1;
        vuint32_t M_HWC_ERR:1;
        vuint32_t M_RLE_ERR:1;
      vuint32_t:28;
      }  B;
  } MASK_PARR_ERR_STATUS3;
  
  
  //vuint32_t THRESHOLD_INP_BUF_1;	/* offset: 0x00000094*/
  union {
            vuint32_t R;
            struct {
                vuint32_t INP_BUF_P1_LO:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P1_HI:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P2_LO:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P2_HI:7;
                vuint32_t:1;
         } B;
        } THRESHOLD_INP1;               /* Threshold Input Buffer Register 1 */
  
  
  //vuint32_t THRESHOLD_INP_BUF_2;	/* offset: 0x00000098*/
  union {
            vuint32_t R;
            struct {
                vuint32_t INP_BUF_P3_LO:7;
                  vuint32_t:1;
                vuint32_t INP_BUF_P3_HI:7;
                  vuint32_t:1;
                vuint32_t INP_BUF_P4_LO:7;
                  vuint32_t:1;
                vuint32_t INP_BUF_P4_HI:7;
                vuint32_t:1;
           } B;
        } THRESHOLD_INP2;               /* Threshold Input Buffer Register 2 */
  
  //vuint32_t THRESHOLD_INP_BUF_3;	/* offset: 0x0000009C*/
 union {
            vuint32_t R;
            struct {
                vuint32_t INP_BUF_P5_LO:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P5_HI:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P6_LO:7;
                vuint32_t:1;
                vuint32_t INP_BUF_P6_HI:7;
                vuint32_t:1;
          } B;
        } THRESHOLD_INP3;               /* Threshold Input Buffer Register 3 */ 
  
  //vuint32_t LUMA_COMP;          /* offset: 0x000000A0*/
  union {
            vuint32_t R;
            struct {
              vuint32_t Y_BLUE:10;
              vuint32_t:1;
              vuint32_t Y_GREEN:10;
              vuint32_t:1;
              vuint32_t Y_RED:10;
          } B;
        } LUMA_COMP;                    /* Luminance component Register */
  
  //vuint32_t CHROMA_RED;         /* offset: 0x000000A4*/
  union {
            vuint32_t R;
            struct {
                vuint32_t CB_RED:12;
                vuint32_t:4;
                vuint32_t CR_RED:11;
                vuint32_t:5;
             } B;
        } CHROMA_RED;                   /* Red component Register */
  
  //vuint32_t CHROMA_GREEN;       /* offset: 0x000000A8*/
  union {
            vuint32_t R;
            struct {
                vuint32_t CB_GREEN:12;
                vuint32_t:4;
                vuint32_t CR_GREEN:11;    
                vuint32_t:5;
           } B;
        } CHROMA_GREEN;                 /* Green component Register */
  
  //vuint32_t CHROMA_BLUE;        /* offset: 0x000000AC*/
  union {
            vuint32_t R;
            struct {
                vuint32_t CB_BLUE:12;
                vuint32_t:4;
                vuint32_t CR_BLUE:11;
                vuint32_t:5;
            } B;
        } CHROMA_BLUE;                  /* Blue component Register */
  
  vuint32_t CRC_POS;            /* offset: 0x000000B0*/
  
  //vuint32_t LYR_INTPOL_EN;      /* offset: 0x000000B4*/
  union {
            vuint32_t R;
            struct {
              vuint32_t:31;  
              vuint32_t EN:1;
            } B;
        } LYR_INTPOL_EN;                /* Layer Interpolation Enable Register */
  
  //vuint32_t LYR_LUMA_COMP;      /* offset: 0x000000B8*/
  union {
            vuint32_t R;
            struct {
               vuint32_t Y_BLUE:10;
               vuint32_t:1;
               vuint32_t Y_GREEN:10;
               vuint32_t:1;
               vuint32_t Y_RED:10;
            } B;
        } LYR_LUMA_COMP;                /* Layer LUMA Component Register */
  
  //vuint32_t LYR_CHROMA_RED;     /* offset: 0x000000BC*/
  union {
            vuint32_t R;
            struct {
                vuint32_t CB_RED:12 ;
                vuint32_t:4;
                vuint32_t CR_RED:11;
                vuint32_t:5;
             } B;
        } LYR_CHROMA_RED;               /* Layer RED Chroma Component Register */
  
  //vuint32_t LYR_CHROMA_GREEN;   /* offset: 0x000000C0*/
  union {
            vuint32_t R;
            struct {
            vuint32_t CB_GREEN:12;
            vuint32_t:4;
            vuint32_t CR_GREEN:11;
            vuint32_t:5;
            } B;
        } LYR_CHROMA_GREEN;             /* Layer GREEN Chroma Component Register */
  
  //vuint32_t LYR_CHROMA_BLUE;    /* offset: 0x000000C4*/
  union {
            vuint32_t R;
            struct {
            vuint32_t CB_BLUE:12;    
            vuint32_t:4;
            vuint32_t CR_BLUE:11;
            vuint32_t:5;
           } B;
        } LYR_CHROMA_BLUE;              /* Layer BLUE Chroma Component Register */
  
  //vuint32_t COMP_IMSIZE;        /* offset: 0x000000C8*/
  union {
            vuint32_t R;
            struct {
                vuint32_t SIZE:22;
                vuint32_t:10;
            } B;
        } COMP_IMSIZE;                  /* Compressed Image Size Register */
  
  //vuint32_t UPDATE_MODE;        /* offset: 0x000000CC*/
  union {
            vuint32_t R;
            struct {
                vuint32_t:30;
                vuint32_t READREG:1;
                vuint32_t MODE:1;
            } B;
        } UPDATE_MODE;                  /* Compressed Image Size Register */
  //CHUCKNORRIS
  vuint32_t UNDERRUN;        	/* offset: 0x000000D0*/
  vuint8_t RESERVED2[44];
  //vuint32_t GPR;        			/* offset: 0x00000100*/
  union {
            vuint32_t R;
            struct {
                vuint32_t:31;
                vuint32_t HLB:1;
            } B;
        } GPR;                          /* Global Protection Register */
  
  //vuint32_t SLR_L0;        			/* offset: 0x00000104*/ 
  union {
            vuint32_t R;
            struct {
                vuint32_t:17;
                vuint32_t SLB_L0_7:1;
                vuint32_t SLB_L0_6:1;
                vuint32_t SLB_L0_5:1;
                vuint32_t:1;
                vuint32_t WEN_L0_7:1;
                vuint32_t WEN_L0_6:1;
                vuint32_t WEN_L0_5:1;
                vuint32_t SLB_L0_4:1;
                vuint32_t SLB_L0_3:1;
                vuint32_t SLB_L0_2:1;
                vuint32_t SLB_L0_1:1;
                vuint32_t WEN_L0_4:1;
                vuint32_t WEN_L0_3:1;
                vuint32_t WEN_L0_2:1;
                vuint32_t WEN_L0_1:1;
            } B;
        } SLR_L0;                       /* Soft Lock Register Layer 0 */
  
  //vuint32_t SLR_L1;        			/* offset: 0x00000108*/ 
  union {
            vuint32_t R;
            struct {
                vuint32_t:17;
                vuint32_t SLB_L1_7:1;
                vuint32_t SLB_L1_6:1;
                vuint32_t SLB_L1_5:1;
                vuint32_t:1;
                vuint32_t WEN_L1_7:1;
                vuint32_t WEN_L1_6:1;
                vuint32_t WEN_L1_5:1;
                vuint32_t SLB_L1_4:1;
                vuint32_t SLB_L1_3:1;
                vuint32_t SLB_L1_2:1;
                vuint32_t SLB_L1_1:1;
                vuint32_t WEN_L1_4:1;
                vuint32_t WEN_L1_3:1;
                vuint32_t WEN_L1_2:1;
                vuint32_t WEN_L1_1:1;
            } B;
        } SLR_L1;                       /* Soft Lock Register Layer 1 */
  
  //vuint32_t SLR_DISP_SIZE;        	/* offset: 0x0000010C*/ 
  union {
            vuint32_t R;
            struct {
                vuint32_t:27;  
                vuint32_t SLB_DISP:1;
                vuint32_t:3;
                vuint32_t WEN_DISP:1;
            } B;
        } SLR_DISP_SIZE;                /* Soft Lock Register DISP_SIZE */
  
  //vuint32_t SLR_HVSYNC_PARA;        /* offset: 0x00000110*/ 
  union {
            vuint32_t R;
            struct {
              vuint32_t:26;  
              vuint32_t SLB_VSYNC:1;
              vuint32_t SLB_HSYNC:1;
              vuint32_t:2;
              vuint32_t WEN_VSYNC:1;
              vuint32_t WEN_HSYNC:1;
            } B;
        } SLR_HVSYNC_PARA;              /* Soft Lock Register HSYNC VSYNC PARA */
  
  //vuint32_t SLR_POL;        		/* offset: 0x00000114*/ 
  union {
            vuint32_t R;
            struct {
                vuint32_t:27;
                vuint32_t SLB_POL:1;
                vuint32_t:3;
                vuint32_t WEN_POL:1;
           } B;
        } SLR_POL;                      /* Soft Lock Register POL */
  
  //vuint32_t SLR_L0TRANSP;        	/* offset: 0x00000118*/
  union {
            vuint32_t R;
            struct {
                  vuint32_t:26;
                  vuint32_t SLB_L0_BCOLOR:1;
                  vuint32_t SLB_L0_FCOLOR:1;
                  vuint32_t:2;
                  vuint32_t WEN_L0_BCOLOR:1;
                  vuint32_t WEN_L0_FCOLOR:1;
            } B;
        } SLR_L0TRANSP;                 /* Soft Lock Register Layer 0 TRANSP */
  
  //vuint32_t SLR_L1TRANSP;        	/* offset: 0x0000011C*/
  union {
            vuint32_t R;
            struct {
                vuint32_t:26;  
                vuint32_t SLB_L1_BCOLOR:1;
                vuint32_t SLB_L1_FCOLOR:1;
                vuint32_t:2;
                vuint32_t WEN_L1_BCOLOR:1;
                vuint32_t WEN_L1_FCOLOR:1;
            } B;
        } SLR_L1TRANSP;                 /* Soft Lock Register Layer 1 TRANSP */
  
  vuint8_t RESERVED3[224];
  DCU_LAYER_tag LAYER[64];
  
  //vuint32_t CTRLDESCL0_1;       /* offset: 0x00000200*/
  //vuint32_t CTRLDESCL0_2;       /* offset: 0x00000204*/
  //vuint32_t CTRLDESCL0_3;       /* offset: 0x00000208*/
  //vuint32_t CTRLDESCL0_4;       /* offset: 0x0000020C*/
  //vuint32_t CTRLDESCL0_5;       /* offset: 0x00000210*/
  //vuint32_t CTRLDESCL0_6;       /* offset: 0x00000214*/
  //vuint32_t CTRLDESCL0_7;       /* offset: 0x00000218*/
  //vuint32_t CTRLDESCL0_8;       /* offset: 0x0000021C*/
  //vuint32_t CTRLDESCL0_9;       /* offset: 0x00000220*/
  //vuint8_t RESERVED4[28];
  //vuint32_t CTRLDESCL1_1;       /* offset: 0x00000240*/
  //vuint32_t CTRLDESCL1_2;       /* offset: 0x00000244*/
  //vuint32_t CTRLDESCL1_3;       /* offset: 0x00000248*/
  //vuint32_t CTRLDESCL1_4;       /* offset: 0x0000024C*/
  //vuint32_t CTRLDESCL1_5;       /* offset: 0x00000250*/
  //vuint32_t CTRLDESCL1_6;       /* offset: 0x00000254*/
  //vuint32_t CTRLDESCL1_7;       /* offset: 0x00000258*/
  //vuint32_t CTRLDESCL1_8;       /* offset: 0x0000025C*/
  //vuint32_t CTRLDESCL1_9;       /* offset: 0x00000260*/
  //vuint8_t RESERVED5[28];
  //vuint32_t CTRLDESCL2_1;       /* offset: 0x00000280*/
  //vuint32_t CTRLDESCL2_2;       /* offset: 0x00000284*/
  //vuint32_t CTRLDESCL2_3;       /* offset: 0x00000288*/
  //vuint32_t CTRLDESCL2_4;       /* offset: 0x0000028C*/
  //vuint32_t CTRLDESCL2_5;       /* offset: 0x00000290*/
  //vuint32_t CTRLDESCL2_6;       /* offset: 0x00000294*/
  //vuint32_t CTRLDESCL2_7;       /* offset: 0x00000298*/
  //vuint32_t CTRLDESCL2_8;       /* offset: 0x0000029C*/
  //vuint32_t CTRLDESCL2_9;       /* offset: 0x000002A0*/
  //vuint8_t RESERVED6[28];
  //vuint32_t CTRLDESCL3_1;       /* offset: 0x000002C0*/
  //vuint32_t CTRLDESCL3_2;       /* offset: 0x000002C4*/
  //vuint32_t CTRLDESCL3_3;       /* offset: 0x000002C8*/
  //vuint32_t CTRLDESCL3_4;       /* offset: 0x000002CC*/
  //vuint32_t CTRLDESCL3_5;       /* offset: 0x000002D0*/
  //vuint32_t CTRLDESCL3_6;       /* offset: 0x000002D4*/
  //vuint32_t CTRLDESCL3_7;       /* offset: 0x000002D8*/
  //vuint32_t CTRLDESCL3_8;       /* offset: 0x000002DC*/
  //vuint32_t CTRLDESCL3_9;       /* offset: 0x000002E0*/
  //vuint8_t RESERVED7[28];
  //vuint32_t CTRLDESCL4_1;       /* offset: 0x00000300*/
  //vuint32_t CTRLDESCL4_2;       /* offset: 0x00000304*/
  //vuint32_t CTRLDESCL4_3;       /* offset: 0x00000308*/
  //vuint32_t CTRLDESCL4_4;       /* offset: 0x0000030C*/
  //vuint32_t CTRLDESCL4_5;       /* offset: 0x00000310*/
  //vuint32_t CTRLDESCL4_6;       /* offset: 0x00000314*/
  //vuint32_t CTRLDESCL4_7;       /* offset: 0x00000318*/
  //vuint32_t CTRLDESCL4_8;       /* offset: 0x0000031C*/
  //vuint32_t CTRLDESCL4_9;       /* offset: 0x00000320*/
  //vuint8_t RESERVED8[28];                         
  //vuint32_t CTRLDESCL5_1;       /* offset: 0x00000340*/
  //vuint32_t CTRLDESCL5_2;       /* offset: 0x00000344*/
  //vuint32_t CTRLDESCL5_3;       /* offset: 0x00000348*/
  //vuint32_t CTRLDESCL5_4;       /* offset: 0x0000034C*/
  //vuint32_t CTRLDESCL5_5;       /* offset: 0x00000350*/
  //vuint32_t CTRLDESCL5_6;       /* offset: 0x00000354*/
  //vuint32_t CTRLDESCL5_7;       /* offset: 0x00000358*/
  //vuint32_t CTRLDESCL5_8;       /* offset: 0x0000035C*/
  //vuint32_t CTRLDESCL5_9;       /* offset: 0x00000360*/
  //vuint8_t RESERVED9[28];                         
  //vuint32_t CTRLDESCL6_1;       /* offset: 0x00000380*/
  //vuint32_t CTRLDESCL6_2;       /* offset: 0x00000384*/
  //vuint32_t CTRLDESCL6_3;       /* offset: 0x00000388*/
  //vuint32_t CTRLDESCL6_4;       /* offset: 0x0000038C*/
  //vuint32_t CTRLDESCL6_5;       /* offset: 0x00000390*/
  //vuint32_t CTRLDESCL6_6;       /* offset: 0x00000394*/
  //vuint32_t CTRLDESCL6_7;       /* offset: 0x00000398*/
  //vuint32_t CTRLDESCL6_8;       /* offset: 0x0000039C*/
  //vuint32_t CTRLDESCL6_9;       /* offset: 0x000003A0*/
  //vuint8_t RESERVED10[28];                         
  //vuint32_t CTRLDESCL7_1;       /* offset: 0x000003C0*/
  //vuint32_t CTRLDESCL7_2;       /* offset: 0x000003C4*/
  //vuint32_t CTRLDESCL7_3;       /* offset: 0x000003C8*/
  //vuint32_t CTRLDESCL7_4;       /* offset: 0x000003CC*/
  //vuint32_t CTRLDESCL7_5;       /* offset: 0x000003D0*/
  //vuint32_t CTRLDESCL7_6;       /* offset: 0x000003D4*/
  //vuint32_t CTRLDESCL7_7;       /* offset: 0x000003D8*/
  //vuint32_t CTRLDESCL7_8;       /* offset: 0x000003DC*/
  //vuint32_t CTRLDESCL7_9;       /* offset: 0x000003E0*/
  //vuint8_t RESERVED11[28];
  //vuint32_t CTRLDESCL8_1;       /* offset: 0x00000400*/
  //vuint32_t CTRLDESCL8_2;       /* offset: 0x00000404*/
  //vuint32_t CTRLDESCL8_3;       /* offset: 0x00000408*/
  //vuint32_t CTRLDESCL8_4;       /* offset: 0x0000040C*/
  //vuint32_t CTRLDESCL8_5;       /* offset: 0x00000410*/
  //vuint32_t CTRLDESCL8_6;       /* offset: 0x00000414*/
  //vuint32_t CTRLDESCL8_7;       /* offset: 0x00000418*/
  //vuint32_t CTRLDESCL8_8;       /* offset: 0x0000041C*/
  //vuint32_t CTRLDESCL8_9;       /* offset: 0x00000420*/
  //vuint8_t RESERVED12[28];                        
  //vuint32_t CTRLDESCL9_1;       /* offset: 0x00000440*/
  //vuint32_t CTRLDESCL9_2;       /* offset: 0x00000444*/
  //vuint32_t CTRLDESCL9_3;       /* offset: 0x00000448*/
  //vuint32_t CTRLDESCL9_4;       /* offset: 0x0000044C*/
  //vuint32_t CTRLDESCL9_5;       /* offset: 0x00000450*/
  //vuint32_t CTRLDESCL9_6;       /* offset: 0x00000454*/
  //vuint32_t CTRLDESCL9_7;       /* offset: 0x00000458*/
  //vuint32_t CTRLDESCL9_8;       /* offset: 0x0000045C*/
  //vuint32_t CTRLDESCL9_9;       /* offset: 0x00000460*/
  //vuint8_t RESERVED13[28];
  //vuint32_t CTRLDESCL10_1;       /* offset: 0x00000480*/
  //vuint32_t CTRLDESCL10_2;       /* offset: 0x00000484*/
  //vuint32_t CTRLDESCL10_3;       /* offset: 0x00000488*/
  //vuint32_t CTRLDESCL10_4;       /* offset: 0x0000048C*/
  //vuint32_t CTRLDESCL10_5;       /* offset: 0x00000490*/
  //vuint32_t CTRLDESCL10_6;       /* offset: 0x00000494*/
  //vuint32_t CTRLDESCL10_7;       /* offset: 0x00000498*/
  //vuint32_t CTRLDESCL10_8;       /* offset: 0x0000049C*/
  //vuint32_t CTRLDESCL10_9;       /* offset: 0x000004A0*/
  //vuint8_t RESERVED14[28];                         
  //vuint32_t CTRLDESCL11_1;       /* offset: 0x000004C0*/
  //vuint32_t CTRLDESCL11_2;       /* offset: 0x000004C4*/
  //vuint32_t CTRLDESCL11_3;       /* offset: 0x000004C8*/
  //vuint32_t CTRLDESCL11_4;       /* offset: 0x000004CC*/
  //vuint32_t CTRLDESCL11_5;       /* offset: 0x000004D0*/
  //vuint32_t CTRLDESCL11_6;       /* offset: 0x000004D4*/
  //vuint32_t CTRLDESCL11_7;       /* offset: 0x000004D8*/
  //vuint32_t CTRLDESCL11_8;       /* offset: 0x000004DC*/
  //vuint32_t CTRLDESCL11_9;       /* offset: 0x000004E0*/
  //vuint8_t RESERVED15[28];
  //vuint32_t CTRLDESCL12_1;       /* offset: 0x00000500*/
  //vuint32_t CTRLDESCL12_2;       /* offset: 0x00000504*/
  //vuint32_t CTRLDESCL12_3;       /* offset: 0x00000508*/
  //vuint32_t CTRLDESCL12_4;       /* offset: 0x0000050C*/
 // vuint32_t CTRLDESCL12_5;       /* offset: 0x00000510*/
  //vuint32_t CTRLDESCL12_6;       /* offset: 0x00000514*/
  //vuint32_t CTRLDESCL12_7;       /* offset: 0x00000518*/
  //vuint32_t CTRLDESCL12_8;       /* offset: 0x0000051C*/
  //vuint32_t CTRLDESCL12_9;       /* offset: 0x00000520*/
  //vuint8_t RESERVED16[28];                         
 // vuint32_t CTRLDESCL13_1;       /* offset: 0x00000540*/
 // vuint32_t CTRLDESCL13_2;       /* offset: 0x00000544*/
 // vuint32_t CTRLDESCL13_3;       /* offset: 0x00000548*/
  //vuint32_t CTRLDESCL13_4;       /* offset: 0x0000054C*/
  //vuint32_t CTRLDESCL13_5;       /* offset: 0x00000550*/
  //vuint32_t CTRLDESCL13_6;       /* offset: 0x00000554*/
  //vuint32_t CTRLDESCL13_7;       /* offset: 0x00000558*/
  //vuint32_t CTRLDESCL13_8;       /* offset: 0x0000055C*/
  //vuint32_t CTRLDESCL13_9;       /* offset: 0x00000560*/
  //vuint8_t RESERVED17[28];                         
  //vuint32_t CTRLDESCL14_1;       /* offset: 0x00000580*/
  //vuint32_t CTRLDESCL14_2;       /* offset: 0x00000584*/
  //vuint32_t CTRLDESCL14_3;       /* offset: 0x00000588*/
  //vuint32_t CTRLDESCL14_4;       /* offset: 0x0000058C*/
 // vuint32_t CTRLDESCL14_5;       /* offset: 0x00000590*/
 // vuint32_t CTRLDESCL14_6;       /* offset: 0x00000594*/
 // vuint32_t CTRLDESCL14_7;       /* offset: 0x00000598*/
 // vuint32_t CTRLDESCL14_8;       /* offset: 0x0000059C*/
 // vuint32_t CTRLDESCL14_9;       /* offset: 0x000005A0*/
 // vuint8_t RESERVED18[28];                         
 // vuint32_t CTRLDESCL15_1;       /* offset: 0x000005C0*/
 // vuint32_t CTRLDESCL15_2;       /* offset: 0x000005C4*/
 // vuint32_t CTRLDESCL15_3;       /* offset: 0x000005C8*/
 // vuint32_t CTRLDESCL15_4;       /* offset: 0x000005CC*/
 // vuint32_t CTRLDESCL15_5;       /* offset: 0x000005D0*/
  //vuint32_t CTRLDESCL15_6;       /* offset: 0x000005D4*/
  //vvuint32_t CTRLDESCL15_7;       /* offset: 0x000005D8*/
  //vuint32_t CTRLDESCL15_8;       /* offset: 0x000005DC*/
  //vuint32_t CTRLDESCL15_9;       /* offset: 0x000005E0*/
  //vuint8_t RESERVED19[28];
  //vuint32_t CTRLDESCL16_1;       /* offset: 0x00000600*/
  //vuint32_t CTRLDESCL16_2;       /* offset: 0x00000604*/
  //vuint32_t CTRLDESCL16_3;       /* offset: 0x00000608*/
  //vuint32_t CTRLDESCL16_4;       /* offset: 0x0000060C*/
  //vuint32_t CTRLDESCL16_5;       /* offset: 0x00000610*/
  //vuint32_t CTRLDESCL16_6;       /* offset: 0x00000614*/
  //vuint32_t CTRLDESCL16_7;       /* offset: 0x00000618*/
  //vuint32_t CTRLDESCL16_8;       /* offset: 0x0000061C*/
  //vuint32_t CTRLDESCL16_9;       /* offset: 0x00000620*/
  //vuint8_t RESERVED20[28];                         
  //vuint32_t CTRLDESCL17_1;       /* offset: 0x00000640*/
  //vuint32_t CTRLDESCL17_2;       /* offset: 0x00000644*/
  //vuint32_t CTRLDESCL17_3;       /* offset: 0x00000648*/
  //vuint32_t CTRLDESCL17_4;       /* offset: 0x0000064C*/
  //vuint32_t CTRLDESCL17_5;       /* offset: 0x00000650*/
  //vuint32_t CTRLDESCL17_6;       /* offset: 0x00000654*/
  //vuint32_t CTRLDESCL17_7;       /* offset: 0x00000658*/
  //vuint32_t CTRLDESCL17_8;       /* offset: 0x0000065C*/
  //vuint32_t CTRLDESCL17_9;       /* offset: 0x00000660*/
  //vuint8_t RESERVED21[28];                         
  //vuint32_t CTRLDESCL18_1;       /* offset: 0x00000680*/
  //vuint32_t CTRLDESCL18_2;       /* offset: 0x00000684*/
  //vuint32_t CTRLDESCL18_3;       /* offset: 0x00000688*/
  //vuint32_t CTRLDESCL18_4;       /* offset: 0x0000068C*/
  //vuint32_t CTRLDESCL18_5;       /* offset: 0x00000690*/
  //vuint32_t CTRLDESCL18_6;       /* offset: 0x00000694*/
  //vuint32_t CTRLDESCL18_7;       /* offset: 0x00000698*/
  //vuint32_t CTRLDESCL18_8;       /* offset: 0x0000069C*/
  //vuint32_t CTRLDESCL18_9;       /* offset: 0x000006A0*/
  //vuint8_t RESERVED22[28];                         
  //vuint32_t CTRLDESCL19_1;       /* offset: 0x000006C0*/
  //vuint32_t CTRLDESCL19_2;       /* offset: 0x000006C4*/
  //vuint32_t CTRLDESCL19_3;       /* offset: 0x000006C8*/
  //vuint32_t CTRLDESCL19_4;       /* offset: 0x000006CC*/
  //vuint32_t CTRLDESCL19_5;       /* offset: 0x000006D0*/
  //vuint32_t CTRLDESCL19_6;       /* offset: 0x000006D4*/
  //vuint32_t CTRLDESCL19_7;       /* offset: 0x000006D8*/
  //vuint32_t CTRLDESCL19_8;       /* offset: 0x000006DC*/
  //vuint32_t CTRLDESCL19_9;       /* offset: 0x000006E0*/
  //vuint8_t RESERVED23[28];
 // vuint32_t CTRLDESCL20_1;       /* offset: 0x00000700*/
 // vuint32_t CTRLDESCL20_2;       /* offset: 0x00000704*/
 // vuint32_t CTRLDESCL20_3;       /* offset: 0x00000708*/
 // vuint32_t CTRLDESCL20_4;       /* offset: 0x0000070C*/
 // vuint32_t CTRLDESCL20_5;       /* offset: 0x00000710*/
 // vuint32_t CTRLDESCL20_6;       /* offset: 0x00000714*/
 // vuint32_t CTRLDESCL20_7;       /* offset: 0x00000718*/
 // vuint32_t CTRLDESCL20_8;       /* offset: 0x0000071C*/
 // vuint32_t CTRLDESCL20_9;       /* offset: 0x00000720*/
 // vuint8_t RESERVED24[28];                         
 // vuint32_t CTRLDESCL21_1;       /* offset: 0x00000740*/
  //vuint32_t CTRLDESCL21_2;       /* offset: 0x00000744*/
  //vuint32_t CTRLDESCL21_3;       /* offset: 0x00000748*/
  //vuint32_t CTRLDESCL21_4;       /* offset: 0x0000074C*/
  //vuint32_t CTRLDESCL21_5;       /* offset: 0x00000750*/
  //vuint32_t CTRLDESCL21_6;       /* offset: 0x00000754*/
  //vuint32_t CTRLDESCL21_7;       /* offset: 0x00000758*/
  //vuint32_t CTRLDESCL21_8;       /* offset: 0x0000075C*/
  //vuint32_t CTRLDESCL21_9;       /* offset: 0x00000760*/
  //vuint8_t RESERVED25[28];                         
  //vuint32_t CTRLDESCL22_1;       /* offset: 0x00000780*/
  //vuint32_t CTRLDESCL22_2;       /* offset: 0x00000784*/
 // vuint32_t CTRLDESCL22_3;       /* offset: 0x00000788*/
 // vuint32_t CTRLDESCL22_4;       /* offset: 0x0000078C*/
 // vuint32_t CTRLDESCL22_5;       /* offset: 0x00000790*/
 // vuint32_t CTRLDESCL22_6;       /* offset: 0x00000794*/
 // vuint32_t CTRLDESCL22_7;       /* offset: 0x00000798*/
 // vuint32_t CTRLDESCL22_8;       /* offset: 0x0000079C*/
 // vuint32_t CTRLDESCL22_9;       /* offset: 0x000007A0*/
 // vuint8_t RESERVED26[28];                         
 // vuint32_t CTRLDESCL23_1;       /* offset: 0x000007C0*/
 // vuint32_t CTRLDESCL23_2;       /* offset: 0x000007C4*/
 // vuint32_t CTRLDESCL23_3;       /* offset: 0x000007C8*/
 // vuint32_t CTRLDESCL23_4;       /* offset: 0x000007CC*/
 // vuint32_t CTRLDESCL23_5;       /* offset: 0x000007D0*/
 // vuint32_t CTRLDESCL23_6;       /* offset: 0x000007D4*/
 // vuint32_t CTRLDESCL23_7;       /* offset: 0x000007D8*/
 // vuint32_t CTRLDESCL23_8;       /* offset: 0x000007DC*/
 // vuint32_t CTRLDESCL23_9;       /* offset: 0x000007E0*/
 // vuint8_t RESERVED27[28];
 // vuint32_t CTRLDESCL24_1;       /* offset: 0x00000800*/
 // vuint32_t CTRLDESCL24_2;       /* offset: 0x00000804*/
 // vuint32_t CTRLDESCL24_3;       /* offset: 0x00000808*/
 // vuint32_t CTRLDESCL24_4;       /* offset: 0x0000080C*/
 // vuint32_t CTRLDESCL24_5;       /* offset: 0x00000810*/
 // vuint32_t CTRLDESCL24_6;       /* offset: 0x00000814*/
 // vuint32_t CTRLDESCL24_7;       /* offset: 0x00000818*/
 // vuint32_t CTRLDESCL24_8;       /* offset: 0x0000081C*/
 // vuint32_t CTRLDESCL24_9;       /* offset: 0x00000820*/
 // vuint8_t RESERVED28[28];                         
 // vuint32_t CTRLDESCL25_1;       /* offset: 0x00000840*/
 // vuint32_t CTRLDESCL25_2;       /* offset: 0x00000844*/
 // vuint32_t CTRLDESCL25_3;       /* offset: 0x00000848*/
 // vuint32_t CTRLDESCL25_4;       /* offset: 0x0000084C*/
 // vuint32_t CTRLDESCL25_5;       /* offset: 0x00000850*/
 // vuint32_t CTRLDESCL25_6;       /* offset: 0x00000854*/
 // vuint32_t CTRLDESCL25_7;       /* offset: 0x00000858*/
 // vuint32_t CTRLDESCL25_8;       /* offset: 0x0000085C*/
 // vuint32_t CTRLDESCL25_9;       /* offset: 0x00000860*/
 // vuint8_t RESERVED29[28];                         
 // vuint32_t CTRLDESCL26_1;       /* offset: 0x00000880*/
 // vuint32_t CTRLDESCL26_2;       /* offset: 0x00000884*/
 // vuint32_t CTRLDESCL26_3;       /* offset: 0x00000888*/
 // vuint32_t CTRLDESCL26_4;       /* offset: 0x0000088C*/
  // vuint32_t CTRLDESCL26_5;       /* offset: 0x00000890*/
 // vuint32_t CTRLDESCL26_6;       /* offset: 0x00000894*/
//  vuint32_t CTRLDESCL26_7;       /* offset: 0x00000898*/
//  vuint32_t CTRLDESCL26_8;       /* offset: 0x0000089C*/
//  vuint32_t CTRLDESCL26_9;       /* offset: 0x000008A0*/
//  vuint8_t RESERVED30[28];                         
//  vuint32_t CTRLDESCL27_1;       /* offset: 0x000008C0*/
//  vuint32_t CTRLDESCL27_2;       /* offset: 0x000008C4*/
//  vuint32_t CTRLDESCL27_3;       /* offset: 0x000008C8*/
//  vuint32_t CTRLDESCL27_4;       /* offset: 0x000008CC*/
//  vuint32_t CTRLDESCL27_5;       /* offset: 0x000008D0*/
//  vuint32_t CTRLDESCL27_6;       /* offset: 0x000008D4*/
//  vuint32_t CTRLDESCL27_7;       /* offset: 0x000008D8*/
//  vuint32_t CTRLDESCL27_8;       /* offset: 0x000008DC*/
//  vuint32_t CTRLDESCL27_9;       /* offset: 0x000008E0*/
//  vuint8_t RESERVED31[28];
//  vuint32_t CTRLDESCL28_1;       /* offset: 0x00000900*/
//  vuint32_t CTRLDESCL28_2;       /* offset: 0x00000904*/
//  vuint32_t CTRLDESCL28_3;       /* offset: 0x00000908*/
//  vuint32_t CTRLDESCL28_4;       /* offset: 0x0000090C*/
//  vuint32_t CTRLDESCL28_5;       /* offset: 0x00000910*/
//  vuint32_t CTRLDESCL28_6;       /* offset: 0x00000914*/
//  vuint32_t CTRLDESCL28_7;       /* offset: 0x00000918*/
//  vuint32_t CTRLDESCL28_8;       /* offset: 0x0000091C*/
//  vuint32_t CTRLDESCL28_9;       /* offset: 0x00000920*/
//  vuint8_t RESERVED32[28];                         
//  vuint32_t CTRLDESCL29_1;       /* offset: 0x00000940*/
//  vuint32_t CTRLDESCL29_2;       /* offset: 0x00000944*/
//  vuint32_t CTRLDESCL29_3;       /* offset: 0x00000948*/
//  vuint32_t CTRLDESCL29_4;       /* offset: 0x0000094C*/
//  vuint32_t CTRLDESCL29_5;       /* offset: 0x00000950*/
//  vuint32_t CTRLDESCL29_6;       /* offset: 0x00000954*/
//  vuint32_t CTRLDESCL29_7;       /* offset: 0x00000958*/
//  vuint32_t CTRLDESCL29_8;       /* offset: 0x0000095C*/
//  vuint32_t CTRLDESCL29_9;       /* offset: 0x00000960*/
//  vuint8_t RESERVED33[28];                         
//  vuint32_t CTRLDESCL30_1;       /* offset: 0x00000980*/
//  vuint32_t CTRLDESCL30_2;       /* offset: 0x00000984*/
//  vuint32_t CTRLDESCL30_3;       /* offset: 0x00000988*/
//  vuint32_t CTRLDESCL30_4;       /* offset: 0x0000098C*/
//  vuint32_t CTRLDESCL30_5;       /* offset: 0x00000990*/
//  vuint32_t CTRLDESCL30_6;       /* offset: 0x00000994*/
//  vuint32_t CTRLDESCL30_7;       /* offset: 0x00000998*/
//  vuint32_t CTRLDESCL30_8;       /* offset: 0x0000099C*/
//  vuint32_t CTRLDESCL30_9;       /* offset: 0x000009A0*/
//  vuint8_t RESERVED34[28];                         
//  vuint32_t CTRLDESCL31_1;       /* offset: 0x000009C0*/
//  vuint32_t CTRLDESCL31_2;       /* offset: 0x000009C4*/
//  vuint32_t CTRLDESCL31_3;       /* offset: 0x000009C8*/
//  vuint32_t CTRLDESCL31_4;       /* offset: 0x000009CC*/
//  vuint32_t CTRLDESCL31_5;       /* offset: 0x000009D0*/
//  vuint32_t CTRLDESCL31_6;       /* offset: 0x000009D4*/
//  vuint32_t CTRLDESCL31_7;       /* offset: 0x000009D8*/
//  vuint32_t CTRLDESCL31_8;       /* offset: 0x000009DC*/
//  vuint32_t CTRLDESCL31_9;       /* offset: 0x000009E0*/
//  vuint8_t RESERVED36[28];
//  vuint32_t CTRLDESCL32_1;       /* offset: 0x00000A00*/
//  vuint32_t CTRLDESCL32_2;       /* offset: 0x00000A04*/
//  vuint32_t CTRLDESCL32_3;       /* offset: 0x00000A08*/
//  vuint32_t CTRLDESCL32_4;       /* offset: 0x00000A0C*/
//  vuint32_t CTRLDESCL32_5;       /* offset: 0x00000A10*/
//  vuint32_t CTRLDESCL32_6;       /* offset: 0x00000A14*/
//  vuint32_t CTRLDESCL32_7;       /* offset: 0x00000A18*/
//  vuint32_t CTRLDESCL32_8;       /* offset: 0x00000A1C*/
//  vuint32_t CTRLDESCL32_9;       /* offset: 0x00000A20*/
//  vuint8_t RESERVED37[28];                         
//  vuint32_t CTRLDESCL33_1;       /* offset: 0x00000A40*/
//  vuint32_t CTRLDESCL33_2;       /* offset: 0x00000A44*/
//  vuint32_t CTRLDESCL33_3;       /* offset: 0x00000A48*/
//  vuint32_t CTRLDESCL33_4;       /* offset: 0x00000A4C*/
//  vuint32_t CTRLDESCL33_5;       /* offset: 0x00000A50*/
//  vuint32_t CTRLDESCL33_6;       /* offset: 0x00000A54*/
//  vuint32_t CTRLDESCL33_7;       /* offset: 0x00000A58*/
//  vuint32_t CTRLDESCL33_8;       /* offset: 0x00000A5C*/
//  vuint32_t CTRLDESCL33_9;       /* offset: 0x00000A60*/
//  vuint8_t RESERVED38[28];                         
//  vuint32_t CTRLDESCL34_1;       /* offset: 0x00000A80*/
//  vuint32_t CTRLDESCL34_2;       /* offset: 0x00000A84*/
//  vuint32_t CTRLDESCL34_3;       /* offset: 0x00000A88*/
//  vuint32_t CTRLDESCL34_4;       /* offset: 0x00000A8C*/
//  vuint32_t CTRLDESCL34_5;       /* offset: 0x00000A90*/
//  vuint32_t CTRLDESCL34_6;       /* offset: 0x00000A94*/
//  vuint32_t CTRLDESCL34_7;       /* offset: 0x00000A98*/
//  vuint32_t CTRLDESCL34_8;       /* offset: 0x00000A9C*/
//  vuint32_t CTRLDESCL34_9;       /* offset: 0x00000AA0*/
//  vuint8_t RESERVED39[28];                         
//  vuint32_t CTRLDESCL35_1;       /* offset: 0x00000AC0*/
//  vuint32_t CTRLDESCL35_2;       /* offset: 0x00000AC4*/
//  vuint32_t CTRLDESCL35_3;       /* offset: 0x00000AC8*/
//  vuint32_t CTRLDESCL35_4;       /* offset: 0x00000ACC*/
//  vuint32_t CTRLDESCL35_5;       /* offset: 0x00000AD0*/
//  vuint32_t CTRLDESCL35_6;       /* offset: 0x00000AD4*/
//  vuint32_t CTRLDESCL35_7;       /* offset: 0x00000AD8*/
//  vuint32_t CTRLDESCL35_8;       /* offset: 0x00000ADC*/
//  vuint32_t CTRLDESCL35_9;       /* offset: 0x00000AE0*/
//  vuint8_t RESERVED40[28];
//  vuint32_t CTRLDESCL36_1;       /* offset: 0x00000B00*/
//  vuint32_t CTRLDESCL36_2;       /* offset: 0x00000B04*/
//  vuint32_t CTRLDESCL36_3;       /* offset: 0x00000B08*/
//  vuint32_t CTRLDESCL36_4;       /* offset: 0x00000B0C*/
//  vuint32_t CTRLDESCL36_5;       /* offset: 0x00000B10*/
//  vuint32_t CTRLDESCL36_6;       /* offset: 0x00000B14*/
//  vuint32_t CTRLDESCL36_7;       /* offset: 0x00000B18*/
//  vuint32_t CTRLDESCL36_8;       /* offset: 0x00000B1C*/
//  vuint32_t CTRLDESCL36_9;       /* offset: 0x00000B20*/
//  vuint8_t RESERVED41[28];                         
//  vuint32_t CTRLDESCL37_1;       /* offset: 0x00000B40*/
//  vuint32_t CTRLDESCL37_2;       /* offset: 0x00000B44*/
//  vuint32_t CTRLDESCL37_3;       /* offset: 0x00000B48*/
//  vuint32_t CTRLDESCL37_4;       /* offset: 0x00000B4C*/
//  vuint32_t CTRLDESCL37_5;       /* offset: 0x00000B50*/
//  vuint32_t CTRLDESCL37_6;       /* offset: 0x00000B54*/
//  vuint32_t CTRLDESCL37_7;       /* offset: 0x00000B58*/
//  vuint32_t CTRLDESCL37_8;       /* offset: 0x00000B5C*/
//  vuint32_t CTRLDESCL37_9;       /* offset: 0x00000B60*/
//  vuint8_t RESERVED42[28];                         
//  vuint32_t CTRLDESCL38_1;       /* offset: 0x00000B80*/
//  vuint32_t CTRLDESCL38_2;       /* offset: 0x00000B84*/
//  vuint32_t CTRLDESCL38_3;       /* offset: 0x00000B88*/
//  vuint32_t CTRLDESCL38_4;       /* offset: 0x00000B8C*/
//  vuint32_t CTRLDESCL38_5;       /* offset: 0x00000B90*/
//  vuint32_t CTRLDESCL38_6;       /* offset: 0x00000B94*/
//  vuint32_t CTRLDESCL38_7;       /* offset: 0x00000B98*/
//  vuint32_t CTRLDESCL38_8;       /* offset: 0x00000B9C*/
//  vuint32_t CTRLDESCL38_9;       /* offset: 0x00000BA0*/
//  vuint8_t RESERVED43[28];                         
//  vuint32_t CTRLDESCL39_1;       /* offset: 0x00000BC0*/
//  vuint32_t CTRLDESCL39_2;       /* offset: 0x00000BC4*/
//  vuint32_t CTRLDESCL39_3;       /* offset: 0x00000BC8*/
//  vuint32_t CTRLDESCL39_4;       /* offset: 0x00000BCC*/
//  vuint32_t CTRLDESCL39_5;       /* offset: 0x00000BD0*/
//  vuint32_t CTRLDESCL39_6;       /* offset: 0x00000BD4*/
//  vuint32_t CTRLDESCL39_7;       /* offset: 0x00000BD8*/
//  vuint32_t CTRLDESCL39_8;       /* offset: 0x00000BDC*/
//  vuint32_t CTRLDESCL39_9;       /* offset: 0x00000BE0*/
//  vuint8_t RESERVED44[28];
//  vuint32_t CTRLDESCL40_1;       /* offset: 0x00000C00*/
//  vuint32_t CTRLDESCL40_2;       /* offset: 0x00000C04*/
//  vuint32_t CTRLDESCL40_3;       /* offset: 0x00000C08*/
//  vuint32_t CTRLDESCL40_4;       /* offset: 0x00000C0C*/
//  vuint32_t CTRLDESCL40_5;       /* offset: 0x00000C10*/
//  vuint32_t CTRLDESCL40_6;       /* offset: 0x00000C14*/
//  vuint32_t CTRLDESCL40_7;       /* offset: 0x00000C18*/
//  vuint32_t CTRLDESCL40_8;       /* offset: 0x00000C1C*/
//  vuint32_t CTRLDESCL40_9;       /* offset: 0x00000C20*/
//  vuint8_t RESERVED45[28];                         
//  vuint32_t CTRLDESCL41_1;       /* offset: 0x00000C40*/
//  vuint32_t CTRLDESCL41_2;       /* offset: 0x00000C44*/
//  vuint32_t CTRLDESCL41_3;       /* offset: 0x00000C48*/
//  vuint32_t CTRLDESCL41_4;       /* offset: 0x00000C4C*/
//  vuint32_t CTRLDESCL41_5;       /* offset: 0x00000C50*/
//  vuint32_t CTRLDESCL41_6;       /* offset: 0x00000C54*/
//  vuint32_t CTRLDESCL41_7;       /* offset: 0x00000C58*/
//  vuint32_t CTRLDESCL41_8;       /* offset: 0x00000C5C*/
//  vuint32_t CTRLDESCL41_9;       /* offset: 0x00000C60*/
//  vuint8_t RESERVED46[28];                         
//  vuint32_t CTRLDESCL42_1;       /* offset: 0x00000C80*/
//  vuint32_t CTRLDESCL42_2;       /* offset: 0x00000C84*/
//  vuint32_t CTRLDESCL42_3;       /* offset: 0x00000C88*/
//  vuint32_t CTRLDESCL42_4;       /* offset: 0x00000C8C*/
//  vuint32_t CTRLDESCL42_5;       /* offset: 0x00000C90*/
//  vuint32_t CTRLDESCL42_6;       /* offset: 0x00000C94*/
//  vuint32_t CTRLDESCL42_7;       /* offset: 0x00000C98*/
//  vuint32_t CTRLDESCL42_8;       /* offset: 0x00000C9C*/
//  vuint32_t CTRLDESCL42_9;       /* offset: 0x00000CA0*/
//  vuint8_t RESERVED47[28];                         
//  vuint32_t CTRLDESCL43_1;       /* offset: 0x00000CC0*/
//  vuint32_t CTRLDESCL43_2;       /* offset: 0x00000CC4*/
//  vuint32_t CTRLDESCL43_3;       /* offset: 0x00000CC8*/
//  vuint32_t CTRLDESCL43_4;       /* offset: 0x00000CCC*/
//  vuint32_t CTRLDESCL43_5;       /* offset: 0x00000CD0*/
//  vuint32_t CTRLDESCL43_6;       /* offset: 0x00000CD4*/
//  vuint32_t CTRLDESCL43_7;       /* offset: 0x00000CD8*/
//  vuint32_t CTRLDESCL43_8;       /* offset: 0x00000CDC*/
//  vuint32_t CTRLDESCL43_9;       /* offset: 0x00000CE0*/
//  vuint8_t RESERVED48[28];
//  vuint32_t CTRLDESCL44_1;       /* offset: 0x00000D00*/
//  vuint32_t CTRLDESCL44_2;       /* offset: 0x00000D04*/
//  vuint32_t CTRLDESCL44_3;       /* offset: 0x00000D08*/
//  vuint32_t CTRLDESCL44_4;       /* offset: 0x00000D0C*/
//  vuint32_t CTRLDESCL44_5;       /* offset: 0x00000D10*/
//  vuint32_t CTRLDESCL44_6;       /* offset: 0x00000D14*/
//  vuint32_t CTRLDESCL44_7;       /* offset: 0x00000D18*/
//  vuint32_t CTRLDESCL44_8;       /* offset: 0x00000D1C*/
//  vuint32_t CTRLDESCL44_9;       /* offset: 0x00000D20*/
//  vuint8_t RESERVED49[28];                         
//  vuint32_t CTRLDESCL45_1;       /* offset: 0x00000D40*/
//  vuint32_t CTRLDESCL45_2;       /* offset: 0x00000D44*/
//  vuint32_t CTRLDESCL45_3;       /* offset: 0x00000D48*/
//  vuint32_t CTRLDESCL45_4;       /* offset: 0x00000D4C*/
//  vuint32_t CTRLDESCL45_5;       /* offset: 0x00000D50*/
//  vuint32_t CTRLDESCL45_6;       /* offset: 0x00000D54*/
//  vuint32_t CTRLDESCL45_7;       /* offset: 0x00000D58*/
//  vuint32_t CTRLDESCL45_8;       /* offset: 0x00000D5C*/
//  vuint32_t CTRLDESCL45_9;       /* offset: 0x00000D60*/
//  vuint8_t RESERVED50[28];                         
//  vuint32_t CTRLDESCL46_1;       /* offset: 0x00000D80*/
//  vuint32_t CTRLDESCL46_2;       /* offset: 0x00000D84*/
//  vuint32_t CTRLDESCL46_3;       /* offset: 0x00000D88*/
//  vuint32_t CTRLDESCL46_4;       /* offset: 0x00000D8C*/
//  vuint32_t CTRLDESCL46_5;       /* offset: 0x00000D90*/
//  vuint32_t CTRLDESCL46_6;       /* offset: 0x00000D94*/
//  vuint32_t CTRLDESCL46_7;       /* offset: 0x00000D98*/
//  vuint32_t CTRLDESCL46_8;       /* offset: 0x00000D9C*/
//  vuint32_t CTRLDESCL46_9;       /* offset: 0x00000DA0*/
//  vuint8_t RESERVED51[28];                         
//  vuint32_t CTRLDESCL47_1;       /* offset: 0x00000DC0*/
//  vuint32_t CTRLDESCL47_2;       /* offset: 0x00000DC4*/
//  vuint32_t CTRLDESCL47_3;       /* offset: 0x00000DC8*/
//  vuint32_t CTRLDESCL47_4;       /* offset: 0x00000DCC*/
//  vuint32_t CTRLDESCL47_5;       /* offset: 0x00000DD0*/
//  vuint32_t CTRLDESCL47_6;       /* offset: 0x00000DD4*/
//  vuint32_t CTRLDESCL47_7;       /* offset: 0x00000DD8*/
//  vuint32_t CTRLDESCL47_8;       /* offset: 0x00000DDC*/
//  vuint32_t CTRLDESCL47_9;       /* offset: 0x00000DE0*/
//  vuint8_t RESERVED52[28];
//  vuint32_t CTRLDESCL48_1;       /* offset: 0x00000E00*/
//  vuint32_t CTRLDESCL48_2;       /* offset: 0x00000E04*/
//  vuint32_t CTRLDESCL48_3;       /* offset: 0x00000E08*/
//  vuint32_t CTRLDESCL48_4;       /* offset: 0x00000E0C*/
//  vuint32_t CTRLDESCL48_5;       /* offset: 0x00000E10*/
//  vuint32_t CTRLDESCL48_6;       /* offset: 0x00000E14*/
//  vuint32_t CTRLDESCL48_7;       /* offset: 0x00000E18*/
//  vuint32_t CTRLDESCL48_8;       /* offset: 0x00000E1C*/
//  vuint32_t CTRLDESCL48_9;       /* offset: 0x00000E20*/
//  vuint8_t RESERVED53[28];                         
//  vuint32_t CTRLDESCL49_1;       /* offset: 0x00000E40*/
//  vuint32_t CTRLDESCL49_2;       /* offset: 0x00000E44*/
//  vuint32_t CTRLDESCL49_3;       /* offset: 0x00000E48*/
//  vuint32_t CTRLDESCL49_4;       /* offset: 0x00000E4C*/
//  vuint32_t CTRLDESCL49_5;       /* offset: 0x00000E50*/
//  vuint32_t CTRLDESCL49_6;       /* offset: 0x00000E54*/
//  vuint32_t CTRLDESCL49_7;       /* offset: 0x00000E58*/
//  vuint32_t CTRLDESCL49_8;       /* offset: 0x00000E5C*/
//  vuint32_t CTRLDESCL49_9;       /* offset: 0x00000E60*/
//  vuint8_t RESERVED54[28];                         
//  vuint32_t CTRLDESCL50_1;       /* offset: 0x00000E80*/
//  vuint32_t CTRLDESCL50_2;       /* offset: 0x00000E84*/
//  vuint32_t CTRLDESCL50_3;       /* offset: 0x00000E88*/
//  vuint32_t CTRLDESCL50_4;       /* offset: 0x00000E8C*/
//  vuint32_t CTRLDESCL50_5;       /* offset: 0x00000E90*/
//  vuint32_t CTRLDESCL50_6;       /* offset: 0x00000E94*/
//  vuint32_t CTRLDESCL50_7;       /* offset: 0x00000E98*/
//  vuint32_t CTRLDESCL50_8;       /* offset: 0x00000E9C*/
//  vuint32_t CTRLDESCL50_9;       /* offset: 0x00000EA0*/
//  vuint8_t RESERVED55[28];                         
//  vuint32_t CTRLDESCL51_1;       /* offset: 0x00000EC0*/
//  vuint32_t CTRLDESCL51_2;       /* offset: 0x00000EC4*/
//  vuint32_t CTRLDESCL51_3;       /* offset: 0x00000EC8*/
//  vuint32_t CTRLDESCL51_4;       /* offset: 0x00000ECC*/
//  vuint32_t CTRLDESCL51_5;       /* offset: 0x00000ED0*/
//  vuint32_t CTRLDESCL51_6;       /* offset: 0x00000ED4*/
//  vuint32_t CTRLDESCL51_7;       /* offset: 0x00000ED8*/
//  vuint32_t CTRLDESCL51_8;       /* offset: 0x00000EDC*/
//  vuint32_t CTRLDESCL51_9;       /* offset: 0x00000EE0*/
//  vuint8_t RESERVED56[28];
//  vuint32_t CTRLDESCL52_1;       /* offset: 0x00000F00*/
//  vuint32_t CTRLDESCL52_2;       /* offset: 0x00000F04*/
//  vuint32_t CTRLDESCL52_3;       /* offset: 0x00000F08*/
//  vuint32_t CTRLDESCL52_4;       /* offset: 0x00000F0C*/
//  vuint32_t CTRLDESCL52_5;       /* offset: 0x00000F10*/
//  vuint32_t CTRLDESCL52_6;       /* offset: 0x00000F14*/
//  vuint32_t CTRLDESCL52_7;       /* offset: 0x00000F18*/
//  vuint32_t CTRLDESCL52_8;       /* offset: 0x00000F1C*/
//  vuint32_t CTRLDESCL52_9;       /* offset: 0x00000F20*/
//  vuint8_t RESERVED57[28];                         
//  vuint32_t CTRLDESCL53_1;       /* offset: 0x00000F40*/
//  vuint32_t CTRLDESCL53_2;       /* offset: 0x00000F44*/
//  vuint32_t CTRLDESCL53_3;       /* offset: 0x00000F48*/
//  vuint32_t CTRLDESCL53_4;       /* offset: 0x00000F4C*/
//  vuint32_t CTRLDESCL53_5;       /* offset: 0x00000F50*/
//  vuint32_t CTRLDESCL53_6;       /* offset: 0x00000F54*/
//  vuint32_t CTRLDESCL53_7;       /* offset: 0x00000F58*/
//  vuint32_t CTRLDESCL53_8;       /* offset: 0x00000F5C*/
//  vuint32_t CTRLDESCL53_9;       /* offset: 0x00000F60*/
//  vuint8_t RESERVED58[28];                         
//  vuint32_t CTRLDESCL54_1;       /* offset: 0x00000F80*/
//  vuint32_t CTRLDESCL54_2;       /* offset: 0x00000F84*/
//  vuint32_t CTRLDESCL54_3;       /* offset: 0x00000F88*/
//  vuint32_t CTRLDESCL54_4;       /* offset: 0x00000F8C*/
//  vuint32_t CTRLDESCL54_5;       /* offset: 0x00000F90*/
//  vuint32_t CTRLDESCL54_6;       /* offset: 0x00000F94*/
//  vuint32_t CTRLDESCL54_7;       /* offset: 0x00000F98*/
//  vuint32_t CTRLDESCL54_8;       /* offset: 0x00000F9C*/
//  vuint32_t CTRLDESCL54_9;       /* offset: 0x00000FA0*/
//  vuint8_t RESERVED59[28];                         
//  vuint32_t CTRLDESCL55_1;       /* offset: 0x00000FC0*/
//  vuint32_t CTRLDESCL55_2;       /* offset: 0x00000FC4*/
//  vuint32_t CTRLDESCL55_3;       /* offset: 0x00000FC8*/
//  vuint32_t CTRLDESCL55_4;       /* offset: 0x00000FCC*/
//  vuint32_t CTRLDESCL55_5;       /* offset: 0x00000FD0*/
//  vuint32_t CTRLDESCL55_6;       /* offset: 0x00000FD4*/
//  vuint32_t CTRLDESCL55_7;       /* offset: 0x00000FD8*/
//  vuint32_t CTRLDESCL55_8;       /* offset: 0x00000FDC*/
//  vuint32_t CTRLDESCL55_9;       /* offset: 0x00000FE0*/
//  vuint8_t RESERVED60[28];
//  vuint32_t CTRLDESCL56_1;       /* offset: 0x00001000*/
//  vuint32_t CTRLDESCL56_2;       /* offset: 0x00001004*/
//  vuint32_t CTRLDESCL56_3;       /* offset: 0x00001008*/
//  vuint32_t CTRLDESCL56_4;       /* offset: 0x0000100C*/
//  vuint32_t CTRLDESCL56_5;       /* offset: 0x00001010*/
//  vuint32_t CTRLDESCL56_6;       /* offset: 0x00001014*/
//  vuint32_t CTRLDESCL56_7;       /* offset: 0x00001018*/
//  vuint32_t CTRLDESCL56_8;       /* offset: 0x0000101C*/
//  vuint32_t CTRLDESCL56_9;       /* offset: 0x00001020*/
//  vuint8_t RESERVED61[28];                        
//  vuint32_t CTRLDESCL57_1;       /* offset: 0x00001040*/
//  vuint32_t CTRLDESCL57_2;       /* offset: 0x00001044*/
//  vuint32_t CTRLDESCL57_3;       /* offset: 0x00001048*/
//  vuint32_t CTRLDESCL57_4;       /* offset: 0x0000104C*/
//  vuint32_t CTRLDESCL57_5;       /* offset: 0x00001050*/
//  vuint32_t CTRLDESCL57_6;       /* offset: 0x00001054*/
//  vuint32_t CTRLDESCL57_7;       /* offset: 0x00001058*/
//  vuint32_t CTRLDESCL57_8;       /* offset: 0x0000105C*/
//  vuint32_t CTRLDESCL57_9;       /* offset: 0x00001060*/
//  vuint8_t RESERVED62[28];                        
//  vuint32_t CTRLDESCL58_1;       /* offset: 0x00001080*/
//  vuint32_t CTRLDESCL58_2;       /* offset: 0x00001084*/
//  vuint32_t CTRLDESCL58_3;       /* offset: 0x00001088*/
//  vuint32_t CTRLDESCL58_4;       /* offset: 0x0000108C*/
//  vuint32_t CTRLDESCL58_5;       /* offset: 0x00001090*/
//  vuint32_t CTRLDESCL58_6;       /* offset: 0x00001094*/
//  vuint32_t CTRLDESCL58_7;       /* offset: 0x00001098*/
//  vuint32_t CTRLDESCL58_8;       /* offset: 0x0000109C*/
//  vuint32_t CTRLDESCL58_9;       /* offset: 0x000010A0*/
//  vuint8_t RESERVED63[28];                        
//  vuint32_t CTRLDESCL59_1;       /* offset: 0x000010C0*/
//  vuint32_t CTRLDESCL59_2;       /* offset: 0x000010C4*/
//  vuint32_t CTRLDESCL59_3;       /* offset: 0x000010C8*/
//  vuint32_t CTRLDESCL59_4;       /* offset: 0x000010CC*/
//  vuint32_t CTRLDESCL59_5;       /* offset: 0x000010D0*/
//  vuint32_t CTRLDESCL59_6;       /* offset: 0x000010D4*/
//  vuint32_t CTRLDESCL59_7;       /* offset: 0x000010D8*/
//  vuint32_t CTRLDESCL59_8;       /* offset: 0x000010DC*/
//  vuint32_t CTRLDESCL59_9;       /* offset: 0x000010E0*/
//  vuint8_t RESERVED64[28];                        
//  vuint32_t CTRLDESCL60_1;       /* offset: 0x00001100*/
//  vuint32_t CTRLDESCL60_2;       /* offset: 0x00001104*/
//  vuint32_t CTRLDESCL60_3;       /* offset: 0x00001108*/
//  vuint32_t CTRLDESCL60_4;       /* offset: 0x0000110C*/
//  vuint32_t CTRLDESCL60_5;       /* offset: 0x00001110*/
//  vuint32_t CTRLDESCL60_6;       /* offset: 0x00001114*/
//  vuint32_t CTRLDESCL60_7;       /* offset: 0x00001118*/
//  vuint32_t CTRLDESCL60_8;       /* offset: 0x0000111C*/
//  vuint32_t CTRLDESCL60_9;       /* offset: 0x00001120*/
//  vuint8_t RESERVED65[28];                        
//  vuint32_t CTRLDESCL61_1;       /* offset: 0x00001140*/
//  vuint32_t CTRLDESCL61_2;       /* offset: 0x00001144*/
//  vuint32_t CTRLDESCL61_3;       /* offset: 0x00001148*/
//  vuint32_t CTRLDESCL61_4;       /* offset: 0x0000114C*/
//  vuint32_t CTRLDESCL61_5;       /* offset: 0x00001150*/
//  vuint32_t CTRLDESCL61_6;       /* offset: 0x00001154*/
//  vuint32_t CTRLDESCL61_7;       /* offset: 0x00001158*/
//  vuint32_t CTRLDESCL61_8;       /* offset: 0x0000115C*/
//  vuint32_t CTRLDESCL61_9;       /* offset: 0x00001160*/
//  vuint8_t RESERVED66[28];                        
//  vuint32_t CTRLDESCL62_1;       /* offset: 0x00001180*/
//  vuint32_t CTRLDESCL62_2;       /* offset: 0x00001184*/
//  vuint32_t CTRLDESCL62_3;       /* offset: 0x00001188*/
//  vuint32_t CTRLDESCL62_4;       /* offset: 0x0000118C*/
//  vuint32_t CTRLDESCL62_5;       /* offset: 0x00001190*/
//  vuint32_t CTRLDESCL62_6;       /* offset: 0x00001194*/
//  vuint32_t CTRLDESCL62_7;       /* offset: 0x00001198*/
//  vuint32_t CTRLDESCL62_8;       /* offset: 0x0000119C*/
//  vuint32_t CTRLDESCL62_9;       /* offset: 0x000011A0*/
//  vuint8_t RESERVED67[28];                        
//  vuint32_t CTRLDESCL63_1;       /* offset: 0x000011C0*/
//  vuint32_t CTRLDESCL63_2;       /* offset: 0x000011C4*/
//  vuint32_t CTRLDESCL63_3;       /* offset: 0x000011C8*/
//  vuint32_t CTRLDESCL63_4;       /* offset: 0x000011CC*/
//  vuint32_t CTRLDESCL63_5;       /* offset: 0x000011D0*/
//  vuint32_t CTRLDESCL63_6;       /* offset: 0x000011D4*/
//  vuint32_t CTRLDESCL63_7;       /* offset: 0x000011D8*/
//  vuint32_t CTRLDESCL63_8;       /* offset: 0x000011DC*/
//  vuint32_t CTRLDESCL63_9;       /* offset: 0x000011E0*/
  vuint8_t RESERVED68[3583];  
  vuint32_t CLUT[0x2000];      	 /* offset: 0x00002000*/
  vuint32_t GAMMARED[0x400];      		 /* offset: 0x00004000*/
  vuint32_t GAMMAGREEN[0x400];      	 /* offset: 0x00004400*/
  vuint32_t GAMMABLUE[0x400];      	 /* offset: 0x00004800*/
  vuint32_t GAMMACURSOR[0x400];      	 /* offset: 0x00004C00*/
};
  
  
/* DCU - Internal RAM Offsets */
#define DCU_CLUT_OFFSET				0x00002000
#define DCU_GAMMARED_OFFSET			0x00004000
#define DCU_GAMMAGREEN_OFFSET			0x00004400
#define DCU_GAMMABLUE_OFFSET			0x00004800
#define DCU_CURSOR_OFFSET			0x00004C00


/* DCU Internal RAM per module */
#define DCU0_CLUT          		(DCU0_BASE + DCU_CLUT_OFFSET)
#define DCU0_GAMMARED          		(DCU0_BASE + DCU_GAMMARED_OFFSET)
#define DCU0_GAMMAGREEN          	(DCU0_BASE + DCU_GAMMAGREEN_OFFSET)
#define DCU0_GAMMABLUE          	(DCU0_BASE + DCU_GAMMABLUE_OFFSET)
#define DCU0_CURSOR              	(DCU0_BASE + DCU_CURSOR_OFFSET)

#define DCU1_CLUT          		(DCU1_BASE + DCU_CLUT_OFFSET)
#define DCU1_GAMMARED          		(DCU1_BASE + DCU_GAMMARED_OFFSET)
#define DCU1_GAMMAGREEN          	(DCU1_BASE + DCU_GAMMAGREEN_OFFSET)
#define DCU1_GAMMABLUE          	(DCU1_BASE + DCU_GAMMABLUE_OFFSET)
#define DCU1_CURSOR         	        (DCU1_BASE + DCU_CURSOR_OFFSET)


/* DCU - Register offsets */
#define DCU_CTRLDESCCURSOR1_OFFSET      0x00000000
#define DCU_CTRLDESCCURSOR2_OFFSET      0x00000004
#define DCU_CTRLDESCCURSOR3_OFFSET      0x00000008
#define DCU_CTRLDESCCURSOR4_OFFSET      0x0000000C
#define DCU_DCU_MODE_OFFSET             0x00000010
#define DCU_BGND_OFFSET                 0x00000014
#define DCU_DISP_SIZE_OFFSET            0x00000018
#define DCU_HSYN_PARA_OFFSET            0x0000001C
#define DCU_VSYN_PARA_OFFSET            0x00000020
#define DCU_SYNPOL_OFFSET               0x00000024
#define DCU_THRESHOLD_OFFSET            0x00000028
#define DCU_INT_STATUS_OFFSET           0x0000002C
#define DCU_INT_MASK_OFFSET             0x00000030
#define DCU_COLBAR_1_OFFSET             0x00000034
#define DCU_COLBAR_2_OFFSET             0x00000038
#define DCU_COLBAR_3_OFFSET             0x0000003C
#define DCU_COLBAR_4_OFFSET             0x00000040
#define DCU_COLBAR_5_OFFSET             0x00000044
#define DCU_COLBAR_6_OFFSET             0x00000048
#define DCU_COLBAR_7_OFFSET             0x0000004C
#define DCU_COLBAR_8_OFFSET             0x00000050
#define DCU_DIV_RATIO_OFFSET            0x00000054
#define DCU_SIGN_CALC_1_OFFSET          0x00000058
#define DCU_SIGN_CALC_2_OFFSET          0x0000005C
#define DCU_CRC_VAL_OFFSET              0x00000060
#define DCU_PARR_ERR_STATUS1_OFFSET     0x0000006C
#define DCU_PARR_ERR_STATUS2_OFFSET     0x00000070
#define DCU_PARR_ERR_STATUS3_OFFSET     0x0000007C
#define DCU_MASK_PARR_ERR_STATUS1_OFFSET 0x00000080
#define DCU_MASK_PARR_ERR_STATUS2_OFFSET 0x00000084
#define DCU_MASK_PARR_ERR_STATUS3_OFFSET 0x00000090
#define DCU_THRESHOLD_INP_BUF_1_OFFSET  0x00000094
#define DCU_THRESHOLD_INP_BUF_2_OFFSET  0x00000098
#define DCU_THRESHOLD_INP_BUF_3_OFFSET  0x0000009C
#define DCU_LUMA_COMP_OFFSET            0x000000A0
#define DCU_CHROMA_RED_OFFSET           0x000000A4
#define DCU_CHROMA_GREEN_OFFSET         0x000000A8
#define DCU_CHROMA_BLUE_OFFSET          0x000000AC
#define DCU_CRC_POS_OFFSET              0x000000B0
#define DCU_LYR_INTPOL_EN_OFFSET        0x000000B4
#define DCU_LYR_LUMA_COMP_OFFSET        0x000000B8
#define DCU_LYR_CHROMA_RED_OFFSET       0x000000BC
#define DCU_LYR_CHROMA_GREEN_OFFSET     0x000000C0
#define DCU_LYR_CHROMA_BLUE_OFFSET      0x000000C4
#define DCU_COMP_IMSIZE_OFFSET          0x000000C8
#define DCU_UPDATE_MODE_OFFSET          0x000000CC
#define DCU_UNDERRUN_OFFSET             0x000000D0
#define DCU_GPR_OFFSET                  0x00000100
#define DCU_SLR_L0_OFFSET               0x00000104
#define DCU_SLR_L1_OFFSET               0x00000108
#define DCU_SLR_DISP_SIZE_OFFSET        0x0000010C
#define DCU_SLR_HVSYNC_PARA_OFFSET      0x00000110
#define DCU_SLR_POL_OFFSET              0x00000114
#define DCU_SLR_L0TRANSP_OFFSET         0x00000118
#define DCU_SLR_L1TRANSP_OFFSET         0x0000011C
#define DCU_CTRLDESCL0_1_OFFSET         0x00000200
#define DCU_CTRLDESCL0_2_OFFSET         0x00000204
#define DCU_CTRLDESCL0_3_OFFSET         0x00000208
#define DCU_CTRLDESCL0_4_OFFSET         0x0000020C
#define DCU_CTRLDESCL0_5_OFFSET         0x00000210
#define DCU_CTRLDESCL0_6_OFFSET         0x00000214
#define DCU_CTRLDESCL0_7_OFFSET         0x00000218
#define DCU_CTRLDESCL0_8_OFFSET         0x0000021C
#define DCU_CTRLDESCL0_9_OFFSET         0x00000220
#define DCU_CTRLDESCL1_1_OFFSET         0x00000240
#define DCU_CTRLDESCL1_2_OFFSET         0x00000244
#define DCU_CTRLDESCL1_3_OFFSET         0x00000248
#define DCU_CTRLDESCL1_4_OFFSET         0x0000024C
#define DCU_CTRLDESCL1_5_OFFSET         0x00000250
#define DCU_CTRLDESCL1_6_OFFSET         0x00000254
#define DCU_CTRLDESCL1_7_OFFSET         0x00000258
#define DCU_CTRLDESCL1_8_OFFSET         0x0000025C
#define DCU_CTRLDESCL1_9_OFFSET         0x00000260
#define DCU_CTRLDESCL2_1_OFFSET         0x00000280
#define DCU_CTRLDESCL2_2_OFFSET         0x00000284
#define DCU_CTRLDESCL2_3_OFFSET         0x00000288
#define DCU_CTRLDESCL2_4_OFFSET         0x0000028C
#define DCU_CTRLDESCL2_5_OFFSET         0x00000290
#define DCU_CTRLDESCL2_6_OFFSET         0x00000294
#define DCU_CTRLDESCL2_7_OFFSET         0x00000298
#define DCU_CTRLDESCL2_8_OFFSET         0x0000029C
#define DCU_CTRLDESCL2_9_OFFSET         0x000002A0
#define DCU_CTRLDESCL3_1_OFFSET         0x000002C0
#define DCU_CTRLDESCL3_2_OFFSET         0x000002C4
#define DCU_CTRLDESCL3_3_OFFSET         0x000002C8
#define DCU_CTRLDESCL3_4_OFFSET         0x000002CC
#define DCU_CTRLDESCL3_5_OFFSET         0x000002D0
#define DCU_CTRLDESCL3_6_OFFSET         0x000002D4
#define DCU_CTRLDESCL3_7_OFFSET         0x000002D8
#define DCU_CTRLDESCL3_8_OFFSET         0x000002DC
#define DCU_CTRLDESCL3_9_OFFSET         0x000002E0
#define DCU_CTRLDESCL4_1_OFFSET         0x00000300
#define DCU_CTRLDESCL4_2_OFFSET         0x00000304
#define DCU_CTRLDESCL4_3_OFFSET         0x00000308
#define DCU_CTRLDESCL4_4_OFFSET         0x0000030C
#define DCU_CTRLDESCL4_5_OFFSET         0x00000310
#define DCU_CTRLDESCL4_6_OFFSET         0x00000314
#define DCU_CTRLDESCL4_7_OFFSET         0x00000318
#define DCU_CTRLDESCL4_8_OFFSET         0x0000031C
#define DCU_CTRLDESCL4_9_OFFSET         0x00000320
#define DCU_CTRLDESCL5_1_OFFSET         0x00000340
#define DCU_CTRLDESCL5_2_OFFSET         0x00000344
#define DCU_CTRLDESCL5_3_OFFSET         0x00000348
#define DCU_CTRLDESCL5_4_OFFSET         0x0000034C
#define DCU_CTRLDESCL5_5_OFFSET         0x00000350
#define DCU_CTRLDESCL5_6_OFFSET         0x00000354
#define DCU_CTRLDESCL5_7_OFFSET         0x00000358
#define DCU_CTRLDESCL5_8_OFFSET         0x0000035C
#define DCU_CTRLDESCL5_9_OFFSET         0x00000360
#define DCU_CTRLDESCL6_1_OFFSET         0x00000380
#define DCU_CTRLDESCL6_2_OFFSET         0x00000384
#define DCU_CTRLDESCL6_3_OFFSET         0x00000388
#define DCU_CTRLDESCL6_4_OFFSET         0x0000038C
#define DCU_CTRLDESCL6_5_OFFSET         0x00000390
#define DCU_CTRLDESCL6_6_OFFSET         0x00000394
#define DCU_CTRLDESCL6_7_OFFSET         0x00000398
#define DCU_CTRLDESCL6_8_OFFSET         0x0000039C
#define DCU_CTRLDESCL6_9_OFFSET         0x000003A0
#define DCU_CTRLDESCL7_1_OFFSET         0x000003C0
#define DCU_CTRLDESCL7_2_OFFSET         0x000003C4
#define DCU_CTRLDESCL7_3_OFFSET         0x000003C8
#define DCU_CTRLDESCL7_4_OFFSET         0x000003CC
#define DCU_CTRLDESCL7_5_OFFSET         0x000003D0
#define DCU_CTRLDESCL7_6_OFFSET         0x000003D4
#define DCU_CTRLDESCL7_7_OFFSET         0x000003D8
#define DCU_CTRLDESCL7_8_OFFSET         0x000003DC
#define DCU_CTRLDESCL7_9_OFFSET         0x000003E0
#define DCU_CTRLDESCL8_1_OFFSET         0x00000400
#define DCU_CTRLDESCL8_2_OFFSET         0x00000404
#define DCU_CTRLDESCL8_3_OFFSET         0x00000408
#define DCU_CTRLDESCL8_4_OFFSET         0x0000040C
#define DCU_CTRLDESCL8_5_OFFSET         0x00000410
#define DCU_CTRLDESCL8_6_OFFSET         0x00000414
#define DCU_CTRLDESCL8_7_OFFSET         0x00000418
#define DCU_CTRLDESCL8_8_OFFSET         0x0000041C
#define DCU_CTRLDESCL8_9_OFFSET         0x00000420
#define DCU_CTRLDESCL9_1_OFFSET         0x00000440
#define DCU_CTRLDESCL9_2_OFFSET         0x00000444
#define DCU_CTRLDESCL9_3_OFFSET         0x00000448
#define DCU_CTRLDESCL9_4_OFFSET         0x0000044C
#define DCU_CTRLDESCL9_5_OFFSET         0x00000450
#define DCU_CTRLDESCL9_6_OFFSET         0x00000454
#define DCU_CTRLDESCL9_7_OFFSET         0x00000458
#define DCU_CTRLDESCL9_8_OFFSET         0x0000045C
#define DCU_CTRLDESCL9_9_OFFSET         0x00000460
#define DCU_CTRLDESCL10_1_OFFSET        0x00000480
#define DCU_CTRLDESCL10_2_OFFSET        0x00000484
#define DCU_CTRLDESCL10_3_OFFSET        0x00000488
#define DCU_CTRLDESCL10_4_OFFSET        0x0000048C
#define DCU_CTRLDESCL10_5_OFFSET        0x00000490
#define DCU_CTRLDESCL10_6_OFFSET        0x00000494
#define DCU_CTRLDESCL10_7_OFFSET        0x00000498
#define DCU_CTRLDESCL10_8_OFFSET        0x0000049C
#define DCU_CTRLDESCL10_9_OFFSET        0x000004A0
#define DCU_CTRLDESCL11_1_OFFSET        0x000004C0
#define DCU_CTRLDESCL11_2_OFFSET        0x000004C4
#define DCU_CTRLDESCL11_3_OFFSET        0x000004C8
#define DCU_CTRLDESCL11_4_OFFSET        0x000004CC
#define DCU_CTRLDESCL11_5_OFFSET        0x000004D0
#define DCU_CTRLDESCL11_6_OFFSET        0x000004D4
#define DCU_CTRLDESCL11_7_OFFSET        0x000004D8
#define DCU_CTRLDESCL11_8_OFFSET        0x000004DC
#define DCU_CTRLDESCL11_9_OFFSET        0x000004E0
#define DCU_CTRLDESCL12_1_OFFSET        0x00000500
#define DCU_CTRLDESCL12_2_OFFSET        0x00000504
#define DCU_CTRLDESCL12_3_OFFSET        0x00000508
#define DCU_CTRLDESCL12_4_OFFSET        0x0000050C
#define DCU_CTRLDESCL12_5_OFFSET        0x00000510
#define DCU_CTRLDESCL12_6_OFFSET        0x00000514
#define DCU_CTRLDESCL12_7_OFFSET        0x00000518
#define DCU_CTRLDESCL12_8_OFFSET        0x0000051C
#define DCU_CTRLDESCL12_9_OFFSET        0x00000520
#define DCU_CTRLDESCL13_1_OFFSET        0x00000540
#define DCU_CTRLDESCL13_2_OFFSET        0x00000544
#define DCU_CTRLDESCL13_3_OFFSET        0x00000548
#define DCU_CTRLDESCL13_4_OFFSET        0x0000054C
#define DCU_CTRLDESCL13_5_OFFSET        0x00000550
#define DCU_CTRLDESCL13_6_OFFSET        0x00000554
#define DCU_CTRLDESCL13_7_OFFSET        0x00000558
#define DCU_CTRLDESCL13_8_OFFSET        0x0000055C
#define DCU_CTRLDESCL13_9_OFFSET        0x00000560
#define DCU_CTRLDESCL14_1_OFFSET        0x00000580
#define DCU_CTRLDESCL14_2_OFFSET        0x00000584
#define DCU_CTRLDESCL14_3_OFFSET        0x00000588
#define DCU_CTRLDESCL14_4_OFFSET        0x0000058C
#define DCU_CTRLDESCL14_5_OFFSET        0x00000590
#define DCU_CTRLDESCL14_6_OFFSET        0x00000594
#define DCU_CTRLDESCL14_7_OFFSET        0x00000598
#define DCU_CTRLDESCL14_8_OFFSET        0x0000059C
#define DCU_CTRLDESCL14_9_OFFSET        0x000005A0
#define DCU_CTRLDESCL15_1_OFFSET        0x000005C0
#define DCU_CTRLDESCL15_2_OFFSET        0x000005C4
#define DCU_CTRLDESCL15_3_OFFSET        0x000005C8
#define DCU_CTRLDESCL15_4_OFFSET        0x000005CC
#define DCU_CTRLDESCL15_5_OFFSET        0x000005D0
#define DCU_CTRLDESCL15_6_OFFSET        0x000005D4
#define DCU_CTRLDESCL15_7_OFFSET        0x000005D8
#define DCU_CTRLDESCL15_8_OFFSET        0x000005DC
#define DCU_CTRLDESCL15_9_OFFSET        0x000005E0
#define DCU_CTRLDESCL16_1_OFFSET        0x00000600
#define DCU_CTRLDESCL16_2_OFFSET        0x00000604
#define DCU_CTRLDESCL16_3_OFFSET        0x00000608
#define DCU_CTRLDESCL16_4_OFFSET        0x0000060C
#define DCU_CTRLDESCL16_5_OFFSET        0x00000610
#define DCU_CTRLDESCL16_6_OFFSET        0x00000614
#define DCU_CTRLDESCL16_7_OFFSET        0x00000618
#define DCU_CTRLDESCL16_8_OFFSET        0x0000061C
#define DCU_CTRLDESCL16_9_OFFSET        0x00000620
#define DCU_CTRLDESCL17_1_OFFSET        0x00000640
#define DCU_CTRLDESCL17_2_OFFSET        0x00000644
#define DCU_CTRLDESCL17_3_OFFSET        0x00000648
#define DCU_CTRLDESCL17_4_OFFSET        0x0000064C
#define DCU_CTRLDESCL17_5_OFFSET        0x00000650
#define DCU_CTRLDESCL17_6_OFFSET        0x00000654
#define DCU_CTRLDESCL17_7_OFFSET        0x00000658
#define DCU_CTRLDESCL17_8_OFFSET        0x0000065C
#define DCU_CTRLDESCL17_9_OFFSET        0x00000660
#define DCU_CTRLDESCL18_1_OFFSET        0x00000680
#define DCU_CTRLDESCL18_2_OFFSET        0x00000684
#define DCU_CTRLDESCL18_3_OFFSET        0x00000688
#define DCU_CTRLDESCL18_4_OFFSET        0x0000068C
#define DCU_CTRLDESCL18_5_OFFSET        0x00000690
#define DCU_CTRLDESCL18_6_OFFSET        0x00000694
#define DCU_CTRLDESCL18_7_OFFSET        0x00000698
#define DCU_CTRLDESCL18_8_OFFSET        0x0000069C
#define DCU_CTRLDESCL18_9_OFFSET        0x000006A0
#define DCU_CTRLDESCL19_1_OFFSET        0x000006C0
#define DCU_CTRLDESCL19_2_OFFSET        0x000006C4
#define DCU_CTRLDESCL19_3_OFFSET        0x000006C8
#define DCU_CTRLDESCL19_4_OFFSET        0x000006CC
#define DCU_CTRLDESCL19_5_OFFSET        0x000006D0
#define DCU_CTRLDESCL19_6_OFFSET        0x000006D4
#define DCU_CTRLDESCL19_7_OFFSET        0x000006D8
#define DCU_CTRLDESCL19_8_OFFSET        0x000006DC
#define DCU_CTRLDESCL19_9_OFFSET        0x000006E0
#define DCU_CTRLDESCL20_1_OFFSET        0x00000700
#define DCU_CTRLDESCL20_2_OFFSET        0x00000704
#define DCU_CTRLDESCL20_3_OFFSET        0x00000708
#define DCU_CTRLDESCL20_4_OFFSET        0x0000070C
#define DCU_CTRLDESCL20_5_OFFSET        0x00000710
#define DCU_CTRLDESCL20_6_OFFSET        0x00000714
#define DCU_CTRLDESCL20_7_OFFSET        0x00000718
#define DCU_CTRLDESCL20_8_OFFSET        0x0000071C
#define DCU_CTRLDESCL20_9_OFFSET        0x00000720
#define DCU_CTRLDESCL21_1_OFFSET        0x00000740
#define DCU_CTRLDESCL21_2_OFFSET        0x00000744
#define DCU_CTRLDESCL21_3_OFFSET        0x00000748
#define DCU_CTRLDESCL21_4_OFFSET        0x0000074C
#define DCU_CTRLDESCL21_5_OFFSET        0x00000750
#define DCU_CTRLDESCL21_6_OFFSET        0x00000754
#define DCU_CTRLDESCL21_7_OFFSET        0x00000758
#define DCU_CTRLDESCL21_8_OFFSET        0x0000075C
#define DCU_CTRLDESCL21_9_OFFSET        0x00000760
#define DCU_CTRLDESCL22_1_OFFSET        0x00000780
#define DCU_CTRLDESCL22_2_OFFSET        0x00000784
#define DCU_CTRLDESCL22_3_OFFSET        0x00000788
#define DCU_CTRLDESCL22_4_OFFSET        0x0000078C
#define DCU_CTRLDESCL22_5_OFFSET        0x00000790
#define DCU_CTRLDESCL22_6_OFFSET        0x00000794
#define DCU_CTRLDESCL22_7_OFFSET        0x00000798
#define DCU_CTRLDESCL22_8_OFFSET        0x0000079C
#define DCU_CTRLDESCL22_9_OFFSET        0x000007A0
#define DCU_CTRLDESCL23_1_OFFSET        0x000007C0
#define DCU_CTRLDESCL23_2_OFFSET        0x000007C4
#define DCU_CTRLDESCL23_3_OFFSET        0x000007C8
#define DCU_CTRLDESCL23_4_OFFSET        0x000007CC
#define DCU_CTRLDESCL23_5_OFFSET        0x000007D0
#define DCU_CTRLDESCL23_6_OFFSET        0x000007D4
#define DCU_CTRLDESCL23_7_OFFSET        0x000007D8
#define DCU_CTRLDESCL23_8_OFFSET        0x000007DC
#define DCU_CTRLDESCL23_9_OFFSET        0x000007E0
#define DCU_CTRLDESCL24_1_OFFSET        0x00000800
#define DCU_CTRLDESCL24_2_OFFSET        0x00000804
#define DCU_CTRLDESCL24_3_OFFSET        0x00000808
#define DCU_CTRLDESCL24_4_OFFSET        0x0000080C
#define DCU_CTRLDESCL24_5_OFFSET        0x00000810
#define DCU_CTRLDESCL24_6_OFFSET        0x00000814
#define DCU_CTRLDESCL24_7_OFFSET        0x00000818
#define DCU_CTRLDESCL24_8_OFFSET        0x0000081C
#define DCU_CTRLDESCL24_9_OFFSET        0x00000820
#define DCU_CTRLDESCL25_1_OFFSET        0x00000840
#define DCU_CTRLDESCL25_2_OFFSET        0x00000844
#define DCU_CTRLDESCL25_3_OFFSET        0x00000848
#define DCU_CTRLDESCL25_4_OFFSET        0x0000084C
#define DCU_CTRLDESCL25_5_OFFSET        0x00000850
#define DCU_CTRLDESCL25_6_OFFSET        0x00000854
#define DCU_CTRLDESCL25_7_OFFSET        0x00000858
#define DCU_CTRLDESCL25_8_OFFSET        0x0000085C
#define DCU_CTRLDESCL25_9_OFFSET        0x00000860
#define DCU_CTRLDESCL26_1_OFFSET        0x00000880
#define DCU_CTRLDESCL26_2_OFFSET        0x00000884
#define DCU_CTRLDESCL26_3_OFFSET        0x00000888
#define DCU_CTRLDESCL26_4_OFFSET        0x0000088C
#define DCU_CTRLDESCL26_5_OFFSET        0x00000890
#define DCU_CTRLDESCL26_6_OFFSET        0x00000894
#define DCU_CTRLDESCL26_7_OFFSET        0x00000898
#define DCU_CTRLDESCL26_8_OFFSET        0x0000089C
#define DCU_CTRLDESCL26_9_OFFSET        0x000008A0
#define DCU_CTRLDESCL27_1_OFFSET        0x000008C0
#define DCU_CTRLDESCL27_2_OFFSET        0x000008C4
#define DCU_CTRLDESCL27_3_OFFSET        0x000008C8
#define DCU_CTRLDESCL27_4_OFFSET        0x000008CC
#define DCU_CTRLDESCL27_5_OFFSET        0x000008D0
#define DCU_CTRLDESCL27_6_OFFSET        0x000008D4
#define DCU_CTRLDESCL27_7_OFFSET        0x000008D8
#define DCU_CTRLDESCL27_8_OFFSET        0x000008DC
#define DCU_CTRLDESCL27_9_OFFSET        0x000008E0
#define DCU_CTRLDESCL28_1_OFFSET        0x00000900
#define DCU_CTRLDESCL28_2_OFFSET        0x00000904
#define DCU_CTRLDESCL28_3_OFFSET        0x00000908
#define DCU_CTRLDESCL28_4_OFFSET        0x0000090C
#define DCU_CTRLDESCL28_5_OFFSET        0x00000910
#define DCU_CTRLDESCL28_6_OFFSET        0x00000914
#define DCU_CTRLDESCL28_7_OFFSET        0x00000918
#define DCU_CTRLDESCL28_8_OFFSET        0x0000091C
#define DCU_CTRLDESCL28_9_OFFSET        0x00000920
#define DCU_CTRLDESCL29_1_OFFSET        0x00000940
#define DCU_CTRLDESCL29_2_OFFSET        0x00000944
#define DCU_CTRLDESCL29_3_OFFSET        0x00000948
#define DCU_CTRLDESCL29_4_OFFSET        0x0000094C
#define DCU_CTRLDESCL29_5_OFFSET        0x00000950
#define DCU_CTRLDESCL29_6_OFFSET        0x00000954
#define DCU_CTRLDESCL29_7_OFFSET        0x00000958
#define DCU_CTRLDESCL29_8_OFFSET        0x0000095C
#define DCU_CTRLDESCL29_9_OFFSET        0x00000960
#define DCU_CTRLDESCL30_1_OFFSET        0x00000980
#define DCU_CTRLDESCL30_2_OFFSET        0x00000984
#define DCU_CTRLDESCL30_3_OFFSET        0x00000988
#define DCU_CTRLDESCL30_4_OFFSET        0x0000098C
#define DCU_CTRLDESCL30_5_OFFSET        0x00000990
#define DCU_CTRLDESCL30_6_OFFSET        0x00000994
#define DCU_CTRLDESCL30_7_OFFSET        0x00000998
#define DCU_CTRLDESCL30_8_OFFSET        0x0000099C
#define DCU_CTRLDESCL30_9_OFFSET        0x000009A0
#define DCU_CTRLDESCL31_1_OFFSET        0x000009C0
#define DCU_CTRLDESCL31_2_OFFSET        0x000009C4
#define DCU_CTRLDESCL31_3_OFFSET        0x000009C8
#define DCU_CTRLDESCL31_4_OFFSET        0x000009CC
#define DCU_CTRLDESCL31_5_OFFSET        0x000009D0
#define DCU_CTRLDESCL31_6_OFFSET        0x000009D4
#define DCU_CTRLDESCL31_7_OFFSET        0x000009D8
#define DCU_CTRLDESCL31_8_OFFSET        0x000009DC
#define DCU_CTRLDESCL31_9_OFFSET        0x000009E0
#define DCU_CTRLDESCL32_1_OFFSET        0x00000A00
#define DCU_CTRLDESCL32_2_OFFSET        0x00000A04
#define DCU_CTRLDESCL32_3_OFFSET        0x00000A08
#define DCU_CTRLDESCL32_4_OFFSET        0x00000A0C
#define DCU_CTRLDESCL32_5_OFFSET        0x00000A10
#define DCU_CTRLDESCL32_6_OFFSET        0x00000A14
#define DCU_CTRLDESCL32_7_OFFSET        0x00000A18
#define DCU_CTRLDESCL32_8_OFFSET        0x00000A1C
#define DCU_CTRLDESCL32_9_OFFSET        0x00000A20
#define DCU_CTRLDESCL33_1_OFFSET        0x00000A40
#define DCU_CTRLDESCL33_2_OFFSET        0x00000A44
#define DCU_CTRLDESCL33_3_OFFSET        0x00000A48
#define DCU_CTRLDESCL33_4_OFFSET        0x00000A4C
#define DCU_CTRLDESCL33_5_OFFSET        0x00000A50
#define DCU_CTRLDESCL33_6_OFFSET        0x00000A54
#define DCU_CTRLDESCL33_7_OFFSET        0x00000A58
#define DCU_CTRLDESCL33_8_OFFSET        0x00000A5C
#define DCU_CTRLDESCL33_9_OFFSET        0x00000A60
#define DCU_CTRLDESCL34_1_OFFSET        0x00000A80
#define DCU_CTRLDESCL34_2_OFFSET        0x00000A84
#define DCU_CTRLDESCL34_3_OFFSET        0x00000A88
#define DCU_CTRLDESCL34_4_OFFSET        0x00000A8C
#define DCU_CTRLDESCL34_5_OFFSET        0x00000A90
#define DCU_CTRLDESCL34_6_OFFSET        0x00000A94
#define DCU_CTRLDESCL34_7_OFFSET        0x00000A98
#define DCU_CTRLDESCL34_8_OFFSET        0x00000A9C
#define DCU_CTRLDESCL34_9_OFFSET        0x00000AA0
#define DCU_CTRLDESCL35_1_OFFSET        0x00000AC0
#define DCU_CTRLDESCL35_2_OFFSET        0x00000AC4
#define DCU_CTRLDESCL35_3_OFFSET        0x00000AC8
#define DCU_CTRLDESCL35_4_OFFSET        0x00000ACC
#define DCU_CTRLDESCL35_5_OFFSET        0x00000AD0
#define DCU_CTRLDESCL35_6_OFFSET        0x00000AD4
#define DCU_CTRLDESCL35_7_OFFSET        0x00000AD8
#define DCU_CTRLDESCL35_8_OFFSET        0x00000ADC
#define DCU_CTRLDESCL35_9_OFFSET        0x00000AE0
#define DCU_CTRLDESCL36_1_OFFSET        0x00000B00
#define DCU_CTRLDESCL36_2_OFFSET        0x00000B04
#define DCU_CTRLDESCL36_3_OFFSET        0x00000B08
#define DCU_CTRLDESCL36_4_OFFSET        0x00000B0C
#define DCU_CTRLDESCL36_5_OFFSET        0x00000B10
#define DCU_CTRLDESCL36_6_OFFSET        0x00000B14
#define DCU_CTRLDESCL36_7_OFFSET        0x00000B18
#define DCU_CTRLDESCL36_8_OFFSET        0x00000B1C
#define DCU_CTRLDESCL36_9_OFFSET        0x00000B20
#define DCU_CTRLDESCL37_1_OFFSET        0x00000B40
#define DCU_CTRLDESCL37_2_OFFSET        0x00000B44
#define DCU_CTRLDESCL37_3_OFFSET        0x00000B48
#define DCU_CTRLDESCL37_4_OFFSET        0x00000B4C
#define DCU_CTRLDESCL37_5_OFFSET        0x00000B50
#define DCU_CTRLDESCL37_6_OFFSET        0x00000B54
#define DCU_CTRLDESCL37_7_OFFSET        0x00000B58
#define DCU_CTRLDESCL37_8_OFFSET        0x00000B5C
#define DCU_CTRLDESCL37_9_OFFSET        0x00000B60
#define DCU_CTRLDESCL38_1_OFFSET        0x00000B80
#define DCU_CTRLDESCL38_2_OFFSET        0x00000B84
#define DCU_CTRLDESCL38_3_OFFSET        0x00000B88
#define DCU_CTRLDESCL38_4_OFFSET        0x00000B8C
#define DCU_CTRLDESCL38_5_OFFSET        0x00000B90
#define DCU_CTRLDESCL38_6_OFFSET        0x00000B94
#define DCU_CTRLDESCL38_7_OFFSET        0x00000B98
#define DCU_CTRLDESCL38_8_OFFSET        0x00000B9C
#define DCU_CTRLDESCL38_9_OFFSET        0x00000BA0
#define DCU_CTRLDESCL39_1_OFFSET        0x00000BC0
#define DCU_CTRLDESCL39_2_OFFSET        0x00000BC4
#define DCU_CTRLDESCL39_3_OFFSET        0x00000BC8
#define DCU_CTRLDESCL39_4_OFFSET        0x00000BCC
#define DCU_CTRLDESCL39_5_OFFSET        0x00000BD0
#define DCU_CTRLDESCL39_6_OFFSET        0x00000BD4
#define DCU_CTRLDESCL39_7_OFFSET        0x00000BD8
#define DCU_CTRLDESCL39_8_OFFSET        0x00000BDC
#define DCU_CTRLDESCL39_9_OFFSET        0x00000BE0
#define DCU_CTRLDESCL40_1_OFFSET        0x00000C00
#define DCU_CTRLDESCL40_2_OFFSET        0x00000C04
#define DCU_CTRLDESCL40_3_OFFSET        0x00000C08
#define DCU_CTRLDESCL40_4_OFFSET        0x00000C0C
#define DCU_CTRLDESCL40_5_OFFSET        0x00000C10
#define DCU_CTRLDESCL40_6_OFFSET        0x00000C14
#define DCU_CTRLDESCL40_7_OFFSET        0x00000C18
#define DCU_CTRLDESCL40_8_OFFSET        0x00000C1C
#define DCU_CTRLDESCL40_9_OFFSET        0x00000C20
#define DCU_CTRLDESCL41_1_OFFSET        0x00000C40
#define DCU_CTRLDESCL41_2_OFFSET        0x00000C44
#define DCU_CTRLDESCL41_3_OFFSET        0x00000C48
#define DCU_CTRLDESCL41_4_OFFSET        0x00000C4C
#define DCU_CTRLDESCL41_5_OFFSET        0x00000C50
#define DCU_CTRLDESCL41_6_OFFSET        0x00000C54
#define DCU_CTRLDESCL41_7_OFFSET        0x00000C58
#define DCU_CTRLDESCL41_8_OFFSET        0x00000C5C
#define DCU_CTRLDESCL41_9_OFFSET        0x00000C60
#define DCU_CTRLDESCL42_1_OFFSET        0x00000C80
#define DCU_CTRLDESCL42_2_OFFSET        0x00000C84
#define DCU_CTRLDESCL42_3_OFFSET        0x00000C88
#define DCU_CTRLDESCL42_4_OFFSET        0x00000C8C
#define DCU_CTRLDESCL42_5_OFFSET        0x00000C90
#define DCU_CTRLDESCL42_6_OFFSET        0x00000C94
#define DCU_CTRLDESCL42_7_OFFSET        0x00000C98
#define DCU_CTRLDESCL42_8_OFFSET        0x00000C9C
#define DCU_CTRLDESCL42_9_OFFSET        0x00000CA0
#define DCU_CTRLDESCL43_1_OFFSET        0x00000CC0
#define DCU_CTRLDESCL43_2_OFFSET        0x00000CC4
#define DCU_CTRLDESCL43_3_OFFSET        0x00000CC8
#define DCU_CTRLDESCL43_4_OFFSET        0x00000CCC
#define DCU_CTRLDESCL43_5_OFFSET        0x00000CD0
#define DCU_CTRLDESCL43_6_OFFSET        0x00000CD4
#define DCU_CTRLDESCL43_7_OFFSET        0x00000CD8
#define DCU_CTRLDESCL43_8_OFFSET        0x00000CDC
#define DCU_CTRLDESCL43_9_OFFSET        0x00000CE0
#define DCU_CTRLDESCL44_1_OFFSET        0x00000D00
#define DCU_CTRLDESCL44_2_OFFSET        0x00000D04
#define DCU_CTRLDESCL44_3_OFFSET        0x00000D08
#define DCU_CTRLDESCL44_4_OFFSET        0x00000D0C
#define DCU_CTRLDESCL44_5_OFFSET        0x00000D10
#define DCU_CTRLDESCL44_6_OFFSET        0x00000D14
#define DCU_CTRLDESCL44_7_OFFSET        0x00000D18
#define DCU_CTRLDESCL44_8_OFFSET        0x00000D1C
#define DCU_CTRLDESCL44_9_OFFSET        0x00000D20
#define DCU_CTRLDESCL45_1_OFFSET        0x00000D40
#define DCU_CTRLDESCL45_2_OFFSET        0x00000D44
#define DCU_CTRLDESCL45_3_OFFSET        0x00000D48
#define DCU_CTRLDESCL45_4_OFFSET        0x00000D4C
#define DCU_CTRLDESCL45_5_OFFSET        0x00000D50
#define DCU_CTRLDESCL45_6_OFFSET        0x00000D54
#define DCU_CTRLDESCL45_7_OFFSET        0x00000D58
#define DCU_CTRLDESCL45_8_OFFSET        0x00000D5C
#define DCU_CTRLDESCL45_9_OFFSET        0x00000D60
#define DCU_CTRLDESCL46_1_OFFSET        0x00000D80
#define DCU_CTRLDESCL46_2_OFFSET        0x00000D84
#define DCU_CTRLDESCL46_3_OFFSET        0x00000D88
#define DCU_CTRLDESCL46_4_OFFSET        0x00000D8C
#define DCU_CTRLDESCL46_5_OFFSET        0x00000D90
#define DCU_CTRLDESCL46_6_OFFSET        0x00000D94
#define DCU_CTRLDESCL46_7_OFFSET        0x00000D98
#define DCU_CTRLDESCL46_8_OFFSET        0x00000D9C
#define DCU_CTRLDESCL46_9_OFFSET        0x00000DA0
#define DCU_CTRLDESCL47_1_OFFSET        0x00000DC0
#define DCU_CTRLDESCL47_2_OFFSET        0x00000DC4
#define DCU_CTRLDESCL47_3_OFFSET        0x00000DC8
#define DCU_CTRLDESCL47_4_OFFSET        0x00000DCC
#define DCU_CTRLDESCL47_5_OFFSET        0x00000DD0
#define DCU_CTRLDESCL47_6_OFFSET        0x00000DD4
#define DCU_CTRLDESCL47_7_OFFSET        0x00000DD8
#define DCU_CTRLDESCL47_8_OFFSET        0x00000DDC
#define DCU_CTRLDESCL47_9_OFFSET        0x00000DE0
#define DCU_CTRLDESCL48_1_OFFSET        0x00000E00
#define DCU_CTRLDESCL48_2_OFFSET        0x00000E04
#define DCU_CTRLDESCL48_3_OFFSET        0x00000E08
#define DCU_CTRLDESCL48_4_OFFSET        0x00000E0C
#define DCU_CTRLDESCL48_5_OFFSET        0x00000E10
#define DCU_CTRLDESCL48_6_OFFSET        0x00000E14
#define DCU_CTRLDESCL48_7_OFFSET        0x00000E18
#define DCU_CTRLDESCL48_8_OFFSET        0x00000E1C
#define DCU_CTRLDESCL48_9_OFFSET        0x00000E20
#define DCU_CTRLDESCL49_1_OFFSET        0x00000E40
#define DCU_CTRLDESCL49_2_OFFSET        0x00000E44
#define DCU_CTRLDESCL49_3_OFFSET        0x00000E48
#define DCU_CTRLDESCL49_4_OFFSET        0x00000E4C
#define DCU_CTRLDESCL49_5_OFFSET        0x00000E50
#define DCU_CTRLDESCL49_6_OFFSET        0x00000E54
#define DCU_CTRLDESCL49_7_OFFSET        0x00000E58
#define DCU_CTRLDESCL49_8_OFFSET        0x00000E5C
#define DCU_CTRLDESCL49_9_OFFSET        0x00000E60
#define DCU_CTRLDESCL50_1_OFFSET        0x00000E80
#define DCU_CTRLDESCL50_2_OFFSET        0x00000E84
#define DCU_CTRLDESCL50_3_OFFSET        0x00000E88
#define DCU_CTRLDESCL50_4_OFFSET        0x00000E8C
#define DCU_CTRLDESCL50_5_OFFSET        0x00000E90
#define DCU_CTRLDESCL50_6_OFFSET        0x00000E94
#define DCU_CTRLDESCL50_7_OFFSET        0x00000E98
#define DCU_CTRLDESCL50_8_OFFSET        0x00000E9C
#define DCU_CTRLDESCL50_9_OFFSET        0x00000EA0
#define DCU_CTRLDESCL51_1_OFFSET        0x00000EC0
#define DCU_CTRLDESCL51_2_OFFSET        0x00000EC4
#define DCU_CTRLDESCL51_3_OFFSET        0x00000EC8
#define DCU_CTRLDESCL51_4_OFFSET        0x00000ECC
#define DCU_CTRLDESCL51_5_OFFSET        0x00000ED0
#define DCU_CTRLDESCL51_6_OFFSET        0x00000ED4
#define DCU_CTRLDESCL51_7_OFFSET        0x00000ED8
#define DCU_CTRLDESCL51_8_OFFSET        0x00000EDC
#define DCU_CTRLDESCL51_9_OFFSET        0x00000EE0
#define DCU_CTRLDESCL52_1_OFFSET        0x00000F00
#define DCU_CTRLDESCL52_2_OFFSET        0x00000F04
#define DCU_CTRLDESCL52_3_OFFSET        0x00000F08
#define DCU_CTRLDESCL52_4_OFFSET        0x00000F0C
#define DCU_CTRLDESCL52_5_OFFSET        0x00000F10
#define DCU_CTRLDESCL52_6_OFFSET        0x00000F14
#define DCU_CTRLDESCL52_7_OFFSET        0x00000F18
#define DCU_CTRLDESCL52_8_OFFSET        0x00000F1C
#define DCU_CTRLDESCL52_9_OFFSET        0x00000F20
#define DCU_CTRLDESCL53_1_OFFSET        0x00000F40
#define DCU_CTRLDESCL53_2_OFFSET        0x00000F44
#define DCU_CTRLDESCL53_3_OFFSET        0x00000F48
#define DCU_CTRLDESCL53_4_OFFSET        0x00000F4C
#define DCU_CTRLDESCL53_5_OFFSET        0x00000F50
#define DCU_CTRLDESCL53_6_OFFSET        0x00000F54
#define DCU_CTRLDESCL53_7_OFFSET        0x00000F58
#define DCU_CTRLDESCL53_8_OFFSET        0x00000F5C
#define DCU_CTRLDESCL53_9_OFFSET        0x00000F60
#define DCU_CTRLDESCL54_1_OFFSET        0x00000F80
#define DCU_CTRLDESCL54_2_OFFSET        0x00000F84
#define DCU_CTRLDESCL54_3_OFFSET        0x00000F88
#define DCU_CTRLDESCL54_4_OFFSET        0x00000F8C
#define DCU_CTRLDESCL54_5_OFFSET        0x00000F90
#define DCU_CTRLDESCL54_6_OFFSET        0x00000F94
#define DCU_CTRLDESCL54_7_OFFSET        0x00000F98
#define DCU_CTRLDESCL54_8_OFFSET        0x00000F9C
#define DCU_CTRLDESCL54_9_OFFSET        0x00000FA0
#define DCU_CTRLDESCL55_1_OFFSET        0x00000FC0
#define DCU_CTRLDESCL55_2_OFFSET        0x00000FC4
#define DCU_CTRLDESCL55_3_OFFSET        0x00000FC8
#define DCU_CTRLDESCL55_4_OFFSET        0x00000FCC
#define DCU_CTRLDESCL55_5_OFFSET        0x00000FD0
#define DCU_CTRLDESCL55_6_OFFSET        0x00000FD4
#define DCU_CTRLDESCL55_7_OFFSET        0x00000FD8
#define DCU_CTRLDESCL55_8_OFFSET        0x00000FDC
#define DCU_CTRLDESCL55_9_OFFSET        0x00000FE0
#define DCU_CTRLDESCL56_1_OFFSET        0x00001000
#define DCU_CTRLDESCL56_2_OFFSET        0x00001004
#define DCU_CTRLDESCL56_3_OFFSET        0x00001008
#define DCU_CTRLDESCL56_4_OFFSET        0x0000100C
#define DCU_CTRLDESCL56_5_OFFSET        0x00001010
#define DCU_CTRLDESCL56_6_OFFSET        0x00001014
#define DCU_CTRLDESCL56_7_OFFSET        0x00001018
#define DCU_CTRLDESCL56_8_OFFSET        0x0000101C
#define DCU_CTRLDESCL56_9_OFFSET        0x00001020
#define DCU_CTRLDESCL57_1_OFFSET        0x00001040
#define DCU_CTRLDESCL57_2_OFFSET        0x00001044
#define DCU_CTRLDESCL57_3_OFFSET        0x00001048
#define DCU_CTRLDESCL57_4_OFFSET        0x0000104C
#define DCU_CTRLDESCL57_5_OFFSET        0x00001050
#define DCU_CTRLDESCL57_6_OFFSET        0x00001054
#define DCU_CTRLDESCL57_7_OFFSET        0x00001058
#define DCU_CTRLDESCL57_8_OFFSET        0x0000105C
#define DCU_CTRLDESCL57_9_OFFSET        0x00001060
#define DCU_CTRLDESCL58_1_OFFSET        0x00001080
#define DCU_CTRLDESCL58_2_OFFSET        0x00001084
#define DCU_CTRLDESCL58_3_OFFSET        0x00001088
#define DCU_CTRLDESCL58_4_OFFSET        0x0000108C
#define DCU_CTRLDESCL58_5_OFFSET        0x00001090
#define DCU_CTRLDESCL58_6_OFFSET        0x00001094
#define DCU_CTRLDESCL58_7_OFFSET        0x00001098
#define DCU_CTRLDESCL58_8_OFFSET        0x0000109C
#define DCU_CTRLDESCL58_9_OFFSET        0x000010A0
#define DCU_CTRLDESCL59_1_OFFSET        0x000010C0
#define DCU_CTRLDESCL59_2_OFFSET        0x000010C4
#define DCU_CTRLDESCL59_3_OFFSET        0x000010C8
#define DCU_CTRLDESCL59_4_OFFSET        0x000010CC
#define DCU_CTRLDESCL59_5_OFFSET        0x000010D0
#define DCU_CTRLDESCL59_6_OFFSET        0x000010D4
#define DCU_CTRLDESCL59_7_OFFSET        0x000010D8
#define DCU_CTRLDESCL59_8_OFFSET        0x000010DC
#define DCU_CTRLDESCL59_9_OFFSET        0x000010E0
#define DCU_CTRLDESCL60_1_OFFSET        0x00001100
#define DCU_CTRLDESCL60_2_OFFSET        0x00001104
#define DCU_CTRLDESCL60_3_OFFSET        0x00001108
#define DCU_CTRLDESCL60_4_OFFSET        0x0000110C
#define DCU_CTRLDESCL60_5_OFFSET        0x00001110
#define DCU_CTRLDESCL60_6_OFFSET        0x00001114
#define DCU_CTRLDESCL60_7_OFFSET        0x00001118
#define DCU_CTRLDESCL60_8_OFFSET        0x0000111C
#define DCU_CTRLDESCL60_9_OFFSET        0x00001120
#define DCU_CTRLDESCL61_1_OFFSET        0x00001140
#define DCU_CTRLDESCL61_2_OFFSET        0x00001144
#define DCU_CTRLDESCL61_3_OFFSET        0x00001148
#define DCU_CTRLDESCL61_4_OFFSET        0x0000114C
#define DCU_CTRLDESCL61_5_OFFSET        0x00001150
#define DCU_CTRLDESCL61_6_OFFSET        0x00001154
#define DCU_CTRLDESCL61_7_OFFSET        0x00001158
#define DCU_CTRLDESCL61_8_OFFSET        0x0000115C
#define DCU_CTRLDESCL61_9_OFFSET        0x00001160
#define DCU_CTRLDESCL62_1_OFFSET        0x00001180
#define DCU_CTRLDESCL62_2_OFFSET        0x00001184
#define DCU_CTRLDESCL62_3_OFFSET        0x00001188
#define DCU_CTRLDESCL62_4_OFFSET        0x0000118C
#define DCU_CTRLDESCL62_5_OFFSET        0x00001190
#define DCU_CTRLDESCL62_6_OFFSET        0x00001194
#define DCU_CTRLDESCL62_7_OFFSET        0x00001198
#define DCU_CTRLDESCL62_8_OFFSET        0x0000119C
#define DCU_CTRLDESCL62_9_OFFSET        0x000011A0
#define DCU_CTRLDESCL63_1_OFFSET        0x000011C0
#define DCU_CTRLDESCL63_2_OFFSET        0x000011C4
#define DCU_CTRLDESCL63_3_OFFSET        0x000011C8
#define DCU_CTRLDESCL63_4_OFFSET        0x000011CC
#define DCU_CTRLDESCL63_5_OFFSET        0x000011D0
#define DCU_CTRLDESCL63_6_OFFSET        0x000011D4
#define DCU_CTRLDESCL63_7_OFFSET        0x000011D8
#define DCU_CTRLDESCL63_8_OFFSET        0x000011DC
#define DCU_CTRLDESCL63_9_OFFSET        0x000011E0

/* DCU Register per module */
#define DCU0_CTRLDESCCURSOR1          (DCU0_BASE + DCU_CTRLDESCCURSOR1_OFFSET)
#define DCU0_CTRLDESCCURSOR2          (DCU0_BASE + DCU_CTRLDESCCURSOR2_OFFSET)
#define DCU0_CTRLDESCCURSOR3          (DCU0_BASE + DCU_CTRLDESCCURSOR3_OFFSET)
#define DCU0_CTRLDESCCURSOR4          (DCU0_BASE + DCU_CTRLDESCCURSOR4_OFFSET)
#define DCU0_DCU_MODE                 (DCU0_BASE + DCU_DCU_MODE_OFFSET)
#define DCU0_BGND                     (DCU0_BASE + DCU_BGND_OFFSET)
#define DCU0_DISP_SIZE                (DCU0_BASE + DCU_DISP_SIZE_OFFSET)
#define DCU0_HSYN_PARA                (DCU0_BASE + DCU_HSYN_PARA_OFFSET)
#define DCU0_VSYN_PARA                (DCU0_BASE + DCU_VSYN_PARA_OFFSET)
#define DCU0_SYNPOL                   (DCU0_BASE + DCU_SYNPOL_OFFSET)
#define DCU0_THRESHOLD                (DCU0_BASE + DCU_THRESHOLD_OFFSET)
#define DCU0_INT_STATUS               (DCU0_BASE + DCU_INT_STATUS_OFFSET)
#define DCU0_INT_MASK                 (DCU0_BASE + DCU_INT_MASK_OFFSET)
#define DCU0_COLBAR_1                 (DCU0_BASE + DCU_COLBAR_1_OFFSET)
#define DCU0_COLBAR_2                 (DCU0_BASE + DCU_COLBAR_2_OFFSET)
#define DCU0_COLBAR_3                 (DCU0_BASE + DCU_COLBAR_3_OFFSET)
#define DCU0_COLBAR_4                 (DCU0_BASE + DCU_COLBAR_4_OFFSET)
#define DCU0_COLBAR_5                 (DCU0_BASE + DCU_COLBAR_5_OFFSET)
#define DCU0_COLBAR_6                 (DCU0_BASE + DCU_COLBAR_6_OFFSET)
#define DCU0_COLBAR_7                 (DCU0_BASE + DCU_COLBAR_7_OFFSET)
#define DCU0_COLBAR_8                 (DCU0_BASE + DCU_COLBAR_8_OFFSET)
#define DCU0_DIV_RATIO                (DCU0_BASE + DCU_DIV_RATIO_OFFSET)
#define DCU0_SIGN_CALC_1              (DCU0_BASE + DCU_SIGN_CALC_1_OFFSET)
#define DCU0_SIGN_CALC_2              (DCU0_BASE + DCU_SIGN_CALC_2_OFFSET)
#define DCU0_CRC_VAL                  (DCU0_BASE + DCU_CRC_VAL_OFFSET)
#define DCU0_PARR_ERR_STATUS1         (DCU0_BASE + DCU_PARR_ERR_STATUS1_OFFSET)
#define DCU0_PARR_ERR_STATUS2         (DCU0_BASE + DCU_PARR_ERR_STATUS2_OFFSET)
#define DCU0_PARR_ERR_STATUS3         (DCU0_BASE + DCU_PARR_ERR_STATUS3_OFFSET)
#define DCU0_MASK_PARR_ERR_STATUS1    (DCU0_BASE + DCU_MASK_PARR_ERR_STATUS1_OFFSET)
#define DCU0_MASK_PARR_ERR_STATUS2    (DCU0_BASE + DCU_MASK_PARR_ERR_STATUS2_OFFSET)
#define DCU0_MASK_PARR_ERR_STATUS3    (DCU0_BASE + DCU_MASK_PARR_ERR_STATUS3_OFFSET)
#define DCU0_THRESHOLD_INP_BUF_1      (DCU0_BASE + DCU_THRESHOLD_INP_BUF_1_OFFSET)
#define DCU0_THRESHOLD_INP_BUF_2      (DCU0_BASE + DCU_THRESHOLD_INP_BUF_2_OFFSET)
#define DCU0_THRESHOLD_INP_BUF_3      (DCU0_BASE + DCU_THRESHOLD_INP_BUF_3_OFFSET)
#define DCU0_LUMA_COMP                (DCU0_BASE + DCU_LUMA_COMP_OFFSET)
#define DCU0_CHROMA_RED               (DCU0_BASE + DCU_CHROMA_RED_OFFSET)
#define DCU0_CHROMA_GREEN             (DCU0_BASE + DCU_CHROMA_GREEN_OFFSET)
#define DCU0_CHROMA_BLUE              (DCU0_BASE + DCU_CHROMA_BLUE_OFFSET)
#define DCU0_CRC_POS                  (DCU0_BASE + DCU_CRC_POS_OFFSET)
#define DCU0_LYR_INTPOL_EN            (DCU0_BASE + DCU_LYR_INTPOL_EN_OFFSET)
#define DCU0_LYR_LUMA_COMP            (DCU0_BASE + DCU_LYR_LUMA_COMP_OFFSET)
#define DCU0_LYR_CHROMA_RED           (DCU0_BASE + DCU_LYR_CHROMA_RED_OFFSET)
#define DCU0_LYR_CHROMA_GREEN         (DCU0_BASE + DCU_LYR_CHROMA_GREEN_OFFSET)
#define DCU0_LYR_CHROMA_BLUE          (DCU0_BASE + DCU_LYR_CHROMA_BLUE_OFFSET)
#define DCU0_COMP_IMSIZE              (DCU0_BASE + DCU_COMP_IMSIZE_OFFSET)
#define DCU0_UPDATE_MODE              (DCU0_BASE + DCU_UPDATE_MODE_OFFSET)
#define DCU0_UNDERRUN                 (DCU0_BASE + DCU_UNDERRUN_OFFSET)
#define DCU0_GPR                      (DCU0_BASE + DCU_GPR_OFFSET)
#define DCU0_SLR_L0                   (DCU0_BASE + DCU_SLR_L0_OFFSET)
#define DCU0_SLR_L1                   (DCU0_BASE + DCU_SLR_L1_OFFSET)
#define DCU0_SLR_DISP_SIZE            (DCU0_BASE + DCU_SLR_DISP_SIZE_OFFSET)
#define DCU0_SLR_HVSYNC_PARA          (DCU0_BASE + DCU_SLR_HVSYNC_PARA_OFFSET)
#define DCU0_SLR_POL                  (DCU0_BASE + DCU_SLR_POL_OFFSET)
#define DCU0_SLR_L0TRANSP             (DCU0_BASE + DCU_SLR_L0TRANSP_OFFSET)
#define DCU0_SLR_L1TRANSP             (DCU0_BASE + DCU_SLR_L1TRANSP_OFFSET)
#define DCU0_CTRLDESCL0_1             (DCU0_BASE + DCU_CTRLDESCL0_1_OFFSET)
#define DCU0_CTRLDESCL0_2             (DCU0_BASE + DCU_CTRLDESCL0_2_OFFSET)
#define DCU0_CTRLDESCL0_3             (DCU0_BASE + DCU_CTRLDESCL0_3_OFFSET)
#define DCU0_CTRLDESCL0_4             (DCU0_BASE + DCU_CTRLDESCL0_4_OFFSET)
#define DCU0_CTRLDESCL0_5             (DCU0_BASE + DCU_CTRLDESCL0_5_OFFSET)
#define DCU0_CTRLDESCL0_6             (DCU0_BASE + DCU_CTRLDESCL0_6_OFFSET)
#define DCU0_CTRLDESCL0_7             (DCU0_BASE + DCU_CTRLDESCL0_7_OFFSET)
#define DCU0_CTRLDESCL0_8             (DCU0_BASE + DCU_CTRLDESCL0_8_OFFSET)
#define DCU0_CTRLDESCL0_9             (DCU0_BASE + DCU_CTRLDESCL0_9_OFFSET)
#define DCU0_CTRLDESCL1_1             (DCU0_BASE + DCU_CTRLDESCL1_1_OFFSET)
#define DCU0_CTRLDESCL1_2             (DCU0_BASE + DCU_CTRLDESCL1_2_OFFSET)
#define DCU0_CTRLDESCL1_3             (DCU0_BASE + DCU_CTRLDESCL1_3_OFFSET)
#define DCU0_CTRLDESCL1_4             (DCU0_BASE + DCU_CTRLDESCL1_4_OFFSET)
#define DCU0_CTRLDESCL1_5             (DCU0_BASE + DCU_CTRLDESCL1_5_OFFSET)
#define DCU0_CTRLDESCL1_6             (DCU0_BASE + DCU_CTRLDESCL1_6_OFFSET)
#define DCU0_CTRLDESCL1_7             (DCU0_BASE + DCU_CTRLDESCL1_7_OFFSET)
#define DCU0_CTRLDESCL1_8             (DCU0_BASE + DCU_CTRLDESCL1_8_OFFSET)
#define DCU0_CTRLDESCL1_9             (DCU0_BASE + DCU_CTRLDESCL1_9_OFFSET)
#define DCU0_CTRLDESCL2_1             (DCU0_BASE + DCU_CTRLDESCL2_1_OFFSET)
#define DCU0_CTRLDESCL2_2             (DCU0_BASE + DCU_CTRLDESCL2_2_OFFSET)
#define DCU0_CTRLDESCL2_3             (DCU0_BASE + DCU_CTRLDESCL2_3_OFFSET)
#define DCU0_CTRLDESCL2_4             (DCU0_BASE + DCU_CTRLDESCL2_4_OFFSET)
#define DCU0_CTRLDESCL2_5             (DCU0_BASE + DCU_CTRLDESCL2_5_OFFSET)
#define DCU0_CTRLDESCL2_6             (DCU0_BASE + DCU_CTRLDESCL2_6_OFFSET)
#define DCU0_CTRLDESCL2_7             (DCU0_BASE + DCU_CTRLDESCL2_7_OFFSET)
#define DCU0_CTRLDESCL2_8             (DCU0_BASE + DCU_CTRLDESCL2_8_OFFSET)
#define DCU0_CTRLDESCL2_9             (DCU0_BASE + DCU_CTRLDESCL2_9_OFFSET)
#define DCU0_CTRLDESCL3_1             (DCU0_BASE + DCU_CTRLDESCL3_1_OFFSET)
#define DCU0_CTRLDESCL3_2             (DCU0_BASE + DCU_CTRLDESCL3_2_OFFSET)
#define DCU0_CTRLDESCL3_3             (DCU0_BASE + DCU_CTRLDESCL3_3_OFFSET)
#define DCU0_CTRLDESCL3_4             (DCU0_BASE + DCU_CTRLDESCL3_4_OFFSET)
#define DCU0_CTRLDESCL3_5             (DCU0_BASE + DCU_CTRLDESCL3_5_OFFSET)
#define DCU0_CTRLDESCL3_6             (DCU0_BASE + DCU_CTRLDESCL3_6_OFFSET)
#define DCU0_CTRLDESCL3_7             (DCU0_BASE + DCU_CTRLDESCL3_7_OFFSET)
#define DCU0_CTRLDESCL3_8             (DCU0_BASE + DCU_CTRLDESCL3_8_OFFSET)
#define DCU0_CTRLDESCL3_9             (DCU0_BASE + DCU_CTRLDESCL3_9_OFFSET)
#define DCU0_CTRLDESCL4_1             (DCU0_BASE + DCU_CTRLDESCL4_1_OFFSET)
#define DCU0_CTRLDESCL4_2             (DCU0_BASE + DCU_CTRLDESCL4_2_OFFSET)
#define DCU0_CTRLDESCL4_3             (DCU0_BASE + DCU_CTRLDESCL4_3_OFFSET)
#define DCU0_CTRLDESCL4_4             (DCU0_BASE + DCU_CTRLDESCL4_4_OFFSET)
#define DCU0_CTRLDESCL4_5             (DCU0_BASE + DCU_CTRLDESCL4_5_OFFSET)
#define DCU0_CTRLDESCL4_6             (DCU0_BASE + DCU_CTRLDESCL4_6_OFFSET)
#define DCU0_CTRLDESCL4_7             (DCU0_BASE + DCU_CTRLDESCL4_7_OFFSET)
#define DCU0_CTRLDESCL4_8             (DCU0_BASE + DCU_CTRLDESCL4_8_OFFSET)
#define DCU0_CTRLDESCL4_9             (DCU0_BASE + DCU_CTRLDESCL4_9_OFFSET)
#define DCU0_CTRLDESCL5_1             (DCU0_BASE + DCU_CTRLDESCL5_1_OFFSET)
#define DCU0_CTRLDESCL5_2             (DCU0_BASE + DCU_CTRLDESCL5_2_OFFSET)
#define DCU0_CTRLDESCL5_3             (DCU0_BASE + DCU_CTRLDESCL5_3_OFFSET)
#define DCU0_CTRLDESCL5_4             (DCU0_BASE + DCU_CTRLDESCL5_4_OFFSET)
#define DCU0_CTRLDESCL5_5             (DCU0_BASE + DCU_CTRLDESCL5_5_OFFSET)
#define DCU0_CTRLDESCL5_6             (DCU0_BASE + DCU_CTRLDESCL5_6_OFFSET)
#define DCU0_CTRLDESCL5_7             (DCU0_BASE + DCU_CTRLDESCL5_7_OFFSET)
#define DCU0_CTRLDESCL5_8             (DCU0_BASE + DCU_CTRLDESCL5_8_OFFSET)
#define DCU0_CTRLDESCL5_9             (DCU0_BASE + DCU_CTRLDESCL5_9_OFFSET)
#define DCU0_CTRLDESCL6_1             (DCU0_BASE + DCU_CTRLDESCL6_1_OFFSET)
#define DCU0_CTRLDESCL6_2             (DCU0_BASE + DCU_CTRLDESCL6_2_OFFSET)
#define DCU0_CTRLDESCL6_3             (DCU0_BASE + DCU_CTRLDESCL6_3_OFFSET)
#define DCU0_CTRLDESCL6_4             (DCU0_BASE + DCU_CTRLDESCL6_4_OFFSET)
#define DCU0_CTRLDESCL6_5             (DCU0_BASE + DCU_CTRLDESCL6_5_OFFSET)
#define DCU0_CTRLDESCL6_6             (DCU0_BASE + DCU_CTRLDESCL6_6_OFFSET)
#define DCU0_CTRLDESCL6_7             (DCU0_BASE + DCU_CTRLDESCL6_7_OFFSET)
#define DCU0_CTRLDESCL6_8             (DCU0_BASE + DCU_CTRLDESCL6_8_OFFSET)
#define DCU0_CTRLDESCL6_9             (DCU0_BASE + DCU_CTRLDESCL6_9_OFFSET)
#define DCU0_CTRLDESCL7_1             (DCU0_BASE + DCU_CTRLDESCL7_1_OFFSET)
#define DCU0_CTRLDESCL7_2             (DCU0_BASE + DCU_CTRLDESCL7_2_OFFSET)
#define DCU0_CTRLDESCL7_3             (DCU0_BASE + DCU_CTRLDESCL7_3_OFFSET)
#define DCU0_CTRLDESCL7_4             (DCU0_BASE + DCU_CTRLDESCL7_4_OFFSET)
#define DCU0_CTRLDESCL7_5             (DCU0_BASE + DCU_CTRLDESCL7_5_OFFSET)
#define DCU0_CTRLDESCL7_6             (DCU0_BASE + DCU_CTRLDESCL7_6_OFFSET)
#define DCU0_CTRLDESCL7_7             (DCU0_BASE + DCU_CTRLDESCL7_7_OFFSET)
#define DCU0_CTRLDESCL7_8             (DCU0_BASE + DCU_CTRLDESCL7_8_OFFSET)
#define DCU0_CTRLDESCL7_9             (DCU0_BASE + DCU_CTRLDESCL7_9_OFFSET)
#define DCU0_CTRLDESCL8_1             (DCU0_BASE + DCU_CTRLDESCL8_1_OFFSET)
#define DCU0_CTRLDESCL8_2             (DCU0_BASE + DCU_CTRLDESCL8_2_OFFSET)
#define DCU0_CTRLDESCL8_3             (DCU0_BASE + DCU_CTRLDESCL8_3_OFFSET)
#define DCU0_CTRLDESCL8_4             (DCU0_BASE + DCU_CTRLDESCL8_4_OFFSET)
#define DCU0_CTRLDESCL8_5             (DCU0_BASE + DCU_CTRLDESCL8_5_OFFSET)
#define DCU0_CTRLDESCL8_6             (DCU0_BASE + DCU_CTRLDESCL8_6_OFFSET)
#define DCU0_CTRLDESCL8_7             (DCU0_BASE + DCU_CTRLDESCL8_7_OFFSET)
#define DCU0_CTRLDESCL8_8             (DCU0_BASE + DCU_CTRLDESCL8_8_OFFSET)
#define DCU0_CTRLDESCL8_9             (DCU0_BASE + DCU_CTRLDESCL8_9_OFFSET)
#define DCU0_CTRLDESCL9_1             (DCU0_BASE + DCU_CTRLDESCL9_1_OFFSET)
#define DCU0_CTRLDESCL9_2             (DCU0_BASE + DCU_CTRLDESCL9_2_OFFSET)
#define DCU0_CTRLDESCL9_3             (DCU0_BASE + DCU_CTRLDESCL9_3_OFFSET)
#define DCU0_CTRLDESCL9_4             (DCU0_BASE + DCU_CTRLDESCL9_4_OFFSET)
#define DCU0_CTRLDESCL9_5             (DCU0_BASE + DCU_CTRLDESCL9_5_OFFSET)
#define DCU0_CTRLDESCL9_6             (DCU0_BASE + DCU_CTRLDESCL9_6_OFFSET)
#define DCU0_CTRLDESCL9_7             (DCU0_BASE + DCU_CTRLDESCL9_7_OFFSET)
#define DCU0_CTRLDESCL9_8             (DCU0_BASE + DCU_CTRLDESCL9_8_OFFSET)
#define DCU0_CTRLDESCL9_9             (DCU0_BASE + DCU_CTRLDESCL9_9_OFFSET)
#define DCU0_CTRLDESCL10_1            (DCU0_BASE + DCU_CTRLDESCL10_1_OFFSET)
#define DCU0_CTRLDESCL10_2            (DCU0_BASE + DCU_CTRLDESCL10_2_OFFSET)
#define DCU0_CTRLDESCL10_3            (DCU0_BASE + DCU_CTRLDESCL10_3_OFFSET)
#define DCU0_CTRLDESCL10_4            (DCU0_BASE + DCU_CTRLDESCL10_4_OFFSET)
#define DCU0_CTRLDESCL10_5            (DCU0_BASE + DCU_CTRLDESCL10_5_OFFSET)
#define DCU0_CTRLDESCL10_6            (DCU0_BASE + DCU_CTRLDESCL10_6_OFFSET)
#define DCU0_CTRLDESCL10_7            (DCU0_BASE + DCU_CTRLDESCL10_7_OFFSET)
#define DCU0_CTRLDESCL10_8            (DCU0_BASE + DCU_CTRLDESCL10_8_OFFSET)
#define DCU0_CTRLDESCL10_9            (DCU0_BASE + DCU_CTRLDESCL10_9_OFFSET)
#define DCU0_CTRLDESCL11_1            (DCU0_BASE + DCU_CTRLDESCL11_1_OFFSET)
#define DCU0_CTRLDESCL11_2            (DCU0_BASE + DCU_CTRLDESCL11_2_OFFSET)
#define DCU0_CTRLDESCL11_3            (DCU0_BASE + DCU_CTRLDESCL11_3_OFFSET)
#define DCU0_CTRLDESCL11_4            (DCU0_BASE + DCU_CTRLDESCL11_4_OFFSET)
#define DCU0_CTRLDESCL11_5            (DCU0_BASE + DCU_CTRLDESCL11_5_OFFSET)
#define DCU0_CTRLDESCL11_6            (DCU0_BASE + DCU_CTRLDESCL11_6_OFFSET)
#define DCU0_CTRLDESCL11_7            (DCU0_BASE + DCU_CTRLDESCL11_7_OFFSET)
#define DCU0_CTRLDESCL11_8            (DCU0_BASE + DCU_CTRLDESCL11_8_OFFSET)
#define DCU0_CTRLDESCL11_9            (DCU0_BASE + DCU_CTRLDESCL11_9_OFFSET)
#define DCU0_CTRLDESCL12_1            (DCU0_BASE + DCU_CTRLDESCL12_1_OFFSET)
#define DCU0_CTRLDESCL12_2            (DCU0_BASE + DCU_CTRLDESCL12_2_OFFSET)
#define DCU0_CTRLDESCL12_3            (DCU0_BASE + DCU_CTRLDESCL12_3_OFFSET)
#define DCU0_CTRLDESCL12_4            (DCU0_BASE + DCU_CTRLDESCL12_4_OFFSET)
#define DCU0_CTRLDESCL12_5            (DCU0_BASE + DCU_CTRLDESCL12_5_OFFSET)
#define DCU0_CTRLDESCL12_6            (DCU0_BASE + DCU_CTRLDESCL12_6_OFFSET)
#define DCU0_CTRLDESCL12_7            (DCU0_BASE + DCU_CTRLDESCL12_7_OFFSET)
#define DCU0_CTRLDESCL12_8            (DCU0_BASE + DCU_CTRLDESCL12_8_OFFSET)
#define DCU0_CTRLDESCL12_9            (DCU0_BASE + DCU_CTRLDESCL12_9_OFFSET)
#define DCU0_CTRLDESCL13_1            (DCU0_BASE + DCU_CTRLDESCL13_1_OFFSET)
#define DCU0_CTRLDESCL13_2            (DCU0_BASE + DCU_CTRLDESCL13_2_OFFSET)
#define DCU0_CTRLDESCL13_3            (DCU0_BASE + DCU_CTRLDESCL13_3_OFFSET)
#define DCU0_CTRLDESCL13_4            (DCU0_BASE + DCU_CTRLDESCL13_4_OFFSET)
#define DCU0_CTRLDESCL13_5            (DCU0_BASE + DCU_CTRLDESCL13_5_OFFSET)
#define DCU0_CTRLDESCL13_6            (DCU0_BASE + DCU_CTRLDESCL13_6_OFFSET)
#define DCU0_CTRLDESCL13_7            (DCU0_BASE + DCU_CTRLDESCL13_7_OFFSET)
#define DCU0_CTRLDESCL13_8            (DCU0_BASE + DCU_CTRLDESCL13_8_OFFSET)
#define DCU0_CTRLDESCL13_9            (DCU0_BASE + DCU_CTRLDESCL13_9_OFFSET)
#define DCU0_CTRLDESCL14_1            (DCU0_BASE + DCU_CTRLDESCL14_1_OFFSET)
#define DCU0_CTRLDESCL14_2            (DCU0_BASE + DCU_CTRLDESCL14_2_OFFSET)
#define DCU0_CTRLDESCL14_3            (DCU0_BASE + DCU_CTRLDESCL14_3_OFFSET)
#define DCU0_CTRLDESCL14_4            (DCU0_BASE + DCU_CTRLDESCL14_4_OFFSET)
#define DCU0_CTRLDESCL14_5            (DCU0_BASE + DCU_CTRLDESCL14_5_OFFSET)
#define DCU0_CTRLDESCL14_6            (DCU0_BASE + DCU_CTRLDESCL14_6_OFFSET)
#define DCU0_CTRLDESCL14_7            (DCU0_BASE + DCU_CTRLDESCL14_7_OFFSET)
#define DCU0_CTRLDESCL14_8            (DCU0_BASE + DCU_CTRLDESCL14_8_OFFSET)
#define DCU0_CTRLDESCL14_9            (DCU0_BASE + DCU_CTRLDESCL14_9_OFFSET)
#define DCU0_CTRLDESCL15_1            (DCU0_BASE + DCU_CTRLDESCL15_1_OFFSET)
#define DCU0_CTRLDESCL15_2            (DCU0_BASE + DCU_CTRLDESCL15_2_OFFSET)
#define DCU0_CTRLDESCL15_3            (DCU0_BASE + DCU_CTRLDESCL15_3_OFFSET)
#define DCU0_CTRLDESCL15_4            (DCU0_BASE + DCU_CTRLDESCL15_4_OFFSET)
#define DCU0_CTRLDESCL15_5            (DCU0_BASE + DCU_CTRLDESCL15_5_OFFSET)
#define DCU0_CTRLDESCL15_6            (DCU0_BASE + DCU_CTRLDESCL15_6_OFFSET)
#define DCU0_CTRLDESCL15_7            (DCU0_BASE + DCU_CTRLDESCL15_7_OFFSET)
#define DCU0_CTRLDESCL15_8            (DCU0_BASE + DCU_CTRLDESCL15_8_OFFSET)
#define DCU0_CTRLDESCL15_9            (DCU0_BASE + DCU_CTRLDESCL15_9_OFFSET)
#define DCU0_CTRLDESCL16_1            (DCU0_BASE + DCU_CTRLDESCL16_1_OFFSET)
#define DCU0_CTRLDESCL16_2            (DCU0_BASE + DCU_CTRLDESCL16_2_OFFSET)
#define DCU0_CTRLDESCL16_3            (DCU0_BASE + DCU_CTRLDESCL16_3_OFFSET)
#define DCU0_CTRLDESCL16_4            (DCU0_BASE + DCU_CTRLDESCL16_4_OFFSET)
#define DCU0_CTRLDESCL16_5            (DCU0_BASE + DCU_CTRLDESCL16_5_OFFSET)
#define DCU0_CTRLDESCL16_6            (DCU0_BASE + DCU_CTRLDESCL16_6_OFFSET)
#define DCU0_CTRLDESCL16_7            (DCU0_BASE + DCU_CTRLDESCL16_7_OFFSET)
#define DCU0_CTRLDESCL16_8            (DCU0_BASE + DCU_CTRLDESCL16_8_OFFSET)
#define DCU0_CTRLDESCL16_9            (DCU0_BASE + DCU_CTRLDESCL16_9_OFFSET)
#define DCU0_CTRLDESCL17_1            (DCU0_BASE + DCU_CTRLDESCL17_1_OFFSET)
#define DCU0_CTRLDESCL17_2            (DCU0_BASE + DCU_CTRLDESCL17_2_OFFSET)
#define DCU0_CTRLDESCL17_3            (DCU0_BASE + DCU_CTRLDESCL17_3_OFFSET)
#define DCU0_CTRLDESCL17_4            (DCU0_BASE + DCU_CTRLDESCL17_4_OFFSET)
#define DCU0_CTRLDESCL17_5            (DCU0_BASE + DCU_CTRLDESCL17_5_OFFSET)
#define DCU0_CTRLDESCL17_6            (DCU0_BASE + DCU_CTRLDESCL17_6_OFFSET)
#define DCU0_CTRLDESCL17_7            (DCU0_BASE + DCU_CTRLDESCL17_7_OFFSET)
#define DCU0_CTRLDESCL17_8            (DCU0_BASE + DCU_CTRLDESCL17_8_OFFSET)
#define DCU0_CTRLDESCL17_9            (DCU0_BASE + DCU_CTRLDESCL17_9_OFFSET)
#define DCU0_CTRLDESCL18_1            (DCU0_BASE + DCU_CTRLDESCL18_1_OFFSET)
#define DCU0_CTRLDESCL18_2            (DCU0_BASE + DCU_CTRLDESCL18_2_OFFSET)
#define DCU0_CTRLDESCL18_3            (DCU0_BASE + DCU_CTRLDESCL18_3_OFFSET)
#define DCU0_CTRLDESCL18_4            (DCU0_BASE + DCU_CTRLDESCL18_4_OFFSET)
#define DCU0_CTRLDESCL18_5            (DCU0_BASE + DCU_CTRLDESCL18_5_OFFSET)
#define DCU0_CTRLDESCL18_6            (DCU0_BASE + DCU_CTRLDESCL18_6_OFFSET)
#define DCU0_CTRLDESCL18_7            (DCU0_BASE + DCU_CTRLDESCL18_7_OFFSET)
#define DCU0_CTRLDESCL18_8            (DCU0_BASE + DCU_CTRLDESCL18_8_OFFSET)
#define DCU0_CTRLDESCL18_9            (DCU0_BASE + DCU_CTRLDESCL18_9_OFFSET)
#define DCU0_CTRLDESCL19_1            (DCU0_BASE + DCU_CTRLDESCL19_1_OFFSET)
#define DCU0_CTRLDESCL19_2            (DCU0_BASE + DCU_CTRLDESCL19_2_OFFSET)
#define DCU0_CTRLDESCL19_3            (DCU0_BASE + DCU_CTRLDESCL19_3_OFFSET)
#define DCU0_CTRLDESCL19_4            (DCU0_BASE + DCU_CTRLDESCL19_4_OFFSET)
#define DCU0_CTRLDESCL19_5            (DCU0_BASE + DCU_CTRLDESCL19_5_OFFSET)
#define DCU0_CTRLDESCL19_6            (DCU0_BASE + DCU_CTRLDESCL19_6_OFFSET)
#define DCU0_CTRLDESCL19_7            (DCU0_BASE + DCU_CTRLDESCL19_7_OFFSET)
#define DCU0_CTRLDESCL19_8            (DCU0_BASE + DCU_CTRLDESCL19_8_OFFSET)
#define DCU0_CTRLDESCL19_9            (DCU0_BASE + DCU_CTRLDESCL19_9_OFFSET)
#define DCU0_CTRLDESCL20_1            (DCU0_BASE + DCU_CTRLDESCL20_1_OFFSET)
#define DCU0_CTRLDESCL20_2            (DCU0_BASE + DCU_CTRLDESCL20_2_OFFSET)
#define DCU0_CTRLDESCL20_3            (DCU0_BASE + DCU_CTRLDESCL20_3_OFFSET)
#define DCU0_CTRLDESCL20_4            (DCU0_BASE + DCU_CTRLDESCL20_4_OFFSET)
#define DCU0_CTRLDESCL20_5            (DCU0_BASE + DCU_CTRLDESCL20_5_OFFSET)
#define DCU0_CTRLDESCL20_6            (DCU0_BASE + DCU_CTRLDESCL20_6_OFFSET)
#define DCU0_CTRLDESCL20_7            (DCU0_BASE + DCU_CTRLDESCL20_7_OFFSET)
#define DCU0_CTRLDESCL20_8            (DCU0_BASE + DCU_CTRLDESCL20_8_OFFSET)
#define DCU0_CTRLDESCL20_9            (DCU0_BASE + DCU_CTRLDESCL20_9_OFFSET)
#define DCU0_CTRLDESCL21_1            (DCU0_BASE + DCU_CTRLDESCL21_1_OFFSET)
#define DCU0_CTRLDESCL21_2            (DCU0_BASE + DCU_CTRLDESCL21_2_OFFSET)
#define DCU0_CTRLDESCL21_3            (DCU0_BASE + DCU_CTRLDESCL21_3_OFFSET)
#define DCU0_CTRLDESCL21_4            (DCU0_BASE + DCU_CTRLDESCL21_4_OFFSET)
#define DCU0_CTRLDESCL21_5            (DCU0_BASE + DCU_CTRLDESCL21_5_OFFSET)
#define DCU0_CTRLDESCL21_6            (DCU0_BASE + DCU_CTRLDESCL21_6_OFFSET)
#define DCU0_CTRLDESCL21_7            (DCU0_BASE + DCU_CTRLDESCL21_7_OFFSET)
#define DCU0_CTRLDESCL21_8            (DCU0_BASE + DCU_CTRLDESCL21_8_OFFSET)
#define DCU0_CTRLDESCL21_9            (DCU0_BASE + DCU_CTRLDESCL21_9_OFFSET)
#define DCU0_CTRLDESCL22_1            (DCU0_BASE + DCU_CTRLDESCL22_1_OFFSET)
#define DCU0_CTRLDESCL22_2            (DCU0_BASE + DCU_CTRLDESCL22_2_OFFSET)
#define DCU0_CTRLDESCL22_3            (DCU0_BASE + DCU_CTRLDESCL22_3_OFFSET)
#define DCU0_CTRLDESCL22_4            (DCU0_BASE + DCU_CTRLDESCL22_4_OFFSET)
#define DCU0_CTRLDESCL22_5            (DCU0_BASE + DCU_CTRLDESCL22_5_OFFSET)
#define DCU0_CTRLDESCL22_6            (DCU0_BASE + DCU_CTRLDESCL22_6_OFFSET)
#define DCU0_CTRLDESCL22_7            (DCU0_BASE + DCU_CTRLDESCL22_7_OFFSET)
#define DCU0_CTRLDESCL22_8            (DCU0_BASE + DCU_CTRLDESCL22_8_OFFSET)
#define DCU0_CTRLDESCL22_9            (DCU0_BASE + DCU_CTRLDESCL22_9_OFFSET)
#define DCU0_CTRLDESCL23_1            (DCU0_BASE + DCU_CTRLDESCL23_1_OFFSET)
#define DCU0_CTRLDESCL23_2            (DCU0_BASE + DCU_CTRLDESCL23_2_OFFSET)
#define DCU0_CTRLDESCL23_3            (DCU0_BASE + DCU_CTRLDESCL23_3_OFFSET)
#define DCU0_CTRLDESCL23_4            (DCU0_BASE + DCU_CTRLDESCL23_4_OFFSET)
#define DCU0_CTRLDESCL23_5            (DCU0_BASE + DCU_CTRLDESCL23_5_OFFSET)
#define DCU0_CTRLDESCL23_6            (DCU0_BASE + DCU_CTRLDESCL23_6_OFFSET)
#define DCU0_CTRLDESCL23_7            (DCU0_BASE + DCU_CTRLDESCL23_7_OFFSET)
#define DCU0_CTRLDESCL23_8            (DCU0_BASE + DCU_CTRLDESCL23_8_OFFSET)
#define DCU0_CTRLDESCL23_9            (DCU0_BASE + DCU_CTRLDESCL23_9_OFFSET)
#define DCU0_CTRLDESCL24_1            (DCU0_BASE + DCU_CTRLDESCL24_1_OFFSET)
#define DCU0_CTRLDESCL24_2            (DCU0_BASE + DCU_CTRLDESCL24_2_OFFSET)
#define DCU0_CTRLDESCL24_3            (DCU0_BASE + DCU_CTRLDESCL24_3_OFFSET)
#define DCU0_CTRLDESCL24_4            (DCU0_BASE + DCU_CTRLDESCL24_4_OFFSET)
#define DCU0_CTRLDESCL24_5            (DCU0_BASE + DCU_CTRLDESCL24_5_OFFSET)
#define DCU0_CTRLDESCL24_6            (DCU0_BASE + DCU_CTRLDESCL24_6_OFFSET)
#define DCU0_CTRLDESCL24_7            (DCU0_BASE + DCU_CTRLDESCL24_7_OFFSET)
#define DCU0_CTRLDESCL24_8            (DCU0_BASE + DCU_CTRLDESCL24_8_OFFSET)
#define DCU0_CTRLDESCL24_9            (DCU0_BASE + DCU_CTRLDESCL24_9_OFFSET)
#define DCU0_CTRLDESCL25_1            (DCU0_BASE + DCU_CTRLDESCL25_1_OFFSET)
#define DCU0_CTRLDESCL25_2            (DCU0_BASE + DCU_CTRLDESCL25_2_OFFSET)
#define DCU0_CTRLDESCL25_3            (DCU0_BASE + DCU_CTRLDESCL25_3_OFFSET)
#define DCU0_CTRLDESCL25_4            (DCU0_BASE + DCU_CTRLDESCL25_4_OFFSET)
#define DCU0_CTRLDESCL25_5            (DCU0_BASE + DCU_CTRLDESCL25_5_OFFSET)
#define DCU0_CTRLDESCL25_6            (DCU0_BASE + DCU_CTRLDESCL25_6_OFFSET)
#define DCU0_CTRLDESCL25_7            (DCU0_BASE + DCU_CTRLDESCL25_7_OFFSET)
#define DCU0_CTRLDESCL25_8            (DCU0_BASE + DCU_CTRLDESCL25_8_OFFSET)
#define DCU0_CTRLDESCL25_9            (DCU0_BASE + DCU_CTRLDESCL25_9_OFFSET)
#define DCU0_CTRLDESCL26_1            (DCU0_BASE + DCU_CTRLDESCL26_1_OFFSET)
#define DCU0_CTRLDESCL26_2            (DCU0_BASE + DCU_CTRLDESCL26_2_OFFSET)
#define DCU0_CTRLDESCL26_3            (DCU0_BASE + DCU_CTRLDESCL26_3_OFFSET)
#define DCU0_CTRLDESCL26_4            (DCU0_BASE + DCU_CTRLDESCL26_4_OFFSET)
#define DCU0_CTRLDESCL26_5            (DCU0_BASE + DCU_CTRLDESCL26_5_OFFSET)
#define DCU0_CTRLDESCL26_6            (DCU0_BASE + DCU_CTRLDESCL26_6_OFFSET)
#define DCU0_CTRLDESCL26_7            (DCU0_BASE + DCU_CTRLDESCL26_7_OFFSET)
#define DCU0_CTRLDESCL26_8            (DCU0_BASE + DCU_CTRLDESCL26_8_OFFSET)
#define DCU0_CTRLDESCL26_9            (DCU0_BASE + DCU_CTRLDESCL26_9_OFFSET)
#define DCU0_CTRLDESCL27_1            (DCU0_BASE + DCU_CTRLDESCL27_1_OFFSET)
#define DCU0_CTRLDESCL27_2            (DCU0_BASE + DCU_CTRLDESCL27_2_OFFSET)
#define DCU0_CTRLDESCL27_3            (DCU0_BASE + DCU_CTRLDESCL27_3_OFFSET)
#define DCU0_CTRLDESCL27_4            (DCU0_BASE + DCU_CTRLDESCL27_4_OFFSET)
#define DCU0_CTRLDESCL27_5            (DCU0_BASE + DCU_CTRLDESCL27_5_OFFSET)
#define DCU0_CTRLDESCL27_6            (DCU0_BASE + DCU_CTRLDESCL27_6_OFFSET)
#define DCU0_CTRLDESCL27_7            (DCU0_BASE + DCU_CTRLDESCL27_7_OFFSET)
#define DCU0_CTRLDESCL27_8            (DCU0_BASE + DCU_CTRLDESCL27_8_OFFSET)
#define DCU0_CTRLDESCL27_9            (DCU0_BASE + DCU_CTRLDESCL27_9_OFFSET)
#define DCU0_CTRLDESCL28_1            (DCU0_BASE + DCU_CTRLDESCL28_1_OFFSET)
#define DCU0_CTRLDESCL28_2            (DCU0_BASE + DCU_CTRLDESCL28_2_OFFSET)
#define DCU0_CTRLDESCL28_3            (DCU0_BASE + DCU_CTRLDESCL28_3_OFFSET)
#define DCU0_CTRLDESCL28_4            (DCU0_BASE + DCU_CTRLDESCL28_4_OFFSET)
#define DCU0_CTRLDESCL28_5            (DCU0_BASE + DCU_CTRLDESCL28_5_OFFSET)
#define DCU0_CTRLDESCL28_6            (DCU0_BASE + DCU_CTRLDESCL28_6_OFFSET)
#define DCU0_CTRLDESCL28_7            (DCU0_BASE + DCU_CTRLDESCL28_7_OFFSET)
#define DCU0_CTRLDESCL28_8            (DCU0_BASE + DCU_CTRLDESCL28_8_OFFSET)
#define DCU0_CTRLDESCL28_9            (DCU0_BASE + DCU_CTRLDESCL28_9_OFFSET)
#define DCU0_CTRLDESCL29_1            (DCU0_BASE + DCU_CTRLDESCL29_1_OFFSET)
#define DCU0_CTRLDESCL29_2            (DCU0_BASE + DCU_CTRLDESCL29_2_OFFSET)
#define DCU0_CTRLDESCL29_3            (DCU0_BASE + DCU_CTRLDESCL29_3_OFFSET)
#define DCU0_CTRLDESCL29_4            (DCU0_BASE + DCU_CTRLDESCL29_4_OFFSET)
#define DCU0_CTRLDESCL29_5            (DCU0_BASE + DCU_CTRLDESCL29_5_OFFSET)
#define DCU0_CTRLDESCL29_6            (DCU0_BASE + DCU_CTRLDESCL29_6_OFFSET)
#define DCU0_CTRLDESCL29_7            (DCU0_BASE + DCU_CTRLDESCL29_7_OFFSET)
#define DCU0_CTRLDESCL29_8            (DCU0_BASE + DCU_CTRLDESCL29_8_OFFSET)
#define DCU0_CTRLDESCL29_9            (DCU0_BASE + DCU_CTRLDESCL29_9_OFFSET)
#define DCU0_CTRLDESCL30_1            (DCU0_BASE + DCU_CTRLDESCL30_1_OFFSET)
#define DCU0_CTRLDESCL30_2            (DCU0_BASE + DCU_CTRLDESCL30_2_OFFSET)
#define DCU0_CTRLDESCL30_3            (DCU0_BASE + DCU_CTRLDESCL30_3_OFFSET)
#define DCU0_CTRLDESCL30_4            (DCU0_BASE + DCU_CTRLDESCL30_4_OFFSET)
#define DCU0_CTRLDESCL30_5            (DCU0_BASE + DCU_CTRLDESCL30_5_OFFSET)
#define DCU0_CTRLDESCL30_6            (DCU0_BASE + DCU_CTRLDESCL30_6_OFFSET)
#define DCU0_CTRLDESCL30_7            (DCU0_BASE + DCU_CTRLDESCL30_7_OFFSET)
#define DCU0_CTRLDESCL30_8            (DCU0_BASE + DCU_CTRLDESCL30_8_OFFSET)
#define DCU0_CTRLDESCL30_9            (DCU0_BASE + DCU_CTRLDESCL30_9_OFFSET)
#define DCU0_CTRLDESCL31_1            (DCU0_BASE + DCU_CTRLDESCL31_1_OFFSET)
#define DCU0_CTRLDESCL31_2            (DCU0_BASE + DCU_CTRLDESCL31_2_OFFSET)
#define DCU0_CTRLDESCL31_3            (DCU0_BASE + DCU_CTRLDESCL31_3_OFFSET)
#define DCU0_CTRLDESCL31_4            (DCU0_BASE + DCU_CTRLDESCL31_4_OFFSET)
#define DCU0_CTRLDESCL31_5            (DCU0_BASE + DCU_CTRLDESCL31_5_OFFSET)
#define DCU0_CTRLDESCL31_6            (DCU0_BASE + DCU_CTRLDESCL31_6_OFFSET)
#define DCU0_CTRLDESCL31_7            (DCU0_BASE + DCU_CTRLDESCL31_7_OFFSET)
#define DCU0_CTRLDESCL31_8            (DCU0_BASE + DCU_CTRLDESCL31_8_OFFSET)
#define DCU0_CTRLDESCL31_9            (DCU0_BASE + DCU_CTRLDESCL31_9_OFFSET)
#define DCU0_CTRLDESCL32_1            (DCU0_BASE + DCU_CTRLDESCL32_1_OFFSET)
#define DCU0_CTRLDESCL32_2            (DCU0_BASE + DCU_CTRLDESCL32_2_OFFSET)
#define DCU0_CTRLDESCL32_3            (DCU0_BASE + DCU_CTRLDESCL32_3_OFFSET)
#define DCU0_CTRLDESCL32_4            (DCU0_BASE + DCU_CTRLDESCL32_4_OFFSET)
#define DCU0_CTRLDESCL32_5            (DCU0_BASE + DCU_CTRLDESCL32_5_OFFSET)
#define DCU0_CTRLDESCL32_6            (DCU0_BASE + DCU_CTRLDESCL32_6_OFFSET)
#define DCU0_CTRLDESCL32_7            (DCU0_BASE + DCU_CTRLDESCL32_7_OFFSET)
#define DCU0_CTRLDESCL32_8            (DCU0_BASE + DCU_CTRLDESCL32_8_OFFSET)
#define DCU0_CTRLDESCL32_9            (DCU0_BASE + DCU_CTRLDESCL32_9_OFFSET)
#define DCU0_CTRLDESCL33_1            (DCU0_BASE + DCU_CTRLDESCL33_1_OFFSET)
#define DCU0_CTRLDESCL33_2            (DCU0_BASE + DCU_CTRLDESCL33_2_OFFSET)
#define DCU0_CTRLDESCL33_3            (DCU0_BASE + DCU_CTRLDESCL33_3_OFFSET)
#define DCU0_CTRLDESCL33_4            (DCU0_BASE + DCU_CTRLDESCL33_4_OFFSET)
#define DCU0_CTRLDESCL33_5            (DCU0_BASE + DCU_CTRLDESCL33_5_OFFSET)
#define DCU0_CTRLDESCL33_6            (DCU0_BASE + DCU_CTRLDESCL33_6_OFFSET)
#define DCU0_CTRLDESCL33_7            (DCU0_BASE + DCU_CTRLDESCL33_7_OFFSET)
#define DCU0_CTRLDESCL33_8            (DCU0_BASE + DCU_CTRLDESCL33_8_OFFSET)
#define DCU0_CTRLDESCL33_9            (DCU0_BASE + DCU_CTRLDESCL33_9_OFFSET)
#define DCU0_CTRLDESCL34_1            (DCU0_BASE + DCU_CTRLDESCL34_1_OFFSET)
#define DCU0_CTRLDESCL34_2            (DCU0_BASE + DCU_CTRLDESCL34_2_OFFSET)
#define DCU0_CTRLDESCL34_3            (DCU0_BASE + DCU_CTRLDESCL34_3_OFFSET)
#define DCU0_CTRLDESCL34_4            (DCU0_BASE + DCU_CTRLDESCL34_4_OFFSET)
#define DCU0_CTRLDESCL34_5            (DCU0_BASE + DCU_CTRLDESCL34_5_OFFSET)
#define DCU0_CTRLDESCL34_6            (DCU0_BASE + DCU_CTRLDESCL34_6_OFFSET)
#define DCU0_CTRLDESCL34_7            (DCU0_BASE + DCU_CTRLDESCL34_7_OFFSET)
#define DCU0_CTRLDESCL34_8            (DCU0_BASE + DCU_CTRLDESCL34_8_OFFSET)
#define DCU0_CTRLDESCL34_9            (DCU0_BASE + DCU_CTRLDESCL34_9_OFFSET)
#define DCU0_CTRLDESCL35_1            (DCU0_BASE + DCU_CTRLDESCL35_1_OFFSET)
#define DCU0_CTRLDESCL35_2            (DCU0_BASE + DCU_CTRLDESCL35_2_OFFSET)
#define DCU0_CTRLDESCL35_3            (DCU0_BASE + DCU_CTRLDESCL35_3_OFFSET)
#define DCU0_CTRLDESCL35_4            (DCU0_BASE + DCU_CTRLDESCL35_4_OFFSET)
#define DCU0_CTRLDESCL35_5            (DCU0_BASE + DCU_CTRLDESCL35_5_OFFSET)
#define DCU0_CTRLDESCL35_6            (DCU0_BASE + DCU_CTRLDESCL35_6_OFFSET)
#define DCU0_CTRLDESCL35_7            (DCU0_BASE + DCU_CTRLDESCL35_7_OFFSET)
#define DCU0_CTRLDESCL35_8            (DCU0_BASE + DCU_CTRLDESCL35_8_OFFSET)
#define DCU0_CTRLDESCL35_9            (DCU0_BASE + DCU_CTRLDESCL35_9_OFFSET)
#define DCU0_CTRLDESCL36_1            (DCU0_BASE + DCU_CTRLDESCL36_1_OFFSET)
#define DCU0_CTRLDESCL36_2            (DCU0_BASE + DCU_CTRLDESCL36_2_OFFSET)
#define DCU0_CTRLDESCL36_3            (DCU0_BASE + DCU_CTRLDESCL36_3_OFFSET)
#define DCU0_CTRLDESCL36_4            (DCU0_BASE + DCU_CTRLDESCL36_4_OFFSET)
#define DCU0_CTRLDESCL36_5            (DCU0_BASE + DCU_CTRLDESCL36_5_OFFSET)
#define DCU0_CTRLDESCL36_6            (DCU0_BASE + DCU_CTRLDESCL36_6_OFFSET)
#define DCU0_CTRLDESCL36_7            (DCU0_BASE + DCU_CTRLDESCL36_7_OFFSET)
#define DCU0_CTRLDESCL36_8            (DCU0_BASE + DCU_CTRLDESCL36_8_OFFSET)
#define DCU0_CTRLDESCL36_9            (DCU0_BASE + DCU_CTRLDESCL36_9_OFFSET)
#define DCU0_CTRLDESCL37_1            (DCU0_BASE + DCU_CTRLDESCL37_1_OFFSET)
#define DCU0_CTRLDESCL37_2            (DCU0_BASE + DCU_CTRLDESCL37_2_OFFSET)
#define DCU0_CTRLDESCL37_3            (DCU0_BASE + DCU_CTRLDESCL37_3_OFFSET)
#define DCU0_CTRLDESCL37_4            (DCU0_BASE + DCU_CTRLDESCL37_4_OFFSET)
#define DCU0_CTRLDESCL37_5            (DCU0_BASE + DCU_CTRLDESCL37_5_OFFSET)
#define DCU0_CTRLDESCL37_6            (DCU0_BASE + DCU_CTRLDESCL37_6_OFFSET)
#define DCU0_CTRLDESCL37_7            (DCU0_BASE + DCU_CTRLDESCL37_7_OFFSET)
#define DCU0_CTRLDESCL37_8            (DCU0_BASE + DCU_CTRLDESCL37_8_OFFSET)
#define DCU0_CTRLDESCL37_9            (DCU0_BASE + DCU_CTRLDESCL37_9_OFFSET)
#define DCU0_CTRLDESCL38_1            (DCU0_BASE + DCU_CTRLDESCL38_1_OFFSET)
#define DCU0_CTRLDESCL38_2            (DCU0_BASE + DCU_CTRLDESCL38_2_OFFSET)
#define DCU0_CTRLDESCL38_3            (DCU0_BASE + DCU_CTRLDESCL38_3_OFFSET)
#define DCU0_CTRLDESCL38_4            (DCU0_BASE + DCU_CTRLDESCL38_4_OFFSET)
#define DCU0_CTRLDESCL38_5            (DCU0_BASE + DCU_CTRLDESCL38_5_OFFSET)
#define DCU0_CTRLDESCL38_6            (DCU0_BASE + DCU_CTRLDESCL38_6_OFFSET)
#define DCU0_CTRLDESCL38_7            (DCU0_BASE + DCU_CTRLDESCL38_7_OFFSET)
#define DCU0_CTRLDESCL38_8            (DCU0_BASE + DCU_CTRLDESCL38_8_OFFSET)
#define DCU0_CTRLDESCL38_9            (DCU0_BASE + DCU_CTRLDESCL38_9_OFFSET)
#define DCU0_CTRLDESCL39_1            (DCU0_BASE + DCU_CTRLDESCL39_1_OFFSET)
#define DCU0_CTRLDESCL39_2            (DCU0_BASE + DCU_CTRLDESCL39_2_OFFSET)
#define DCU0_CTRLDESCL39_3            (DCU0_BASE + DCU_CTRLDESCL39_3_OFFSET)
#define DCU0_CTRLDESCL39_4            (DCU0_BASE + DCU_CTRLDESCL39_4_OFFSET)
#define DCU0_CTRLDESCL39_5            (DCU0_BASE + DCU_CTRLDESCL39_5_OFFSET)
#define DCU0_CTRLDESCL39_6            (DCU0_BASE + DCU_CTRLDESCL39_6_OFFSET)
#define DCU0_CTRLDESCL39_7            (DCU0_BASE + DCU_CTRLDESCL39_7_OFFSET)
#define DCU0_CTRLDESCL39_8            (DCU0_BASE + DCU_CTRLDESCL39_8_OFFSET)
#define DCU0_CTRLDESCL39_9            (DCU0_BASE + DCU_CTRLDESCL39_9_OFFSET)
#define DCU0_CTRLDESCL40_1            (DCU0_BASE + DCU_CTRLDESCL40_1_OFFSET)
#define DCU0_CTRLDESCL40_2            (DCU0_BASE + DCU_CTRLDESCL40_2_OFFSET)
#define DCU0_CTRLDESCL40_3            (DCU0_BASE + DCU_CTRLDESCL40_3_OFFSET)
#define DCU0_CTRLDESCL40_4            (DCU0_BASE + DCU_CTRLDESCL40_4_OFFSET)
#define DCU0_CTRLDESCL40_5            (DCU0_BASE + DCU_CTRLDESCL40_5_OFFSET)
#define DCU0_CTRLDESCL40_6            (DCU0_BASE + DCU_CTRLDESCL40_6_OFFSET)
#define DCU0_CTRLDESCL40_7            (DCU0_BASE + DCU_CTRLDESCL40_7_OFFSET)
#define DCU0_CTRLDESCL40_8            (DCU0_BASE + DCU_CTRLDESCL40_8_OFFSET)
#define DCU0_CTRLDESCL40_9            (DCU0_BASE + DCU_CTRLDESCL40_9_OFFSET)
#define DCU0_CTRLDESCL41_1            (DCU0_BASE + DCU_CTRLDESCL41_1_OFFSET)
#define DCU0_CTRLDESCL41_2            (DCU0_BASE + DCU_CTRLDESCL41_2_OFFSET)
#define DCU0_CTRLDESCL41_3            (DCU0_BASE + DCU_CTRLDESCL41_3_OFFSET)
#define DCU0_CTRLDESCL41_4            (DCU0_BASE + DCU_CTRLDESCL41_4_OFFSET)
#define DCU0_CTRLDESCL41_5            (DCU0_BASE + DCU_CTRLDESCL41_5_OFFSET)
#define DCU0_CTRLDESCL41_6            (DCU0_BASE + DCU_CTRLDESCL41_6_OFFSET)
#define DCU0_CTRLDESCL41_7            (DCU0_BASE + DCU_CTRLDESCL41_7_OFFSET)
#define DCU0_CTRLDESCL41_8            (DCU0_BASE + DCU_CTRLDESCL41_8_OFFSET)
#define DCU0_CTRLDESCL41_9            (DCU0_BASE + DCU_CTRLDESCL41_9_OFFSET)
#define DCU0_CTRLDESCL42_1            (DCU0_BASE + DCU_CTRLDESCL42_1_OFFSET)
#define DCU0_CTRLDESCL42_2            (DCU0_BASE + DCU_CTRLDESCL42_2_OFFSET)
#define DCU0_CTRLDESCL42_3            (DCU0_BASE + DCU_CTRLDESCL42_3_OFFSET)
#define DCU0_CTRLDESCL42_4            (DCU0_BASE + DCU_CTRLDESCL42_4_OFFSET)
#define DCU0_CTRLDESCL42_5            (DCU0_BASE + DCU_CTRLDESCL42_5_OFFSET)
#define DCU0_CTRLDESCL42_6            (DCU0_BASE + DCU_CTRLDESCL42_6_OFFSET)
#define DCU0_CTRLDESCL42_7            (DCU0_BASE + DCU_CTRLDESCL42_7_OFFSET)
#define DCU0_CTRLDESCL42_8            (DCU0_BASE + DCU_CTRLDESCL42_8_OFFSET)
#define DCU0_CTRLDESCL42_9            (DCU0_BASE + DCU_CTRLDESCL42_9_OFFSET)
#define DCU0_CTRLDESCL43_1            (DCU0_BASE + DCU_CTRLDESCL43_1_OFFSET)
#define DCU0_CTRLDESCL43_2            (DCU0_BASE + DCU_CTRLDESCL43_2_OFFSET)
#define DCU0_CTRLDESCL43_3            (DCU0_BASE + DCU_CTRLDESCL43_3_OFFSET)
#define DCU0_CTRLDESCL43_4            (DCU0_BASE + DCU_CTRLDESCL43_4_OFFSET)
#define DCU0_CTRLDESCL43_5            (DCU0_BASE + DCU_CTRLDESCL43_5_OFFSET)
#define DCU0_CTRLDESCL43_6            (DCU0_BASE + DCU_CTRLDESCL43_6_OFFSET)
#define DCU0_CTRLDESCL43_7            (DCU0_BASE + DCU_CTRLDESCL43_7_OFFSET)
#define DCU0_CTRLDESCL43_8            (DCU0_BASE + DCU_CTRLDESCL43_8_OFFSET)
#define DCU0_CTRLDESCL43_9            (DCU0_BASE + DCU_CTRLDESCL43_9_OFFSET)
#define DCU0_CTRLDESCL44_1            (DCU0_BASE + DCU_CTRLDESCL44_1_OFFSET)
#define DCU0_CTRLDESCL44_2            (DCU0_BASE + DCU_CTRLDESCL44_2_OFFSET)
#define DCU0_CTRLDESCL44_3            (DCU0_BASE + DCU_CTRLDESCL44_3_OFFSET)
#define DCU0_CTRLDESCL44_4            (DCU0_BASE + DCU_CTRLDESCL44_4_OFFSET)
#define DCU0_CTRLDESCL44_5            (DCU0_BASE + DCU_CTRLDESCL44_5_OFFSET)
#define DCU0_CTRLDESCL44_6            (DCU0_BASE + DCU_CTRLDESCL44_6_OFFSET)
#define DCU0_CTRLDESCL44_7            (DCU0_BASE + DCU_CTRLDESCL44_7_OFFSET)
#define DCU0_CTRLDESCL44_8            (DCU0_BASE + DCU_CTRLDESCL44_8_OFFSET)
#define DCU0_CTRLDESCL44_9            (DCU0_BASE + DCU_CTRLDESCL44_9_OFFSET)
#define DCU0_CTRLDESCL45_1            (DCU0_BASE + DCU_CTRLDESCL45_1_OFFSET)
#define DCU0_CTRLDESCL45_2            (DCU0_BASE + DCU_CTRLDESCL45_2_OFFSET)
#define DCU0_CTRLDESCL45_3            (DCU0_BASE + DCU_CTRLDESCL45_3_OFFSET)
#define DCU0_CTRLDESCL45_4            (DCU0_BASE + DCU_CTRLDESCL45_4_OFFSET)
#define DCU0_CTRLDESCL45_5            (DCU0_BASE + DCU_CTRLDESCL45_5_OFFSET)
#define DCU0_CTRLDESCL45_6            (DCU0_BASE + DCU_CTRLDESCL45_6_OFFSET)
#define DCU0_CTRLDESCL45_7            (DCU0_BASE + DCU_CTRLDESCL45_7_OFFSET)
#define DCU0_CTRLDESCL45_8            (DCU0_BASE + DCU_CTRLDESCL45_8_OFFSET)
#define DCU0_CTRLDESCL45_9            (DCU0_BASE + DCU_CTRLDESCL45_9_OFFSET)
#define DCU0_CTRLDESCL46_1            (DCU0_BASE + DCU_CTRLDESCL46_1_OFFSET)
#define DCU0_CTRLDESCL46_2            (DCU0_BASE + DCU_CTRLDESCL46_2_OFFSET)
#define DCU0_CTRLDESCL46_3            (DCU0_BASE + DCU_CTRLDESCL46_3_OFFSET)
#define DCU0_CTRLDESCL46_4            (DCU0_BASE + DCU_CTRLDESCL46_4_OFFSET)
#define DCU0_CTRLDESCL46_5            (DCU0_BASE + DCU_CTRLDESCL46_5_OFFSET)
#define DCU0_CTRLDESCL46_6            (DCU0_BASE + DCU_CTRLDESCL46_6_OFFSET)
#define DCU0_CTRLDESCL46_7            (DCU0_BASE + DCU_CTRLDESCL46_7_OFFSET)
#define DCU0_CTRLDESCL46_8            (DCU0_BASE + DCU_CTRLDESCL46_8_OFFSET)
#define DCU0_CTRLDESCL46_9            (DCU0_BASE + DCU_CTRLDESCL46_9_OFFSET)
#define DCU0_CTRLDESCL47_1            (DCU0_BASE + DCU_CTRLDESCL47_1_OFFSET)
#define DCU0_CTRLDESCL47_2            (DCU0_BASE + DCU_CTRLDESCL47_2_OFFSET)
#define DCU0_CTRLDESCL47_3            (DCU0_BASE + DCU_CTRLDESCL47_3_OFFSET)
#define DCU0_CTRLDESCL47_4            (DCU0_BASE + DCU_CTRLDESCL47_4_OFFSET)
#define DCU0_CTRLDESCL47_5            (DCU0_BASE + DCU_CTRLDESCL47_5_OFFSET)
#define DCU0_CTRLDESCL47_6            (DCU0_BASE + DCU_CTRLDESCL47_6_OFFSET)
#define DCU0_CTRLDESCL47_7            (DCU0_BASE + DCU_CTRLDESCL47_7_OFFSET)
#define DCU0_CTRLDESCL47_8            (DCU0_BASE + DCU_CTRLDESCL47_8_OFFSET)
#define DCU0_CTRLDESCL47_9            (DCU0_BASE + DCU_CTRLDESCL47_9_OFFSET)
#define DCU0_CTRLDESCL48_1            (DCU0_BASE + DCU_CTRLDESCL48_1_OFFSET)
#define DCU0_CTRLDESCL48_2            (DCU0_BASE + DCU_CTRLDESCL48_2_OFFSET)
#define DCU0_CTRLDESCL48_3            (DCU0_BASE + DCU_CTRLDESCL48_3_OFFSET)
#define DCU0_CTRLDESCL48_4            (DCU0_BASE + DCU_CTRLDESCL48_4_OFFSET)
#define DCU0_CTRLDESCL48_5            (DCU0_BASE + DCU_CTRLDESCL48_5_OFFSET)
#define DCU0_CTRLDESCL48_6            (DCU0_BASE + DCU_CTRLDESCL48_6_OFFSET)
#define DCU0_CTRLDESCL48_7            (DCU0_BASE + DCU_CTRLDESCL48_7_OFFSET)
#define DCU0_CTRLDESCL48_8            (DCU0_BASE + DCU_CTRLDESCL48_8_OFFSET)
#define DCU0_CTRLDESCL48_9            (DCU0_BASE + DCU_CTRLDESCL48_9_OFFSET)
#define DCU0_CTRLDESCL49_1            (DCU0_BASE + DCU_CTRLDESCL49_1_OFFSET)
#define DCU0_CTRLDESCL49_2            (DCU0_BASE + DCU_CTRLDESCL49_2_OFFSET)
#define DCU0_CTRLDESCL49_3            (DCU0_BASE + DCU_CTRLDESCL49_3_OFFSET)
#define DCU0_CTRLDESCL49_4            (DCU0_BASE + DCU_CTRLDESCL49_4_OFFSET)
#define DCU0_CTRLDESCL49_5            (DCU0_BASE + DCU_CTRLDESCL49_5_OFFSET)
#define DCU0_CTRLDESCL49_6            (DCU0_BASE + DCU_CTRLDESCL49_6_OFFSET)
#define DCU0_CTRLDESCL49_7            (DCU0_BASE + DCU_CTRLDESCL49_7_OFFSET)
#define DCU0_CTRLDESCL49_8            (DCU0_BASE + DCU_CTRLDESCL49_8_OFFSET)
#define DCU0_CTRLDESCL49_9            (DCU0_BASE + DCU_CTRLDESCL49_9_OFFSET)
#define DCU0_CTRLDESCL50_1            (DCU0_BASE + DCU_CTRLDESCL50_1_OFFSET)
#define DCU0_CTRLDESCL50_2            (DCU0_BASE + DCU_CTRLDESCL50_2_OFFSET)
#define DCU0_CTRLDESCL50_3            (DCU0_BASE + DCU_CTRLDESCL50_3_OFFSET)
#define DCU0_CTRLDESCL50_4            (DCU0_BASE + DCU_CTRLDESCL50_4_OFFSET)
#define DCU0_CTRLDESCL50_5            (DCU0_BASE + DCU_CTRLDESCL50_5_OFFSET)
#define DCU0_CTRLDESCL50_6            (DCU0_BASE + DCU_CTRLDESCL50_6_OFFSET)
#define DCU0_CTRLDESCL50_7            (DCU0_BASE + DCU_CTRLDESCL50_7_OFFSET)
#define DCU0_CTRLDESCL50_8            (DCU0_BASE + DCU_CTRLDESCL50_8_OFFSET)
#define DCU0_CTRLDESCL50_9            (DCU0_BASE + DCU_CTRLDESCL50_9_OFFSET)
#define DCU0_CTRLDESCL51_1            (DCU0_BASE + DCU_CTRLDESCL51_1_OFFSET)
#define DCU0_CTRLDESCL51_2            (DCU0_BASE + DCU_CTRLDESCL51_2_OFFSET)
#define DCU0_CTRLDESCL51_3            (DCU0_BASE + DCU_CTRLDESCL51_3_OFFSET)
#define DCU0_CTRLDESCL51_4            (DCU0_BASE + DCU_CTRLDESCL51_4_OFFSET)
#define DCU0_CTRLDESCL51_5            (DCU0_BASE + DCU_CTRLDESCL51_5_OFFSET)
#define DCU0_CTRLDESCL51_6            (DCU0_BASE + DCU_CTRLDESCL51_6_OFFSET)
#define DCU0_CTRLDESCL51_7            (DCU0_BASE + DCU_CTRLDESCL51_7_OFFSET)
#define DCU0_CTRLDESCL51_8            (DCU0_BASE + DCU_CTRLDESCL51_8_OFFSET)
#define DCU0_CTRLDESCL51_9            (DCU0_BASE + DCU_CTRLDESCL51_9_OFFSET)
#define DCU0_CTRLDESCL52_1            (DCU0_BASE + DCU_CTRLDESCL52_1_OFFSET)
#define DCU0_CTRLDESCL52_2            (DCU0_BASE + DCU_CTRLDESCL52_2_OFFSET)
#define DCU0_CTRLDESCL52_3            (DCU0_BASE + DCU_CTRLDESCL52_3_OFFSET)
#define DCU0_CTRLDESCL52_4            (DCU0_BASE + DCU_CTRLDESCL52_4_OFFSET)
#define DCU0_CTRLDESCL52_5            (DCU0_BASE + DCU_CTRLDESCL52_5_OFFSET)
#define DCU0_CTRLDESCL52_6            (DCU0_BASE + DCU_CTRLDESCL52_6_OFFSET)
#define DCU0_CTRLDESCL52_7            (DCU0_BASE + DCU_CTRLDESCL52_7_OFFSET)
#define DCU0_CTRLDESCL52_8            (DCU0_BASE + DCU_CTRLDESCL52_8_OFFSET)
#define DCU0_CTRLDESCL52_9            (DCU0_BASE + DCU_CTRLDESCL52_9_OFFSET)
#define DCU0_CTRLDESCL53_1            (DCU0_BASE + DCU_CTRLDESCL53_1_OFFSET)
#define DCU0_CTRLDESCL53_2            (DCU0_BASE + DCU_CTRLDESCL53_2_OFFSET)
#define DCU0_CTRLDESCL53_3            (DCU0_BASE + DCU_CTRLDESCL53_3_OFFSET)
#define DCU0_CTRLDESCL53_4            (DCU0_BASE + DCU_CTRLDESCL53_4_OFFSET)
#define DCU0_CTRLDESCL53_5            (DCU0_BASE + DCU_CTRLDESCL53_5_OFFSET)
#define DCU0_CTRLDESCL53_6            (DCU0_BASE + DCU_CTRLDESCL53_6_OFFSET)
#define DCU0_CTRLDESCL53_7            (DCU0_BASE + DCU_CTRLDESCL53_7_OFFSET)
#define DCU0_CTRLDESCL53_8            (DCU0_BASE + DCU_CTRLDESCL53_8_OFFSET)
#define DCU0_CTRLDESCL53_9            (DCU0_BASE + DCU_CTRLDESCL53_9_OFFSET)
#define DCU0_CTRLDESCL54_1            (DCU0_BASE + DCU_CTRLDESCL54_1_OFFSET)
#define DCU0_CTRLDESCL54_2            (DCU0_BASE + DCU_CTRLDESCL54_2_OFFSET)
#define DCU0_CTRLDESCL54_3            (DCU0_BASE + DCU_CTRLDESCL54_3_OFFSET)
#define DCU0_CTRLDESCL54_4            (DCU0_BASE + DCU_CTRLDESCL54_4_OFFSET)
#define DCU0_CTRLDESCL54_5            (DCU0_BASE + DCU_CTRLDESCL54_5_OFFSET)
#define DCU0_CTRLDESCL54_6            (DCU0_BASE + DCU_CTRLDESCL54_6_OFFSET)
#define DCU0_CTRLDESCL54_7            (DCU0_BASE + DCU_CTRLDESCL54_7_OFFSET)
#define DCU0_CTRLDESCL54_8            (DCU0_BASE + DCU_CTRLDESCL54_8_OFFSET)
#define DCU0_CTRLDESCL54_9            (DCU0_BASE + DCU_CTRLDESCL54_9_OFFSET)
#define DCU0_CTRLDESCL55_1            (DCU0_BASE + DCU_CTRLDESCL55_1_OFFSET)
#define DCU0_CTRLDESCL55_2            (DCU0_BASE + DCU_CTRLDESCL55_2_OFFSET)
#define DCU0_CTRLDESCL55_3            (DCU0_BASE + DCU_CTRLDESCL55_3_OFFSET)
#define DCU0_CTRLDESCL55_4            (DCU0_BASE + DCU_CTRLDESCL55_4_OFFSET)
#define DCU0_CTRLDESCL55_5            (DCU0_BASE + DCU_CTRLDESCL55_5_OFFSET)
#define DCU0_CTRLDESCL55_6            (DCU0_BASE + DCU_CTRLDESCL55_6_OFFSET)
#define DCU0_CTRLDESCL55_7            (DCU0_BASE + DCU_CTRLDESCL55_7_OFFSET)
#define DCU0_CTRLDESCL55_8            (DCU0_BASE + DCU_CTRLDESCL55_8_OFFSET)
#define DCU0_CTRLDESCL55_9            (DCU0_BASE + DCU_CTRLDESCL55_9_OFFSET)
#define DCU0_CTRLDESCL56_1            (DCU0_BASE + DCU_CTRLDESCL56_1_OFFSET)
#define DCU0_CTRLDESCL56_2            (DCU0_BASE + DCU_CTRLDESCL56_2_OFFSET)
#define DCU0_CTRLDESCL56_3            (DCU0_BASE + DCU_CTRLDESCL56_3_OFFSET)
#define DCU0_CTRLDESCL56_4            (DCU0_BASE + DCU_CTRLDESCL56_4_OFFSET)
#define DCU0_CTRLDESCL56_5            (DCU0_BASE + DCU_CTRLDESCL56_5_OFFSET)
#define DCU0_CTRLDESCL56_6            (DCU0_BASE + DCU_CTRLDESCL56_6_OFFSET)
#define DCU0_CTRLDESCL56_7            (DCU0_BASE + DCU_CTRLDESCL56_7_OFFSET)
#define DCU0_CTRLDESCL56_8            (DCU0_BASE + DCU_CTRLDESCL56_8_OFFSET)
#define DCU0_CTRLDESCL56_9            (DCU0_BASE + DCU_CTRLDESCL56_9_OFFSET)
#define DCU0_CTRLDESCL57_1            (DCU0_BASE + DCU_CTRLDESCL57_1_OFFSET)
#define DCU0_CTRLDESCL57_2            (DCU0_BASE + DCU_CTRLDESCL57_2_OFFSET)
#define DCU0_CTRLDESCL57_3            (DCU0_BASE + DCU_CTRLDESCL57_3_OFFSET)
#define DCU0_CTRLDESCL57_4            (DCU0_BASE + DCU_CTRLDESCL57_4_OFFSET)
#define DCU0_CTRLDESCL57_5            (DCU0_BASE + DCU_CTRLDESCL57_5_OFFSET)
#define DCU0_CTRLDESCL57_6            (DCU0_BASE + DCU_CTRLDESCL57_6_OFFSET)
#define DCU0_CTRLDESCL57_7            (DCU0_BASE + DCU_CTRLDESCL57_7_OFFSET)
#define DCU0_CTRLDESCL57_8            (DCU0_BASE + DCU_CTRLDESCL57_8_OFFSET)
#define DCU0_CTRLDESCL57_9            (DCU0_BASE + DCU_CTRLDESCL57_9_OFFSET)
#define DCU0_CTRLDESCL58_1            (DCU0_BASE + DCU_CTRLDESCL58_1_OFFSET)
#define DCU0_CTRLDESCL58_2            (DCU0_BASE + DCU_CTRLDESCL58_2_OFFSET)
#define DCU0_CTRLDESCL58_3            (DCU0_BASE + DCU_CTRLDESCL58_3_OFFSET)
#define DCU0_CTRLDESCL58_4            (DCU0_BASE + DCU_CTRLDESCL58_4_OFFSET)
#define DCU0_CTRLDESCL58_5            (DCU0_BASE + DCU_CTRLDESCL58_5_OFFSET)
#define DCU0_CTRLDESCL58_6            (DCU0_BASE + DCU_CTRLDESCL58_6_OFFSET)
#define DCU0_CTRLDESCL58_7            (DCU0_BASE + DCU_CTRLDESCL58_7_OFFSET)
#define DCU0_CTRLDESCL58_8            (DCU0_BASE + DCU_CTRLDESCL58_8_OFFSET)
#define DCU0_CTRLDESCL58_9            (DCU0_BASE + DCU_CTRLDESCL58_9_OFFSET)
#define DCU0_CTRLDESCL59_1            (DCU0_BASE + DCU_CTRLDESCL59_1_OFFSET)
#define DCU0_CTRLDESCL59_2            (DCU0_BASE + DCU_CTRLDESCL59_2_OFFSET)
#define DCU0_CTRLDESCL59_3            (DCU0_BASE + DCU_CTRLDESCL59_3_OFFSET)
#define DCU0_CTRLDESCL59_4            (DCU0_BASE + DCU_CTRLDESCL59_4_OFFSET)
#define DCU0_CTRLDESCL59_5            (DCU0_BASE + DCU_CTRLDESCL59_5_OFFSET)
#define DCU0_CTRLDESCL59_6            (DCU0_BASE + DCU_CTRLDESCL59_6_OFFSET)
#define DCU0_CTRLDESCL59_7            (DCU0_BASE + DCU_CTRLDESCL59_7_OFFSET)
#define DCU0_CTRLDESCL59_8            (DCU0_BASE + DCU_CTRLDESCL59_8_OFFSET)
#define DCU0_CTRLDESCL59_9            (DCU0_BASE + DCU_CTRLDESCL59_9_OFFSET)
#define DCU0_CTRLDESCL60_1            (DCU0_BASE + DCU_CTRLDESCL60_1_OFFSET)
#define DCU0_CTRLDESCL60_2            (DCU0_BASE + DCU_CTRLDESCL60_2_OFFSET)
#define DCU0_CTRLDESCL60_3            (DCU0_BASE + DCU_CTRLDESCL60_3_OFFSET)
#define DCU0_CTRLDESCL60_4            (DCU0_BASE + DCU_CTRLDESCL60_4_OFFSET)
#define DCU0_CTRLDESCL60_5            (DCU0_BASE + DCU_CTRLDESCL60_5_OFFSET)
#define DCU0_CTRLDESCL60_6            (DCU0_BASE + DCU_CTRLDESCL60_6_OFFSET)
#define DCU0_CTRLDESCL60_7            (DCU0_BASE + DCU_CTRLDESCL60_7_OFFSET)
#define DCU0_CTRLDESCL60_8            (DCU0_BASE + DCU_CTRLDESCL60_8_OFFSET)
#define DCU0_CTRLDESCL60_9            (DCU0_BASE + DCU_CTRLDESCL60_9_OFFSET)
#define DCU0_CTRLDESCL61_1            (DCU0_BASE + DCU_CTRLDESCL61_1_OFFSET)
#define DCU0_CTRLDESCL61_2            (DCU0_BASE + DCU_CTRLDESCL61_2_OFFSET)
#define DCU0_CTRLDESCL61_3            (DCU0_BASE + DCU_CTRLDESCL61_3_OFFSET)
#define DCU0_CTRLDESCL61_4            (DCU0_BASE + DCU_CTRLDESCL61_4_OFFSET)
#define DCU0_CTRLDESCL61_5            (DCU0_BASE + DCU_CTRLDESCL61_5_OFFSET)
#define DCU0_CTRLDESCL61_6            (DCU0_BASE + DCU_CTRLDESCL61_6_OFFSET)
#define DCU0_CTRLDESCL61_7            (DCU0_BASE + DCU_CTRLDESCL61_7_OFFSET)
#define DCU0_CTRLDESCL61_8            (DCU0_BASE + DCU_CTRLDESCL61_8_OFFSET)
#define DCU0_CTRLDESCL61_9            (DCU0_BASE + DCU_CTRLDESCL61_9_OFFSET)
#define DCU0_CTRLDESCL62_1            (DCU0_BASE + DCU_CTRLDESCL62_1_OFFSET)
#define DCU0_CTRLDESCL62_2            (DCU0_BASE + DCU_CTRLDESCL62_2_OFFSET)
#define DCU0_CTRLDESCL62_3            (DCU0_BASE + DCU_CTRLDESCL62_3_OFFSET)
#define DCU0_CTRLDESCL62_4            (DCU0_BASE + DCU_CTRLDESCL62_4_OFFSET)
#define DCU0_CTRLDESCL62_5            (DCU0_BASE + DCU_CTRLDESCL62_5_OFFSET)
#define DCU0_CTRLDESCL62_6            (DCU0_BASE + DCU_CTRLDESCL62_6_OFFSET)
#define DCU0_CTRLDESCL62_7            (DCU0_BASE + DCU_CTRLDESCL62_7_OFFSET)
#define DCU0_CTRLDESCL62_8            (DCU0_BASE + DCU_CTRLDESCL62_8_OFFSET)
#define DCU0_CTRLDESCL62_9            (DCU0_BASE + DCU_CTRLDESCL62_9_OFFSET)
#define DCU0_CTRLDESCL63_1            (DCU0_BASE + DCU_CTRLDESCL63_1_OFFSET)
#define DCU0_CTRLDESCL63_2            (DCU0_BASE + DCU_CTRLDESCL63_2_OFFSET)
#define DCU0_CTRLDESCL63_3            (DCU0_BASE + DCU_CTRLDESCL63_3_OFFSET)
#define DCU0_CTRLDESCL63_4            (DCU0_BASE + DCU_CTRLDESCL63_4_OFFSET)
#define DCU0_CTRLDESCL63_5            (DCU0_BASE + DCU_CTRLDESCL63_5_OFFSET)
#define DCU0_CTRLDESCL63_6            (DCU0_BASE + DCU_CTRLDESCL63_6_OFFSET)
#define DCU0_CTRLDESCL63_7            (DCU0_BASE + DCU_CTRLDESCL63_7_OFFSET)
#define DCU0_CTRLDESCL63_8            (DCU0_BASE + DCU_CTRLDESCL63_8_OFFSET)
#define DCU0_CTRLDESCL63_9            (DCU0_BASE + DCU_CTRLDESCL63_9_OFFSET)

#define DCU1_CTRLDESCCURSOR1          (DCU1_BASE + DCU_CTRLDESCCURSOR1_OFFSET)
#define DCU1_CTRLDESCCURSOR2          (DCU1_BASE + DCU_CTRLDESCCURSOR2_OFFSET)
#define DCU1_CTRLDESCCURSOR3          (DCU1_BASE + DCU_CTRLDESCCURSOR3_OFFSET)
#define DCU1_CTRLDESCCURSOR4          (DCU1_BASE + DCU_CTRLDESCCURSOR4_OFFSET)
#define DCU1_DCU_MODE                 (DCU1_BASE + DCU_DCU_MODE_OFFSET)
#define DCU1_BGND                     (DCU1_BASE + DCU_BGND_OFFSET)
#define DCU1_DISP_SIZE                (DCU1_BASE + DCU_DISP_SIZE_OFFSET)
#define DCU1_HSYN_PARA                (DCU1_BASE + DCU_HSYN_PARA_OFFSET)
#define DCU1_VSYN_PARA                (DCU1_BASE + DCU_VSYN_PARA_OFFSET)
#define DCU1_SYNPOL                   (DCU1_BASE + DCU_SYNPOL_OFFSET)
#define DCU1_THRESHOLD                (DCU1_BASE + DCU_THRESHOLD_OFFSET)
#define DCU1_INT_STATUS               (DCU1_BASE + DCU_INT_STATUS_OFFSET)
#define DCU1_INT_MASK                 (DCU1_BASE + DCU_INT_MASK_OFFSET)
#define DCU1_COLBAR_1                 (DCU1_BASE + DCU_COLBAR_1_OFFSET)
#define DCU1_COLBAR_2                 (DCU1_BASE + DCU_COLBAR_2_OFFSET)
#define DCU1_COLBAR_3                 (DCU1_BASE + DCU_COLBAR_3_OFFSET)
#define DCU1_COLBAR_4                 (DCU1_BASE + DCU_COLBAR_4_OFFSET)
#define DCU1_COLBAR_5                 (DCU1_BASE + DCU_COLBAR_5_OFFSET)
#define DCU1_COLBAR_6                 (DCU1_BASE + DCU_COLBAR_6_OFFSET)
#define DCU1_COLBAR_7                 (DCU1_BASE + DCU_COLBAR_7_OFFSET)
#define DCU1_COLBAR_8                 (DCU1_BASE + DCU_COLBAR_8_OFFSET)
#define DCU1_DIV_RATIO                (DCU1_BASE + DCU_DIV_RATIO_OFFSET)
#define DCU1_SIGN_CALC_1              (DCU1_BASE + DCU_SIGN_CALC_1_OFFSET)
#define DCU1_SIGN_CALC_2              (DCU1_BASE + DCU_SIGN_CALC_2_OFFSET)
#define DCU1_CRC_VAL                  (DCU1_BASE + DCU_CRC_VAL_OFFSET)
#define DCU1_PARR_ERR_STATUS1         (DCU1_BASE + DCU_PARR_ERR_STATUS1_OFFSET)
#define DCU1_PARR_ERR_STATUS2         (DCU1_BASE + DCU_PARR_ERR_STATUS2_OFFSET)
#define DCU1_PARR_ERR_STATUS3         (DCU1_BASE + DCU_PARR_ERR_STATUS3_OFFSET)
#define DCU1_MASK_PARR_ERR_STATUS1    (DCU1_BASE + DCU_MASK_PARR_ERR_STATUS1_OFFSET)
#define DCU1_MASK_PARR_ERR_STATUS2    (DCU1_BASE + DCU_MASK_PARR_ERR_STATUS2_OFFSET)
#define DCU1_MASK_PARR_ERR_STATUS3    (DCU1_BASE + DCU_MASK_PARR_ERR_STATUS3_OFFSET)
#define DCU1_THRESHOLD_INP_BUF_1      (DCU1_BASE + DCU_THRESHOLD_INP_BUF_1_OFFSET)
#define DCU1_THRESHOLD_INP_BUF_2      (DCU1_BASE + DCU_THRESHOLD_INP_BUF_2_OFFSET)
#define DCU1_THRESHOLD_INP_BUF_3      (DCU1_BASE + DCU_THRESHOLD_INP_BUF_3_OFFSET)
#define DCU1_LUMA_COMP                (DCU1_BASE + DCU_LUMA_COMP_OFFSET)
#define DCU1_CHROMA_RED               (DCU1_BASE + DCU_CHROMA_RED_OFFSET)
#define DCU1_CHROMA_GREEN             (DCU1_BASE + DCU_CHROMA_GREEN_OFFSET)
#define DCU1_CHROMA_BLUE              (DCU1_BASE + DCU_CHROMA_BLUE_OFFSET)
#define DCU1_CRC_POS                  (DCU1_BASE + DCU_CRC_POS_OFFSET)
#define DCU1_LYR_INTPOL_EN            (DCU1_BASE + DCU_LYR_INTPOL_EN_OFFSET)
#define DCU1_LYR_LUMA_COMP            (DCU1_BASE + DCU_LYR_LUMA_COMP_OFFSET)
#define DCU1_LYR_CHROMA_RED           (DCU1_BASE + DCU_LYR_CHROMA_RED_OFFSET)
#define DCU1_LYR_CHROMA_GREEN         (DCU1_BASE + DCU_LYR_CHROMA_GREEN_OFFSET)
#define DCU1_LYR_CHROMA_BLUE          (DCU1_BASE + DCU_LYR_CHROMA_BLUE_OFFSET)
#define DCU1_COMP_IMSIZE              (DCU1_BASE + DCU_COMP_IMSIZE_OFFSET)
#define DCU1_UPDATE_MODE              (DCU1_BASE + DCU_UPDATE_MODE_OFFSET)
#define DCU1_UNDERRUN                 (DCU1_BASE + DCU_UNDERRUN_OFFSET)
#define DCU1_GPR                      (DCU1_BASE + DCU_GPR_OFFSET)
#define DCU1_SLR_L0                   (DCU1_BASE + DCU_SLR_L0_OFFSET)
#define DCU1_SLR_L1                   (DCU1_BASE + DCU_SLR_L1_OFFSET)
#define DCU1_SLR_DISP_SIZE            (DCU1_BASE + DCU_SLR_DISP_SIZE_OFFSET)
#define DCU1_SLR_HVSYNC_PARA          (DCU1_BASE + DCU_SLR_HVSYNC_PARA_OFFSET)
#define DCU1_SLR_POL                  (DCU1_BASE + DCU_SLR_POL_OFFSET)
#define DCU1_SLR_L0TRANSP             (DCU1_BASE + DCU_SLR_L0TRANSP_OFFSET)
#define DCU1_SLR_L1TRANSP             (DCU1_BASE + DCU_SLR_L1TRANSP_OFFSET)
#define DCU1_CTRLDESCL0_1             (DCU1_BASE + DCU_CTRLDESCL0_1_OFFSET)
#define DCU1_CTRLDESCL0_2             (DCU1_BASE + DCU_CTRLDESCL0_2_OFFSET)
#define DCU1_CTRLDESCL0_3             (DCU1_BASE + DCU_CTRLDESCL0_3_OFFSET)
#define DCU1_CTRLDESCL0_4             (DCU1_BASE + DCU_CTRLDESCL0_4_OFFSET)
#define DCU1_CTRLDESCL0_5             (DCU1_BASE + DCU_CTRLDESCL0_5_OFFSET)
#define DCU1_CTRLDESCL0_6             (DCU1_BASE + DCU_CTRLDESCL0_6_OFFSET)
#define DCU1_CTRLDESCL0_7             (DCU1_BASE + DCU_CTRLDESCL0_7_OFFSET)
#define DCU1_CTRLDESCL0_8             (DCU1_BASE + DCU_CTRLDESCL0_8_OFFSET)
#define DCU1_CTRLDESCL0_9             (DCU1_BASE + DCU_CTRLDESCL0_9_OFFSET)
#define DCU1_CTRLDESCL1_1             (DCU1_BASE + DCU_CTRLDESCL1_1_OFFSET)
#define DCU1_CTRLDESCL1_2             (DCU1_BASE + DCU_CTRLDESCL1_2_OFFSET)
#define DCU1_CTRLDESCL1_3             (DCU1_BASE + DCU_CTRLDESCL1_3_OFFSET)
#define DCU1_CTRLDESCL1_4             (DCU1_BASE + DCU_CTRLDESCL1_4_OFFSET)
#define DCU1_CTRLDESCL1_5             (DCU1_BASE + DCU_CTRLDESCL1_5_OFFSET)
#define DCU1_CTRLDESCL1_6             (DCU1_BASE + DCU_CTRLDESCL1_6_OFFSET)
#define DCU1_CTRLDESCL1_7             (DCU1_BASE + DCU_CTRLDESCL1_7_OFFSET)
#define DCU1_CTRLDESCL1_8             (DCU1_BASE + DCU_CTRLDESCL1_8_OFFSET)
#define DCU1_CTRLDESCL1_9             (DCU1_BASE + DCU_CTRLDESCL1_9_OFFSET)
#define DCU1_CTRLDESCL2_1             (DCU1_BASE + DCU_CTRLDESCL2_1_OFFSET)
#define DCU1_CTRLDESCL2_2             (DCU1_BASE + DCU_CTRLDESCL2_2_OFFSET)
#define DCU1_CTRLDESCL2_3             (DCU1_BASE + DCU_CTRLDESCL2_3_OFFSET)
#define DCU1_CTRLDESCL2_4             (DCU1_BASE + DCU_CTRLDESCL2_4_OFFSET)
#define DCU1_CTRLDESCL2_5             (DCU1_BASE + DCU_CTRLDESCL2_5_OFFSET)
#define DCU1_CTRLDESCL2_6             (DCU1_BASE + DCU_CTRLDESCL2_6_OFFSET)
#define DCU1_CTRLDESCL2_7             (DCU1_BASE + DCU_CTRLDESCL2_7_OFFSET)
#define DCU1_CTRLDESCL2_8             (DCU1_BASE + DCU_CTRLDESCL2_8_OFFSET)
#define DCU1_CTRLDESCL2_9             (DCU1_BASE + DCU_CTRLDESCL2_9_OFFSET)
#define DCU1_CTRLDESCL3_1             (DCU1_BASE + DCU_CTRLDESCL3_1_OFFSET)
#define DCU1_CTRLDESCL3_2             (DCU1_BASE + DCU_CTRLDESCL3_2_OFFSET)
#define DCU1_CTRLDESCL3_3             (DCU1_BASE + DCU_CTRLDESCL3_3_OFFSET)
#define DCU1_CTRLDESCL3_4             (DCU1_BASE + DCU_CTRLDESCL3_4_OFFSET)
#define DCU1_CTRLDESCL3_5             (DCU1_BASE + DCU_CTRLDESCL3_5_OFFSET)
#define DCU1_CTRLDESCL3_6             (DCU1_BASE + DCU_CTRLDESCL3_6_OFFSET)
#define DCU1_CTRLDESCL3_7             (DCU1_BASE + DCU_CTRLDESCL3_7_OFFSET)
#define DCU1_CTRLDESCL3_8             (DCU1_BASE + DCU_CTRLDESCL3_8_OFFSET)
#define DCU1_CTRLDESCL3_9             (DCU1_BASE + DCU_CTRLDESCL3_9_OFFSET)
#define DCU1_CTRLDESCL4_1             (DCU1_BASE + DCU_CTRLDESCL4_1_OFFSET)
#define DCU1_CTRLDESCL4_2             (DCU1_BASE + DCU_CTRLDESCL4_2_OFFSET)
#define DCU1_CTRLDESCL4_3             (DCU1_BASE + DCU_CTRLDESCL4_3_OFFSET)
#define DCU1_CTRLDESCL4_4             (DCU1_BASE + DCU_CTRLDESCL4_4_OFFSET)
#define DCU1_CTRLDESCL4_5             (DCU1_BASE + DCU_CTRLDESCL4_5_OFFSET)
#define DCU1_CTRLDESCL4_6             (DCU1_BASE + DCU_CTRLDESCL4_6_OFFSET)
#define DCU1_CTRLDESCL4_7             (DCU1_BASE + DCU_CTRLDESCL4_7_OFFSET)
#define DCU1_CTRLDESCL4_8             (DCU1_BASE + DCU_CTRLDESCL4_8_OFFSET)
#define DCU1_CTRLDESCL4_9             (DCU1_BASE + DCU_CTRLDESCL4_9_OFFSET)
#define DCU1_CTRLDESCL5_1             (DCU1_BASE + DCU_CTRLDESCL5_1_OFFSET)
#define DCU1_CTRLDESCL5_2             (DCU1_BASE + DCU_CTRLDESCL5_2_OFFSET)
#define DCU1_CTRLDESCL5_3             (DCU1_BASE + DCU_CTRLDESCL5_3_OFFSET)
#define DCU1_CTRLDESCL5_4             (DCU1_BASE + DCU_CTRLDESCL5_4_OFFSET)
#define DCU1_CTRLDESCL5_5             (DCU1_BASE + DCU_CTRLDESCL5_5_OFFSET)
#define DCU1_CTRLDESCL5_6             (DCU1_BASE + DCU_CTRLDESCL5_6_OFFSET)
#define DCU1_CTRLDESCL5_7             (DCU1_BASE + DCU_CTRLDESCL5_7_OFFSET)
#define DCU1_CTRLDESCL5_8             (DCU1_BASE + DCU_CTRLDESCL5_8_OFFSET)
#define DCU1_CTRLDESCL5_9             (DCU1_BASE + DCU_CTRLDESCL5_9_OFFSET)
#define DCU1_CTRLDESCL6_1             (DCU1_BASE + DCU_CTRLDESCL6_1_OFFSET)
#define DCU1_CTRLDESCL6_2             (DCU1_BASE + DCU_CTRLDESCL6_2_OFFSET)
#define DCU1_CTRLDESCL6_3             (DCU1_BASE + DCU_CTRLDESCL6_3_OFFSET)
#define DCU1_CTRLDESCL6_4             (DCU1_BASE + DCU_CTRLDESCL6_4_OFFSET)
#define DCU1_CTRLDESCL6_5             (DCU1_BASE + DCU_CTRLDESCL6_5_OFFSET)
#define DCU1_CTRLDESCL6_6             (DCU1_BASE + DCU_CTRLDESCL6_6_OFFSET)
#define DCU1_CTRLDESCL6_7             (DCU1_BASE + DCU_CTRLDESCL6_7_OFFSET)
#define DCU1_CTRLDESCL6_8             (DCU1_BASE + DCU_CTRLDESCL6_8_OFFSET)
#define DCU1_CTRLDESCL6_9             (DCU1_BASE + DCU_CTRLDESCL6_9_OFFSET)
#define DCU1_CTRLDESCL7_1             (DCU1_BASE + DCU_CTRLDESCL7_1_OFFSET)
#define DCU1_CTRLDESCL7_2             (DCU1_BASE + DCU_CTRLDESCL7_2_OFFSET)
#define DCU1_CTRLDESCL7_3             (DCU1_BASE + DCU_CTRLDESCL7_3_OFFSET)
#define DCU1_CTRLDESCL7_4             (DCU1_BASE + DCU_CTRLDESCL7_4_OFFSET)
#define DCU1_CTRLDESCL7_5             (DCU1_BASE + DCU_CTRLDESCL7_5_OFFSET)
#define DCU1_CTRLDESCL7_6             (DCU1_BASE + DCU_CTRLDESCL7_6_OFFSET)
#define DCU1_CTRLDESCL7_7             (DCU1_BASE + DCU_CTRLDESCL7_7_OFFSET)
#define DCU1_CTRLDESCL7_8             (DCU1_BASE + DCU_CTRLDESCL7_8_OFFSET)
#define DCU1_CTRLDESCL7_9             (DCU1_BASE + DCU_CTRLDESCL7_9_OFFSET)
#define DCU1_CTRLDESCL8_1             (DCU1_BASE + DCU_CTRLDESCL8_1_OFFSET)
#define DCU1_CTRLDESCL8_2             (DCU1_BASE + DCU_CTRLDESCL8_2_OFFSET)
#define DCU1_CTRLDESCL8_3             (DCU1_BASE + DCU_CTRLDESCL8_3_OFFSET)
#define DCU1_CTRLDESCL8_4             (DCU1_BASE + DCU_CTRLDESCL8_4_OFFSET)
#define DCU1_CTRLDESCL8_5             (DCU1_BASE + DCU_CTRLDESCL8_5_OFFSET)
#define DCU1_CTRLDESCL8_6             (DCU1_BASE + DCU_CTRLDESCL8_6_OFFSET)
#define DCU1_CTRLDESCL8_7             (DCU1_BASE + DCU_CTRLDESCL8_7_OFFSET)
#define DCU1_CTRLDESCL8_8             (DCU1_BASE + DCU_CTRLDESCL8_8_OFFSET)
#define DCU1_CTRLDESCL8_9             (DCU1_BASE + DCU_CTRLDESCL8_9_OFFSET)
#define DCU1_CTRLDESCL9_1             (DCU1_BASE + DCU_CTRLDESCL9_1_OFFSET)
#define DCU1_CTRLDESCL9_2             (DCU1_BASE + DCU_CTRLDESCL9_2_OFFSET)
#define DCU1_CTRLDESCL9_3             (DCU1_BASE + DCU_CTRLDESCL9_3_OFFSET)
#define DCU1_CTRLDESCL9_4             (DCU1_BASE + DCU_CTRLDESCL9_4_OFFSET)
#define DCU1_CTRLDESCL9_5             (DCU1_BASE + DCU_CTRLDESCL9_5_OFFSET)
#define DCU1_CTRLDESCL9_6             (DCU1_BASE + DCU_CTRLDESCL9_6_OFFSET)
#define DCU1_CTRLDESCL9_7             (DCU1_BASE + DCU_CTRLDESCL9_7_OFFSET)
#define DCU1_CTRLDESCL9_8             (DCU1_BASE + DCU_CTRLDESCL9_8_OFFSET)
#define DCU1_CTRLDESCL9_9             (DCU1_BASE + DCU_CTRLDESCL9_9_OFFSET)
#define DCU1_CTRLDESCL10_1            (DCU1_BASE + DCU_CTRLDESCL10_1_OFFSET)
#define DCU1_CTRLDESCL10_2            (DCU1_BASE + DCU_CTRLDESCL10_2_OFFSET)
#define DCU1_CTRLDESCL10_3            (DCU1_BASE + DCU_CTRLDESCL10_3_OFFSET)
#define DCU1_CTRLDESCL10_4            (DCU1_BASE + DCU_CTRLDESCL10_4_OFFSET)
#define DCU1_CTRLDESCL10_5            (DCU1_BASE + DCU_CTRLDESCL10_5_OFFSET)
#define DCU1_CTRLDESCL10_6            (DCU1_BASE + DCU_CTRLDESCL10_6_OFFSET)
#define DCU1_CTRLDESCL10_7            (DCU1_BASE + DCU_CTRLDESCL10_7_OFFSET)
#define DCU1_CTRLDESCL10_8            (DCU1_BASE + DCU_CTRLDESCL10_8_OFFSET)
#define DCU1_CTRLDESCL10_9            (DCU1_BASE + DCU_CTRLDESCL10_9_OFFSET)
#define DCU1_CTRLDESCL11_1            (DCU1_BASE + DCU_CTRLDESCL11_1_OFFSET)
#define DCU1_CTRLDESCL11_2            (DCU1_BASE + DCU_CTRLDESCL11_2_OFFSET)
#define DCU1_CTRLDESCL11_3            (DCU1_BASE + DCU_CTRLDESCL11_3_OFFSET)
#define DCU1_CTRLDESCL11_4            (DCU1_BASE + DCU_CTRLDESCL11_4_OFFSET)
#define DCU1_CTRLDESCL11_5            (DCU1_BASE + DCU_CTRLDESCL11_5_OFFSET)
#define DCU1_CTRLDESCL11_6            (DCU1_BASE + DCU_CTRLDESCL11_6_OFFSET)
#define DCU1_CTRLDESCL11_7            (DCU1_BASE + DCU_CTRLDESCL11_7_OFFSET)
#define DCU1_CTRLDESCL11_8            (DCU1_BASE + DCU_CTRLDESCL11_8_OFFSET)
#define DCU1_CTRLDESCL11_9            (DCU1_BASE + DCU_CTRLDESCL11_9_OFFSET)
#define DCU1_CTRLDESCL12_1            (DCU1_BASE + DCU_CTRLDESCL12_1_OFFSET)
#define DCU1_CTRLDESCL12_2            (DCU1_BASE + DCU_CTRLDESCL12_2_OFFSET)
#define DCU1_CTRLDESCL12_3            (DCU1_BASE + DCU_CTRLDESCL12_3_OFFSET)
#define DCU1_CTRLDESCL12_4            (DCU1_BASE + DCU_CTRLDESCL12_4_OFFSET)
#define DCU1_CTRLDESCL12_5            (DCU1_BASE + DCU_CTRLDESCL12_5_OFFSET)
#define DCU1_CTRLDESCL12_6            (DCU1_BASE + DCU_CTRLDESCL12_6_OFFSET)
#define DCU1_CTRLDESCL12_7            (DCU1_BASE + DCU_CTRLDESCL12_7_OFFSET)
#define DCU1_CTRLDESCL12_8            (DCU1_BASE + DCU_CTRLDESCL12_8_OFFSET)
#define DCU1_CTRLDESCL12_9            (DCU1_BASE + DCU_CTRLDESCL12_9_OFFSET)
#define DCU1_CTRLDESCL13_1            (DCU1_BASE + DCU_CTRLDESCL13_1_OFFSET)
#define DCU1_CTRLDESCL13_2            (DCU1_BASE + DCU_CTRLDESCL13_2_OFFSET)
#define DCU1_CTRLDESCL13_3            (DCU1_BASE + DCU_CTRLDESCL13_3_OFFSET)
#define DCU1_CTRLDESCL13_4            (DCU1_BASE + DCU_CTRLDESCL13_4_OFFSET)
#define DCU1_CTRLDESCL13_5            (DCU1_BASE + DCU_CTRLDESCL13_5_OFFSET)
#define DCU1_CTRLDESCL13_6            (DCU1_BASE + DCU_CTRLDESCL13_6_OFFSET)
#define DCU1_CTRLDESCL13_7            (DCU1_BASE + DCU_CTRLDESCL13_7_OFFSET)
#define DCU1_CTRLDESCL13_8            (DCU1_BASE + DCU_CTRLDESCL13_8_OFFSET)
#define DCU1_CTRLDESCL13_9            (DCU1_BASE + DCU_CTRLDESCL13_9_OFFSET)
#define DCU1_CTRLDESCL14_1            (DCU1_BASE + DCU_CTRLDESCL14_1_OFFSET)
#define DCU1_CTRLDESCL14_2            (DCU1_BASE + DCU_CTRLDESCL14_2_OFFSET)
#define DCU1_CTRLDESCL14_3            (DCU1_BASE + DCU_CTRLDESCL14_3_OFFSET)
#define DCU1_CTRLDESCL14_4            (DCU1_BASE + DCU_CTRLDESCL14_4_OFFSET)
#define DCU1_CTRLDESCL14_5            (DCU1_BASE + DCU_CTRLDESCL14_5_OFFSET)
#define DCU1_CTRLDESCL14_6            (DCU1_BASE + DCU_CTRLDESCL14_6_OFFSET)
#define DCU1_CTRLDESCL14_7            (DCU1_BASE + DCU_CTRLDESCL14_7_OFFSET)
#define DCU1_CTRLDESCL14_8            (DCU1_BASE + DCU_CTRLDESCL14_8_OFFSET)
#define DCU1_CTRLDESCL14_9            (DCU1_BASE + DCU_CTRLDESCL14_9_OFFSET)
#define DCU1_CTRLDESCL15_1            (DCU1_BASE + DCU_CTRLDESCL15_1_OFFSET)
#define DCU1_CTRLDESCL15_2            (DCU1_BASE + DCU_CTRLDESCL15_2_OFFSET)
#define DCU1_CTRLDESCL15_3            (DCU1_BASE + DCU_CTRLDESCL15_3_OFFSET)
#define DCU1_CTRLDESCL15_4            (DCU1_BASE + DCU_CTRLDESCL15_4_OFFSET)
#define DCU1_CTRLDESCL15_5            (DCU1_BASE + DCU_CTRLDESCL15_5_OFFSET)
#define DCU1_CTRLDESCL15_6            (DCU1_BASE + DCU_CTRLDESCL15_6_OFFSET)
#define DCU1_CTRLDESCL15_7            (DCU1_BASE + DCU_CTRLDESCL15_7_OFFSET)
#define DCU1_CTRLDESCL15_8            (DCU1_BASE + DCU_CTRLDESCL15_8_OFFSET)
#define DCU1_CTRLDESCL15_9            (DCU1_BASE + DCU_CTRLDESCL15_9_OFFSET)
#define DCU1_CTRLDESCL16_1            (DCU1_BASE + DCU_CTRLDESCL16_1_OFFSET)
#define DCU1_CTRLDESCL16_2            (DCU1_BASE + DCU_CTRLDESCL16_2_OFFSET)
#define DCU1_CTRLDESCL16_3            (DCU1_BASE + DCU_CTRLDESCL16_3_OFFSET)
#define DCU1_CTRLDESCL16_4            (DCU1_BASE + DCU_CTRLDESCL16_4_OFFSET)
#define DCU1_CTRLDESCL16_5            (DCU1_BASE + DCU_CTRLDESCL16_5_OFFSET)
#define DCU1_CTRLDESCL16_6            (DCU1_BASE + DCU_CTRLDESCL16_6_OFFSET)
#define DCU1_CTRLDESCL16_7            (DCU1_BASE + DCU_CTRLDESCL16_7_OFFSET)
#define DCU1_CTRLDESCL16_8            (DCU1_BASE + DCU_CTRLDESCL16_8_OFFSET)
#define DCU1_CTRLDESCL16_9            (DCU1_BASE + DCU_CTRLDESCL16_9_OFFSET)
#define DCU1_CTRLDESCL17_1            (DCU1_BASE + DCU_CTRLDESCL17_1_OFFSET)
#define DCU1_CTRLDESCL17_2            (DCU1_BASE + DCU_CTRLDESCL17_2_OFFSET)
#define DCU1_CTRLDESCL17_3            (DCU1_BASE + DCU_CTRLDESCL17_3_OFFSET)
#define DCU1_CTRLDESCL17_4            (DCU1_BASE + DCU_CTRLDESCL17_4_OFFSET)
#define DCU1_CTRLDESCL17_5            (DCU1_BASE + DCU_CTRLDESCL17_5_OFFSET)
#define DCU1_CTRLDESCL17_6            (DCU1_BASE + DCU_CTRLDESCL17_6_OFFSET)
#define DCU1_CTRLDESCL17_7            (DCU1_BASE + DCU_CTRLDESCL17_7_OFFSET)
#define DCU1_CTRLDESCL17_8            (DCU1_BASE + DCU_CTRLDESCL17_8_OFFSET)
#define DCU1_CTRLDESCL17_9            (DCU1_BASE + DCU_CTRLDESCL17_9_OFFSET)
#define DCU1_CTRLDESCL18_1            (DCU1_BASE + DCU_CTRLDESCL18_1_OFFSET)
#define DCU1_CTRLDESCL18_2            (DCU1_BASE + DCU_CTRLDESCL18_2_OFFSET)
#define DCU1_CTRLDESCL18_3            (DCU1_BASE + DCU_CTRLDESCL18_3_OFFSET)
#define DCU1_CTRLDESCL18_4            (DCU1_BASE + DCU_CTRLDESCL18_4_OFFSET)
#define DCU1_CTRLDESCL18_5            (DCU1_BASE + DCU_CTRLDESCL18_5_OFFSET)
#define DCU1_CTRLDESCL18_6            (DCU1_BASE + DCU_CTRLDESCL18_6_OFFSET)
#define DCU1_CTRLDESCL18_7            (DCU1_BASE + DCU_CTRLDESCL18_7_OFFSET)
#define DCU1_CTRLDESCL18_8            (DCU1_BASE + DCU_CTRLDESCL18_8_OFFSET)
#define DCU1_CTRLDESCL18_9            (DCU1_BASE + DCU_CTRLDESCL18_9_OFFSET)
#define DCU1_CTRLDESCL19_1            (DCU1_BASE + DCU_CTRLDESCL19_1_OFFSET)
#define DCU1_CTRLDESCL19_2            (DCU1_BASE + DCU_CTRLDESCL19_2_OFFSET)
#define DCU1_CTRLDESCL19_3            (DCU1_BASE + DCU_CTRLDESCL19_3_OFFSET)
#define DCU1_CTRLDESCL19_4            (DCU1_BASE + DCU_CTRLDESCL19_4_OFFSET)
#define DCU1_CTRLDESCL19_5            (DCU1_BASE + DCU_CTRLDESCL19_5_OFFSET)
#define DCU1_CTRLDESCL19_6            (DCU1_BASE + DCU_CTRLDESCL19_6_OFFSET)
#define DCU1_CTRLDESCL19_7            (DCU1_BASE + DCU_CTRLDESCL19_7_OFFSET)
#define DCU1_CTRLDESCL19_8            (DCU1_BASE + DCU_CTRLDESCL19_8_OFFSET)
#define DCU1_CTRLDESCL19_9            (DCU1_BASE + DCU_CTRLDESCL19_9_OFFSET)
#define DCU1_CTRLDESCL20_1            (DCU1_BASE + DCU_CTRLDESCL20_1_OFFSET)
#define DCU1_CTRLDESCL20_2            (DCU1_BASE + DCU_CTRLDESCL20_2_OFFSET)
#define DCU1_CTRLDESCL20_3            (DCU1_BASE + DCU_CTRLDESCL20_3_OFFSET)
#define DCU1_CTRLDESCL20_4            (DCU1_BASE + DCU_CTRLDESCL20_4_OFFSET)
#define DCU1_CTRLDESCL20_5            (DCU1_BASE + DCU_CTRLDESCL20_5_OFFSET)
#define DCU1_CTRLDESCL20_6            (DCU1_BASE + DCU_CTRLDESCL20_6_OFFSET)
#define DCU1_CTRLDESCL20_7            (DCU1_BASE + DCU_CTRLDESCL20_7_OFFSET)
#define DCU1_CTRLDESCL20_8            (DCU1_BASE + DCU_CTRLDESCL20_8_OFFSET)
#define DCU1_CTRLDESCL20_9            (DCU1_BASE + DCU_CTRLDESCL20_9_OFFSET)
#define DCU1_CTRLDESCL21_1            (DCU1_BASE + DCU_CTRLDESCL21_1_OFFSET)
#define DCU1_CTRLDESCL21_2            (DCU1_BASE + DCU_CTRLDESCL21_2_OFFSET)
#define DCU1_CTRLDESCL21_3            (DCU1_BASE + DCU_CTRLDESCL21_3_OFFSET)
#define DCU1_CTRLDESCL21_4            (DCU1_BASE + DCU_CTRLDESCL21_4_OFFSET)
#define DCU1_CTRLDESCL21_5            (DCU1_BASE + DCU_CTRLDESCL21_5_OFFSET)
#define DCU1_CTRLDESCL21_6            (DCU1_BASE + DCU_CTRLDESCL21_6_OFFSET)
#define DCU1_CTRLDESCL21_7            (DCU1_BASE + DCU_CTRLDESCL21_7_OFFSET)
#define DCU1_CTRLDESCL21_8            (DCU1_BASE + DCU_CTRLDESCL21_8_OFFSET)
#define DCU1_CTRLDESCL21_9            (DCU1_BASE + DCU_CTRLDESCL21_9_OFFSET)
#define DCU1_CTRLDESCL22_1            (DCU1_BASE + DCU_CTRLDESCL22_1_OFFSET)
#define DCU1_CTRLDESCL22_2            (DCU1_BASE + DCU_CTRLDESCL22_2_OFFSET)
#define DCU1_CTRLDESCL22_3            (DCU1_BASE + DCU_CTRLDESCL22_3_OFFSET)
#define DCU1_CTRLDESCL22_4            (DCU1_BASE + DCU_CTRLDESCL22_4_OFFSET)
#define DCU1_CTRLDESCL22_5            (DCU1_BASE + DCU_CTRLDESCL22_5_OFFSET)
#define DCU1_CTRLDESCL22_6            (DCU1_BASE + DCU_CTRLDESCL22_6_OFFSET)
#define DCU1_CTRLDESCL22_7            (DCU1_BASE + DCU_CTRLDESCL22_7_OFFSET)
#define DCU1_CTRLDESCL22_8            (DCU1_BASE + DCU_CTRLDESCL22_8_OFFSET)
#define DCU1_CTRLDESCL22_9            (DCU1_BASE + DCU_CTRLDESCL22_9_OFFSET)
#define DCU1_CTRLDESCL23_1            (DCU1_BASE + DCU_CTRLDESCL23_1_OFFSET)
#define DCU1_CTRLDESCL23_2            (DCU1_BASE + DCU_CTRLDESCL23_2_OFFSET)
#define DCU1_CTRLDESCL23_3            (DCU1_BASE + DCU_CTRLDESCL23_3_OFFSET)
#define DCU1_CTRLDESCL23_4            (DCU1_BASE + DCU_CTRLDESCL23_4_OFFSET)
#define DCU1_CTRLDESCL23_5            (DCU1_BASE + DCU_CTRLDESCL23_5_OFFSET)
#define DCU1_CTRLDESCL23_6            (DCU1_BASE + DCU_CTRLDESCL23_6_OFFSET)
#define DCU1_CTRLDESCL23_7            (DCU1_BASE + DCU_CTRLDESCL23_7_OFFSET)
#define DCU1_CTRLDESCL23_8            (DCU1_BASE + DCU_CTRLDESCL23_8_OFFSET)
#define DCU1_CTRLDESCL23_9            (DCU1_BASE + DCU_CTRLDESCL23_9_OFFSET)
#define DCU1_CTRLDESCL24_1            (DCU1_BASE + DCU_CTRLDESCL24_1_OFFSET)
#define DCU1_CTRLDESCL24_2            (DCU1_BASE + DCU_CTRLDESCL24_2_OFFSET)
#define DCU1_CTRLDESCL24_3            (DCU1_BASE + DCU_CTRLDESCL24_3_OFFSET)
#define DCU1_CTRLDESCL24_4            (DCU1_BASE + DCU_CTRLDESCL24_4_OFFSET)
#define DCU1_CTRLDESCL24_5            (DCU1_BASE + DCU_CTRLDESCL24_5_OFFSET)
#define DCU1_CTRLDESCL24_6            (DCU1_BASE + DCU_CTRLDESCL24_6_OFFSET)
#define DCU1_CTRLDESCL24_7            (DCU1_BASE + DCU_CTRLDESCL24_7_OFFSET)
#define DCU1_CTRLDESCL24_8            (DCU1_BASE + DCU_CTRLDESCL24_8_OFFSET)
#define DCU1_CTRLDESCL24_9            (DCU1_BASE + DCU_CTRLDESCL24_9_OFFSET)
#define DCU1_CTRLDESCL25_1            (DCU1_BASE + DCU_CTRLDESCL25_1_OFFSET)
#define DCU1_CTRLDESCL25_2            (DCU1_BASE + DCU_CTRLDESCL25_2_OFFSET)
#define DCU1_CTRLDESCL25_3            (DCU1_BASE + DCU_CTRLDESCL25_3_OFFSET)
#define DCU1_CTRLDESCL25_4            (DCU1_BASE + DCU_CTRLDESCL25_4_OFFSET)
#define DCU1_CTRLDESCL25_5            (DCU1_BASE + DCU_CTRLDESCL25_5_OFFSET)
#define DCU1_CTRLDESCL25_6            (DCU1_BASE + DCU_CTRLDESCL25_6_OFFSET)
#define DCU1_CTRLDESCL25_7            (DCU1_BASE + DCU_CTRLDESCL25_7_OFFSET)
#define DCU1_CTRLDESCL25_8            (DCU1_BASE + DCU_CTRLDESCL25_8_OFFSET)
#define DCU1_CTRLDESCL25_9            (DCU1_BASE + DCU_CTRLDESCL25_9_OFFSET)
#define DCU1_CTRLDESCL26_1            (DCU1_BASE + DCU_CTRLDESCL26_1_OFFSET)
#define DCU1_CTRLDESCL26_2            (DCU1_BASE + DCU_CTRLDESCL26_2_OFFSET)
#define DCU1_CTRLDESCL26_3            (DCU1_BASE + DCU_CTRLDESCL26_3_OFFSET)
#define DCU1_CTRLDESCL26_4            (DCU1_BASE + DCU_CTRLDESCL26_4_OFFSET)
#define DCU1_CTRLDESCL26_5            (DCU1_BASE + DCU_CTRLDESCL26_5_OFFSET)
#define DCU1_CTRLDESCL26_6            (DCU1_BASE + DCU_CTRLDESCL26_6_OFFSET)
#define DCU1_CTRLDESCL26_7            (DCU1_BASE + DCU_CTRLDESCL26_7_OFFSET)
#define DCU1_CTRLDESCL26_8            (DCU1_BASE + DCU_CTRLDESCL26_8_OFFSET)
#define DCU1_CTRLDESCL26_9            (DCU1_BASE + DCU_CTRLDESCL26_9_OFFSET)
#define DCU1_CTRLDESCL27_1            (DCU1_BASE + DCU_CTRLDESCL27_1_OFFSET)
#define DCU1_CTRLDESCL27_2            (DCU1_BASE + DCU_CTRLDESCL27_2_OFFSET)
#define DCU1_CTRLDESCL27_3            (DCU1_BASE + DCU_CTRLDESCL27_3_OFFSET)
#define DCU1_CTRLDESCL27_4            (DCU1_BASE + DCU_CTRLDESCL27_4_OFFSET)
#define DCU1_CTRLDESCL27_5            (DCU1_BASE + DCU_CTRLDESCL27_5_OFFSET)
#define DCU1_CTRLDESCL27_6            (DCU1_BASE + DCU_CTRLDESCL27_6_OFFSET)
#define DCU1_CTRLDESCL27_7            (DCU1_BASE + DCU_CTRLDESCL27_7_OFFSET)
#define DCU1_CTRLDESCL27_8            (DCU1_BASE + DCU_CTRLDESCL27_8_OFFSET)
#define DCU1_CTRLDESCL27_9            (DCU1_BASE + DCU_CTRLDESCL27_9_OFFSET)
#define DCU1_CTRLDESCL28_1            (DCU1_BASE + DCU_CTRLDESCL28_1_OFFSET)
#define DCU1_CTRLDESCL28_2            (DCU1_BASE + DCU_CTRLDESCL28_2_OFFSET)
#define DCU1_CTRLDESCL28_3            (DCU1_BASE + DCU_CTRLDESCL28_3_OFFSET)
#define DCU1_CTRLDESCL28_4            (DCU1_BASE + DCU_CTRLDESCL28_4_OFFSET)
#define DCU1_CTRLDESCL28_5            (DCU1_BASE + DCU_CTRLDESCL28_5_OFFSET)
#define DCU1_CTRLDESCL28_6            (DCU1_BASE + DCU_CTRLDESCL28_6_OFFSET)
#define DCU1_CTRLDESCL28_7            (DCU1_BASE + DCU_CTRLDESCL28_7_OFFSET)
#define DCU1_CTRLDESCL28_8            (DCU1_BASE + DCU_CTRLDESCL28_8_OFFSET)
#define DCU1_CTRLDESCL28_9            (DCU1_BASE + DCU_CTRLDESCL28_9_OFFSET)
#define DCU1_CTRLDESCL29_1            (DCU1_BASE + DCU_CTRLDESCL29_1_OFFSET)
#define DCU1_CTRLDESCL29_2            (DCU1_BASE + DCU_CTRLDESCL29_2_OFFSET)
#define DCU1_CTRLDESCL29_3            (DCU1_BASE + DCU_CTRLDESCL29_3_OFFSET)
#define DCU1_CTRLDESCL29_4            (DCU1_BASE + DCU_CTRLDESCL29_4_OFFSET)
#define DCU1_CTRLDESCL29_5            (DCU1_BASE + DCU_CTRLDESCL29_5_OFFSET)
#define DCU1_CTRLDESCL29_6            (DCU1_BASE + DCU_CTRLDESCL29_6_OFFSET)
#define DCU1_CTRLDESCL29_7            (DCU1_BASE + DCU_CTRLDESCL29_7_OFFSET)
#define DCU1_CTRLDESCL29_8            (DCU1_BASE + DCU_CTRLDESCL29_8_OFFSET)
#define DCU1_CTRLDESCL29_9            (DCU1_BASE + DCU_CTRLDESCL29_9_OFFSET)
#define DCU1_CTRLDESCL30_1            (DCU1_BASE + DCU_CTRLDESCL30_1_OFFSET)
#define DCU1_CTRLDESCL30_2            (DCU1_BASE + DCU_CTRLDESCL30_2_OFFSET)
#define DCU1_CTRLDESCL30_3            (DCU1_BASE + DCU_CTRLDESCL30_3_OFFSET)
#define DCU1_CTRLDESCL30_4            (DCU1_BASE + DCU_CTRLDESCL30_4_OFFSET)
#define DCU1_CTRLDESCL30_5            (DCU1_BASE + DCU_CTRLDESCL30_5_OFFSET)
#define DCU1_CTRLDESCL30_6            (DCU1_BASE + DCU_CTRLDESCL30_6_OFFSET)
#define DCU1_CTRLDESCL30_7            (DCU1_BASE + DCU_CTRLDESCL30_7_OFFSET)
#define DCU1_CTRLDESCL30_8            (DCU1_BASE + DCU_CTRLDESCL30_8_OFFSET)
#define DCU1_CTRLDESCL30_9            (DCU1_BASE + DCU_CTRLDESCL30_9_OFFSET)
#define DCU1_CTRLDESCL31_1            (DCU1_BASE + DCU_CTRLDESCL31_1_OFFSET)
#define DCU1_CTRLDESCL31_2            (DCU1_BASE + DCU_CTRLDESCL31_2_OFFSET)
#define DCU1_CTRLDESCL31_3            (DCU1_BASE + DCU_CTRLDESCL31_3_OFFSET)
#define DCU1_CTRLDESCL31_4            (DCU1_BASE + DCU_CTRLDESCL31_4_OFFSET)
#define DCU1_CTRLDESCL31_5            (DCU1_BASE + DCU_CTRLDESCL31_5_OFFSET)
#define DCU1_CTRLDESCL31_6            (DCU1_BASE + DCU_CTRLDESCL31_6_OFFSET)
#define DCU1_CTRLDESCL31_7            (DCU1_BASE + DCU_CTRLDESCL31_7_OFFSET)
#define DCU1_CTRLDESCL31_8            (DCU1_BASE + DCU_CTRLDESCL31_8_OFFSET)
#define DCU1_CTRLDESCL31_9            (DCU1_BASE + DCU_CTRLDESCL31_9_OFFSET)
#define DCU1_CTRLDESCL32_1            (DCU1_BASE + DCU_CTRLDESCL32_1_OFFSET)
#define DCU1_CTRLDESCL32_2            (DCU1_BASE + DCU_CTRLDESCL32_2_OFFSET)
#define DCU1_CTRLDESCL32_3            (DCU1_BASE + DCU_CTRLDESCL32_3_OFFSET)
#define DCU1_CTRLDESCL32_4            (DCU1_BASE + DCU_CTRLDESCL32_4_OFFSET)
#define DCU1_CTRLDESCL32_5            (DCU1_BASE + DCU_CTRLDESCL32_5_OFFSET)
#define DCU1_CTRLDESCL32_6            (DCU1_BASE + DCU_CTRLDESCL32_6_OFFSET)
#define DCU1_CTRLDESCL32_7            (DCU1_BASE + DCU_CTRLDESCL32_7_OFFSET)
#define DCU1_CTRLDESCL32_8            (DCU1_BASE + DCU_CTRLDESCL32_8_OFFSET)
#define DCU1_CTRLDESCL32_9            (DCU1_BASE + DCU_CTRLDESCL32_9_OFFSET)
#define DCU1_CTRLDESCL33_1            (DCU1_BASE + DCU_CTRLDESCL33_1_OFFSET)
#define DCU1_CTRLDESCL33_2            (DCU1_BASE + DCU_CTRLDESCL33_2_OFFSET)
#define DCU1_CTRLDESCL33_3            (DCU1_BASE + DCU_CTRLDESCL33_3_OFFSET)
#define DCU1_CTRLDESCL33_4            (DCU1_BASE + DCU_CTRLDESCL33_4_OFFSET)
#define DCU1_CTRLDESCL33_5            (DCU1_BASE + DCU_CTRLDESCL33_5_OFFSET)
#define DCU1_CTRLDESCL33_6            (DCU1_BASE + DCU_CTRLDESCL33_6_OFFSET)
#define DCU1_CTRLDESCL33_7            (DCU1_BASE + DCU_CTRLDESCL33_7_OFFSET)
#define DCU1_CTRLDESCL33_8            (DCU1_BASE + DCU_CTRLDESCL33_8_OFFSET)
#define DCU1_CTRLDESCL33_9            (DCU1_BASE + DCU_CTRLDESCL33_9_OFFSET)
#define DCU1_CTRLDESCL34_1            (DCU1_BASE + DCU_CTRLDESCL34_1_OFFSET)
#define DCU1_CTRLDESCL34_2            (DCU1_BASE + DCU_CTRLDESCL34_2_OFFSET)
#define DCU1_CTRLDESCL34_3            (DCU1_BASE + DCU_CTRLDESCL34_3_OFFSET)
#define DCU1_CTRLDESCL34_4            (DCU1_BASE + DCU_CTRLDESCL34_4_OFFSET)
#define DCU1_CTRLDESCL34_5            (DCU1_BASE + DCU_CTRLDESCL34_5_OFFSET)
#define DCU1_CTRLDESCL34_6            (DCU1_BASE + DCU_CTRLDESCL34_6_OFFSET)
#define DCU1_CTRLDESCL34_7            (DCU1_BASE + DCU_CTRLDESCL34_7_OFFSET)
#define DCU1_CTRLDESCL34_8            (DCU1_BASE + DCU_CTRLDESCL34_8_OFFSET)
#define DCU1_CTRLDESCL34_9            (DCU1_BASE + DCU_CTRLDESCL34_9_OFFSET)
#define DCU1_CTRLDESCL35_1            (DCU1_BASE + DCU_CTRLDESCL35_1_OFFSET)
#define DCU1_CTRLDESCL35_2            (DCU1_BASE + DCU_CTRLDESCL35_2_OFFSET)
#define DCU1_CTRLDESCL35_3            (DCU1_BASE + DCU_CTRLDESCL35_3_OFFSET)
#define DCU1_CTRLDESCL35_4            (DCU1_BASE + DCU_CTRLDESCL35_4_OFFSET)
#define DCU1_CTRLDESCL35_5            (DCU1_BASE + DCU_CTRLDESCL35_5_OFFSET)
#define DCU1_CTRLDESCL35_6            (DCU1_BASE + DCU_CTRLDESCL35_6_OFFSET)
#define DCU1_CTRLDESCL35_7            (DCU1_BASE + DCU_CTRLDESCL35_7_OFFSET)
#define DCU1_CTRLDESCL35_8            (DCU1_BASE + DCU_CTRLDESCL35_8_OFFSET)
#define DCU1_CTRLDESCL35_9            (DCU1_BASE + DCU_CTRLDESCL35_9_OFFSET)
#define DCU1_CTRLDESCL36_1            (DCU1_BASE + DCU_CTRLDESCL36_1_OFFSET)
#define DCU1_CTRLDESCL36_2            (DCU1_BASE + DCU_CTRLDESCL36_2_OFFSET)
#define DCU1_CTRLDESCL36_3            (DCU1_BASE + DCU_CTRLDESCL36_3_OFFSET)
#define DCU1_CTRLDESCL36_4            (DCU1_BASE + DCU_CTRLDESCL36_4_OFFSET)
#define DCU1_CTRLDESCL36_5            (DCU1_BASE + DCU_CTRLDESCL36_5_OFFSET)
#define DCU1_CTRLDESCL36_6            (DCU1_BASE + DCU_CTRLDESCL36_6_OFFSET)
#define DCU1_CTRLDESCL36_7            (DCU1_BASE + DCU_CTRLDESCL36_7_OFFSET)
#define DCU1_CTRLDESCL36_8            (DCU1_BASE + DCU_CTRLDESCL36_8_OFFSET)
#define DCU1_CTRLDESCL36_9            (DCU1_BASE + DCU_CTRLDESCL36_9_OFFSET)
#define DCU1_CTRLDESCL37_1            (DCU1_BASE + DCU_CTRLDESCL37_1_OFFSET)
#define DCU1_CTRLDESCL37_2            (DCU1_BASE + DCU_CTRLDESCL37_2_OFFSET)
#define DCU1_CTRLDESCL37_3            (DCU1_BASE + DCU_CTRLDESCL37_3_OFFSET)
#define DCU1_CTRLDESCL37_4            (DCU1_BASE + DCU_CTRLDESCL37_4_OFFSET)
#define DCU1_CTRLDESCL37_5            (DCU1_BASE + DCU_CTRLDESCL37_5_OFFSET)
#define DCU1_CTRLDESCL37_6            (DCU1_BASE + DCU_CTRLDESCL37_6_OFFSET)
#define DCU1_CTRLDESCL37_7            (DCU1_BASE + DCU_CTRLDESCL37_7_OFFSET)
#define DCU1_CTRLDESCL37_8            (DCU1_BASE + DCU_CTRLDESCL37_8_OFFSET)
#define DCU1_CTRLDESCL37_9            (DCU1_BASE + DCU_CTRLDESCL37_9_OFFSET)
#define DCU1_CTRLDESCL38_1            (DCU1_BASE + DCU_CTRLDESCL38_1_OFFSET)
#define DCU1_CTRLDESCL38_2            (DCU1_BASE + DCU_CTRLDESCL38_2_OFFSET)
#define DCU1_CTRLDESCL38_3            (DCU1_BASE + DCU_CTRLDESCL38_3_OFFSET)
#define DCU1_CTRLDESCL38_4            (DCU1_BASE + DCU_CTRLDESCL38_4_OFFSET)
#define DCU1_CTRLDESCL38_5            (DCU1_BASE + DCU_CTRLDESCL38_5_OFFSET)
#define DCU1_CTRLDESCL38_6            (DCU1_BASE + DCU_CTRLDESCL38_6_OFFSET)
#define DCU1_CTRLDESCL38_7            (DCU1_BASE + DCU_CTRLDESCL38_7_OFFSET)
#define DCU1_CTRLDESCL38_8            (DCU1_BASE + DCU_CTRLDESCL38_8_OFFSET)
#define DCU1_CTRLDESCL38_9            (DCU1_BASE + DCU_CTRLDESCL38_9_OFFSET)
#define DCU1_CTRLDESCL39_1            (DCU1_BASE + DCU_CTRLDESCL39_1_OFFSET)
#define DCU1_CTRLDESCL39_2            (DCU1_BASE + DCU_CTRLDESCL39_2_OFFSET)
#define DCU1_CTRLDESCL39_3            (DCU1_BASE + DCU_CTRLDESCL39_3_OFFSET)
#define DCU1_CTRLDESCL39_4            (DCU1_BASE + DCU_CTRLDESCL39_4_OFFSET)
#define DCU1_CTRLDESCL39_5            (DCU1_BASE + DCU_CTRLDESCL39_5_OFFSET)
#define DCU1_CTRLDESCL39_6            (DCU1_BASE + DCU_CTRLDESCL39_6_OFFSET)
#define DCU1_CTRLDESCL39_7            (DCU1_BASE + DCU_CTRLDESCL39_7_OFFSET)
#define DCU1_CTRLDESCL39_8            (DCU1_BASE + DCU_CTRLDESCL39_8_OFFSET)
#define DCU1_CTRLDESCL39_9            (DCU1_BASE + DCU_CTRLDESCL39_9_OFFSET)
#define DCU1_CTRLDESCL40_1            (DCU1_BASE + DCU_CTRLDESCL40_1_OFFSET)
#define DCU1_CTRLDESCL40_2            (DCU1_BASE + DCU_CTRLDESCL40_2_OFFSET)
#define DCU1_CTRLDESCL40_3            (DCU1_BASE + DCU_CTRLDESCL40_3_OFFSET)
#define DCU1_CTRLDESCL40_4            (DCU1_BASE + DCU_CTRLDESCL40_4_OFFSET)
#define DCU1_CTRLDESCL40_5            (DCU1_BASE + DCU_CTRLDESCL40_5_OFFSET)
#define DCU1_CTRLDESCL40_6            (DCU1_BASE + DCU_CTRLDESCL40_6_OFFSET)
#define DCU1_CTRLDESCL40_7            (DCU1_BASE + DCU_CTRLDESCL40_7_OFFSET)
#define DCU1_CTRLDESCL40_8            (DCU1_BASE + DCU_CTRLDESCL40_8_OFFSET)
#define DCU1_CTRLDESCL40_9            (DCU1_BASE + DCU_CTRLDESCL40_9_OFFSET)
#define DCU1_CTRLDESCL41_1            (DCU1_BASE + DCU_CTRLDESCL41_1_OFFSET)
#define DCU1_CTRLDESCL41_2            (DCU1_BASE + DCU_CTRLDESCL41_2_OFFSET)
#define DCU1_CTRLDESCL41_3            (DCU1_BASE + DCU_CTRLDESCL41_3_OFFSET)
#define DCU1_CTRLDESCL41_4            (DCU1_BASE + DCU_CTRLDESCL41_4_OFFSET)
#define DCU1_CTRLDESCL41_5            (DCU1_BASE + DCU_CTRLDESCL41_5_OFFSET)
#define DCU1_CTRLDESCL41_6            (DCU1_BASE + DCU_CTRLDESCL41_6_OFFSET)
#define DCU1_CTRLDESCL41_7            (DCU1_BASE + DCU_CTRLDESCL41_7_OFFSET)
#define DCU1_CTRLDESCL41_8            (DCU1_BASE + DCU_CTRLDESCL41_8_OFFSET)
#define DCU1_CTRLDESCL41_9            (DCU1_BASE + DCU_CTRLDESCL41_9_OFFSET)
#define DCU1_CTRLDESCL42_1            (DCU1_BASE + DCU_CTRLDESCL42_1_OFFSET)
#define DCU1_CTRLDESCL42_2            (DCU1_BASE + DCU_CTRLDESCL42_2_OFFSET)
#define DCU1_CTRLDESCL42_3            (DCU1_BASE + DCU_CTRLDESCL42_3_OFFSET)
#define DCU1_CTRLDESCL42_4            (DCU1_BASE + DCU_CTRLDESCL42_4_OFFSET)
#define DCU1_CTRLDESCL42_5            (DCU1_BASE + DCU_CTRLDESCL42_5_OFFSET)
#define DCU1_CTRLDESCL42_6            (DCU1_BASE + DCU_CTRLDESCL42_6_OFFSET)
#define DCU1_CTRLDESCL42_7            (DCU1_BASE + DCU_CTRLDESCL42_7_OFFSET)
#define DCU1_CTRLDESCL42_8            (DCU1_BASE + DCU_CTRLDESCL42_8_OFFSET)
#define DCU1_CTRLDESCL42_9            (DCU1_BASE + DCU_CTRLDESCL42_9_OFFSET)
#define DCU1_CTRLDESCL43_1            (DCU1_BASE + DCU_CTRLDESCL43_1_OFFSET)
#define DCU1_CTRLDESCL43_2            (DCU1_BASE + DCU_CTRLDESCL43_2_OFFSET)
#define DCU1_CTRLDESCL43_3            (DCU1_BASE + DCU_CTRLDESCL43_3_OFFSET)
#define DCU1_CTRLDESCL43_4            (DCU1_BASE + DCU_CTRLDESCL43_4_OFFSET)
#define DCU1_CTRLDESCL43_5            (DCU1_BASE + DCU_CTRLDESCL43_5_OFFSET)
#define DCU1_CTRLDESCL43_6            (DCU1_BASE + DCU_CTRLDESCL43_6_OFFSET)
#define DCU1_CTRLDESCL43_7            (DCU1_BASE + DCU_CTRLDESCL43_7_OFFSET)
#define DCU1_CTRLDESCL43_8            (DCU1_BASE + DCU_CTRLDESCL43_8_OFFSET)
#define DCU1_CTRLDESCL43_9            (DCU1_BASE + DCU_CTRLDESCL43_9_OFFSET)
#define DCU1_CTRLDESCL44_1            (DCU1_BASE + DCU_CTRLDESCL44_1_OFFSET)
#define DCU1_CTRLDESCL44_2            (DCU1_BASE + DCU_CTRLDESCL44_2_OFFSET)
#define DCU1_CTRLDESCL44_3            (DCU1_BASE + DCU_CTRLDESCL44_3_OFFSET)
#define DCU1_CTRLDESCL44_4            (DCU1_BASE + DCU_CTRLDESCL44_4_OFFSET)
#define DCU1_CTRLDESCL44_5            (DCU1_BASE + DCU_CTRLDESCL44_5_OFFSET)
#define DCU1_CTRLDESCL44_6            (DCU1_BASE + DCU_CTRLDESCL44_6_OFFSET)
#define DCU1_CTRLDESCL44_7            (DCU1_BASE + DCU_CTRLDESCL44_7_OFFSET)
#define DCU1_CTRLDESCL44_8            (DCU1_BASE + DCU_CTRLDESCL44_8_OFFSET)
#define DCU1_CTRLDESCL44_9            (DCU1_BASE + DCU_CTRLDESCL44_9_OFFSET)
#define DCU1_CTRLDESCL45_1            (DCU1_BASE + DCU_CTRLDESCL45_1_OFFSET)
#define DCU1_CTRLDESCL45_2            (DCU1_BASE + DCU_CTRLDESCL45_2_OFFSET)
#define DCU1_CTRLDESCL45_3            (DCU1_BASE + DCU_CTRLDESCL45_3_OFFSET)
#define DCU1_CTRLDESCL45_4            (DCU1_BASE + DCU_CTRLDESCL45_4_OFFSET)
#define DCU1_CTRLDESCL45_5            (DCU1_BASE + DCU_CTRLDESCL45_5_OFFSET)
#define DCU1_CTRLDESCL45_6            (DCU1_BASE + DCU_CTRLDESCL45_6_OFFSET)
#define DCU1_CTRLDESCL45_7            (DCU1_BASE + DCU_CTRLDESCL45_7_OFFSET)
#define DCU1_CTRLDESCL45_8            (DCU1_BASE + DCU_CTRLDESCL45_8_OFFSET)
#define DCU1_CTRLDESCL45_9            (DCU1_BASE + DCU_CTRLDESCL45_9_OFFSET)
#define DCU1_CTRLDESCL46_1            (DCU1_BASE + DCU_CTRLDESCL46_1_OFFSET)
#define DCU1_CTRLDESCL46_2            (DCU1_BASE + DCU_CTRLDESCL46_2_OFFSET)
#define DCU1_CTRLDESCL46_3            (DCU1_BASE + DCU_CTRLDESCL46_3_OFFSET)
#define DCU1_CTRLDESCL46_4            (DCU1_BASE + DCU_CTRLDESCL46_4_OFFSET)
#define DCU1_CTRLDESCL46_5            (DCU1_BASE + DCU_CTRLDESCL46_5_OFFSET)
#define DCU1_CTRLDESCL46_6            (DCU1_BASE + DCU_CTRLDESCL46_6_OFFSET)
#define DCU1_CTRLDESCL46_7            (DCU1_BASE + DCU_CTRLDESCL46_7_OFFSET)
#define DCU1_CTRLDESCL46_8            (DCU1_BASE + DCU_CTRLDESCL46_8_OFFSET)
#define DCU1_CTRLDESCL46_9            (DCU1_BASE + DCU_CTRLDESCL46_9_OFFSET)
#define DCU1_CTRLDESCL47_1            (DCU1_BASE + DCU_CTRLDESCL47_1_OFFSET)
#define DCU1_CTRLDESCL47_2            (DCU1_BASE + DCU_CTRLDESCL47_2_OFFSET)
#define DCU1_CTRLDESCL47_3            (DCU1_BASE + DCU_CTRLDESCL47_3_OFFSET)
#define DCU1_CTRLDESCL47_4            (DCU1_BASE + DCU_CTRLDESCL47_4_OFFSET)
#define DCU1_CTRLDESCL47_5            (DCU1_BASE + DCU_CTRLDESCL47_5_OFFSET)
#define DCU1_CTRLDESCL47_6            (DCU1_BASE + DCU_CTRLDESCL47_6_OFFSET)
#define DCU1_CTRLDESCL47_7            (DCU1_BASE + DCU_CTRLDESCL47_7_OFFSET)
#define DCU1_CTRLDESCL47_8            (DCU1_BASE + DCU_CTRLDESCL47_8_OFFSET)
#define DCU1_CTRLDESCL47_9            (DCU1_BASE + DCU_CTRLDESCL47_9_OFFSET)
#define DCU1_CTRLDESCL48_1            (DCU1_BASE + DCU_CTRLDESCL48_1_OFFSET)
#define DCU1_CTRLDESCL48_2            (DCU1_BASE + DCU_CTRLDESCL48_2_OFFSET)
#define DCU1_CTRLDESCL48_3            (DCU1_BASE + DCU_CTRLDESCL48_3_OFFSET)
#define DCU1_CTRLDESCL48_4            (DCU1_BASE + DCU_CTRLDESCL48_4_OFFSET)
#define DCU1_CTRLDESCL48_5            (DCU1_BASE + DCU_CTRLDESCL48_5_OFFSET)
#define DCU1_CTRLDESCL48_6            (DCU1_BASE + DCU_CTRLDESCL48_6_OFFSET)
#define DCU1_CTRLDESCL48_7            (DCU1_BASE + DCU_CTRLDESCL48_7_OFFSET)
#define DCU1_CTRLDESCL48_8            (DCU1_BASE + DCU_CTRLDESCL48_8_OFFSET)
#define DCU1_CTRLDESCL48_9            (DCU1_BASE + DCU_CTRLDESCL48_9_OFFSET)
#define DCU1_CTRLDESCL49_1            (DCU1_BASE + DCU_CTRLDESCL49_1_OFFSET)
#define DCU1_CTRLDESCL49_2            (DCU1_BASE + DCU_CTRLDESCL49_2_OFFSET)
#define DCU1_CTRLDESCL49_3            (DCU1_BASE + DCU_CTRLDESCL49_3_OFFSET)
#define DCU1_CTRLDESCL49_4            (DCU1_BASE + DCU_CTRLDESCL49_4_OFFSET)
#define DCU1_CTRLDESCL49_5            (DCU1_BASE + DCU_CTRLDESCL49_5_OFFSET)
#define DCU1_CTRLDESCL49_6            (DCU1_BASE + DCU_CTRLDESCL49_6_OFFSET)
#define DCU1_CTRLDESCL49_7            (DCU1_BASE + DCU_CTRLDESCL49_7_OFFSET)
#define DCU1_CTRLDESCL49_8            (DCU1_BASE + DCU_CTRLDESCL49_8_OFFSET)
#define DCU1_CTRLDESCL49_9            (DCU1_BASE + DCU_CTRLDESCL49_9_OFFSET)
#define DCU1_CTRLDESCL50_1            (DCU1_BASE + DCU_CTRLDESCL50_1_OFFSET)
#define DCU1_CTRLDESCL50_2            (DCU1_BASE + DCU_CTRLDESCL50_2_OFFSET)
#define DCU1_CTRLDESCL50_3            (DCU1_BASE + DCU_CTRLDESCL50_3_OFFSET)
#define DCU1_CTRLDESCL50_4            (DCU1_BASE + DCU_CTRLDESCL50_4_OFFSET)
#define DCU1_CTRLDESCL50_5            (DCU1_BASE + DCU_CTRLDESCL50_5_OFFSET)
#define DCU1_CTRLDESCL50_6            (DCU1_BASE + DCU_CTRLDESCL50_6_OFFSET)
#define DCU1_CTRLDESCL50_7            (DCU1_BASE + DCU_CTRLDESCL50_7_OFFSET)
#define DCU1_CTRLDESCL50_8            (DCU1_BASE + DCU_CTRLDESCL50_8_OFFSET)
#define DCU1_CTRLDESCL50_9            (DCU1_BASE + DCU_CTRLDESCL50_9_OFFSET)
#define DCU1_CTRLDESCL51_1            (DCU1_BASE + DCU_CTRLDESCL51_1_OFFSET)
#define DCU1_CTRLDESCL51_2            (DCU1_BASE + DCU_CTRLDESCL51_2_OFFSET)
#define DCU1_CTRLDESCL51_3            (DCU1_BASE + DCU_CTRLDESCL51_3_OFFSET)
#define DCU1_CTRLDESCL51_4            (DCU1_BASE + DCU_CTRLDESCL51_4_OFFSET)
#define DCU1_CTRLDESCL51_5            (DCU1_BASE + DCU_CTRLDESCL51_5_OFFSET)
#define DCU1_CTRLDESCL51_6            (DCU1_BASE + DCU_CTRLDESCL51_6_OFFSET)
#define DCU1_CTRLDESCL51_7            (DCU1_BASE + DCU_CTRLDESCL51_7_OFFSET)
#define DCU1_CTRLDESCL51_8            (DCU1_BASE + DCU_CTRLDESCL51_8_OFFSET)
#define DCU1_CTRLDESCL51_9            (DCU1_BASE + DCU_CTRLDESCL51_9_OFFSET)
#define DCU1_CTRLDESCL52_1            (DCU1_BASE + DCU_CTRLDESCL52_1_OFFSET)
#define DCU1_CTRLDESCL52_2            (DCU1_BASE + DCU_CTRLDESCL52_2_OFFSET)
#define DCU1_CTRLDESCL52_3            (DCU1_BASE + DCU_CTRLDESCL52_3_OFFSET)
#define DCU1_CTRLDESCL52_4            (DCU1_BASE + DCU_CTRLDESCL52_4_OFFSET)
#define DCU1_CTRLDESCL52_5            (DCU1_BASE + DCU_CTRLDESCL52_5_OFFSET)
#define DCU1_CTRLDESCL52_6            (DCU1_BASE + DCU_CTRLDESCL52_6_OFFSET)
#define DCU1_CTRLDESCL52_7            (DCU1_BASE + DCU_CTRLDESCL52_7_OFFSET)
#define DCU1_CTRLDESCL52_8            (DCU1_BASE + DCU_CTRLDESCL52_8_OFFSET)
#define DCU1_CTRLDESCL52_9            (DCU1_BASE + DCU_CTRLDESCL52_9_OFFSET)
#define DCU1_CTRLDESCL53_1            (DCU1_BASE + DCU_CTRLDESCL53_1_OFFSET)
#define DCU1_CTRLDESCL53_2            (DCU1_BASE + DCU_CTRLDESCL53_2_OFFSET)
#define DCU1_CTRLDESCL53_3            (DCU1_BASE + DCU_CTRLDESCL53_3_OFFSET)
#define DCU1_CTRLDESCL53_4            (DCU1_BASE + DCU_CTRLDESCL53_4_OFFSET)
#define DCU1_CTRLDESCL53_5            (DCU1_BASE + DCU_CTRLDESCL53_5_OFFSET)
#define DCU1_CTRLDESCL53_6            (DCU1_BASE + DCU_CTRLDESCL53_6_OFFSET)
#define DCU1_CTRLDESCL53_7            (DCU1_BASE + DCU_CTRLDESCL53_7_OFFSET)
#define DCU1_CTRLDESCL53_8            (DCU1_BASE + DCU_CTRLDESCL53_8_OFFSET)
#define DCU1_CTRLDESCL53_9            (DCU1_BASE + DCU_CTRLDESCL53_9_OFFSET)
#define DCU1_CTRLDESCL54_1            (DCU1_BASE + DCU_CTRLDESCL54_1_OFFSET)
#define DCU1_CTRLDESCL54_2            (DCU1_BASE + DCU_CTRLDESCL54_2_OFFSET)
#define DCU1_CTRLDESCL54_3            (DCU1_BASE + DCU_CTRLDESCL54_3_OFFSET)
#define DCU1_CTRLDESCL54_4            (DCU1_BASE + DCU_CTRLDESCL54_4_OFFSET)
#define DCU1_CTRLDESCL54_5            (DCU1_BASE + DCU_CTRLDESCL54_5_OFFSET)
#define DCU1_CTRLDESCL54_6            (DCU1_BASE + DCU_CTRLDESCL54_6_OFFSET)
#define DCU1_CTRLDESCL54_7            (DCU1_BASE + DCU_CTRLDESCL54_7_OFFSET)
#define DCU1_CTRLDESCL54_8            (DCU1_BASE + DCU_CTRLDESCL54_8_OFFSET)
#define DCU1_CTRLDESCL54_9            (DCU1_BASE + DCU_CTRLDESCL54_9_OFFSET)
#define DCU1_CTRLDESCL55_1            (DCU1_BASE + DCU_CTRLDESCL55_1_OFFSET)
#define DCU1_CTRLDESCL55_2            (DCU1_BASE + DCU_CTRLDESCL55_2_OFFSET)
#define DCU1_CTRLDESCL55_3            (DCU1_BASE + DCU_CTRLDESCL55_3_OFFSET)
#define DCU1_CTRLDESCL55_4            (DCU1_BASE + DCU_CTRLDESCL55_4_OFFSET)
#define DCU1_CTRLDESCL55_5            (DCU1_BASE + DCU_CTRLDESCL55_5_OFFSET)
#define DCU1_CTRLDESCL55_6            (DCU1_BASE + DCU_CTRLDESCL55_6_OFFSET)
#define DCU1_CTRLDESCL55_7            (DCU1_BASE + DCU_CTRLDESCL55_7_OFFSET)
#define DCU1_CTRLDESCL55_8            (DCU1_BASE + DCU_CTRLDESCL55_8_OFFSET)
#define DCU1_CTRLDESCL55_9            (DCU1_BASE + DCU_CTRLDESCL55_9_OFFSET)
#define DCU1_CTRLDESCL56_1            (DCU1_BASE + DCU_CTRLDESCL56_1_OFFSET)
#define DCU1_CTRLDESCL56_2            (DCU1_BASE + DCU_CTRLDESCL56_2_OFFSET)
#define DCU1_CTRLDESCL56_3            (DCU1_BASE + DCU_CTRLDESCL56_3_OFFSET)
#define DCU1_CTRLDESCL56_4            (DCU1_BASE + DCU_CTRLDESCL56_4_OFFSET)
#define DCU1_CTRLDESCL56_5            (DCU1_BASE + DCU_CTRLDESCL56_5_OFFSET)
#define DCU1_CTRLDESCL56_6            (DCU1_BASE + DCU_CTRLDESCL56_6_OFFSET)
#define DCU1_CTRLDESCL56_7            (DCU1_BASE + DCU_CTRLDESCL56_7_OFFSET)
#define DCU1_CTRLDESCL56_8            (DCU1_BASE + DCU_CTRLDESCL56_8_OFFSET)
#define DCU1_CTRLDESCL56_9            (DCU1_BASE + DCU_CTRLDESCL56_9_OFFSET)
#define DCU1_CTRLDESCL57_1            (DCU1_BASE + DCU_CTRLDESCL57_1_OFFSET)
#define DCU1_CTRLDESCL57_2            (DCU1_BASE + DCU_CTRLDESCL57_2_OFFSET)
#define DCU1_CTRLDESCL57_3            (DCU1_BASE + DCU_CTRLDESCL57_3_OFFSET)
#define DCU1_CTRLDESCL57_4            (DCU1_BASE + DCU_CTRLDESCL57_4_OFFSET)
#define DCU1_CTRLDESCL57_5            (DCU1_BASE + DCU_CTRLDESCL57_5_OFFSET)
#define DCU1_CTRLDESCL57_6            (DCU1_BASE + DCU_CTRLDESCL57_6_OFFSET)
#define DCU1_CTRLDESCL57_7            (DCU1_BASE + DCU_CTRLDESCL57_7_OFFSET)
#define DCU1_CTRLDESCL57_8            (DCU1_BASE + DCU_CTRLDESCL57_8_OFFSET)
#define DCU1_CTRLDESCL57_9            (DCU1_BASE + DCU_CTRLDESCL57_9_OFFSET)
#define DCU1_CTRLDESCL58_1            (DCU1_BASE + DCU_CTRLDESCL58_1_OFFSET)
#define DCU1_CTRLDESCL58_2            (DCU1_BASE + DCU_CTRLDESCL58_2_OFFSET)
#define DCU1_CTRLDESCL58_3            (DCU1_BASE + DCU_CTRLDESCL58_3_OFFSET)
#define DCU1_CTRLDESCL58_4            (DCU1_BASE + DCU_CTRLDESCL58_4_OFFSET)
#define DCU1_CTRLDESCL58_5            (DCU1_BASE + DCU_CTRLDESCL58_5_OFFSET)
#define DCU1_CTRLDESCL58_6            (DCU1_BASE + DCU_CTRLDESCL58_6_OFFSET)
#define DCU1_CTRLDESCL58_7            (DCU1_BASE + DCU_CTRLDESCL58_7_OFFSET)
#define DCU1_CTRLDESCL58_8            (DCU1_BASE + DCU_CTRLDESCL58_8_OFFSET)
#define DCU1_CTRLDESCL58_9            (DCU1_BASE + DCU_CTRLDESCL58_9_OFFSET)
#define DCU1_CTRLDESCL59_1            (DCU1_BASE + DCU_CTRLDESCL59_1_OFFSET)
#define DCU1_CTRLDESCL59_2            (DCU1_BASE + DCU_CTRLDESCL59_2_OFFSET)
#define DCU1_CTRLDESCL59_3            (DCU1_BASE + DCU_CTRLDESCL59_3_OFFSET)
#define DCU1_CTRLDESCL59_4            (DCU1_BASE + DCU_CTRLDESCL59_4_OFFSET)
#define DCU1_CTRLDESCL59_5            (DCU1_BASE + DCU_CTRLDESCL59_5_OFFSET)
#define DCU1_CTRLDESCL59_6            (DCU1_BASE + DCU_CTRLDESCL59_6_OFFSET)
#define DCU1_CTRLDESCL59_7            (DCU1_BASE + DCU_CTRLDESCL59_7_OFFSET)
#define DCU1_CTRLDESCL59_8            (DCU1_BASE + DCU_CTRLDESCL59_8_OFFSET)
#define DCU1_CTRLDESCL59_9            (DCU1_BASE + DCU_CTRLDESCL59_9_OFFSET)
#define DCU1_CTRLDESCL60_1            (DCU1_BASE + DCU_CTRLDESCL60_1_OFFSET)
#define DCU1_CTRLDESCL60_2            (DCU1_BASE + DCU_CTRLDESCL60_2_OFFSET)
#define DCU1_CTRLDESCL60_3            (DCU1_BASE + DCU_CTRLDESCL60_3_OFFSET)
#define DCU1_CTRLDESCL60_4            (DCU1_BASE + DCU_CTRLDESCL60_4_OFFSET)
#define DCU1_CTRLDESCL60_5            (DCU1_BASE + DCU_CTRLDESCL60_5_OFFSET)
#define DCU1_CTRLDESCL60_6            (DCU1_BASE + DCU_CTRLDESCL60_6_OFFSET)
#define DCU1_CTRLDESCL60_7            (DCU1_BASE + DCU_CTRLDESCL60_7_OFFSET)
#define DCU1_CTRLDESCL60_8            (DCU1_BASE + DCU_CTRLDESCL60_8_OFFSET)
#define DCU1_CTRLDESCL60_9            (DCU1_BASE + DCU_CTRLDESCL60_9_OFFSET)
#define DCU1_CTRLDESCL61_1            (DCU1_BASE + DCU_CTRLDESCL61_1_OFFSET)
#define DCU1_CTRLDESCL61_2            (DCU1_BASE + DCU_CTRLDESCL61_2_OFFSET)
#define DCU1_CTRLDESCL61_3            (DCU1_BASE + DCU_CTRLDESCL61_3_OFFSET)
#define DCU1_CTRLDESCL61_4            (DCU1_BASE + DCU_CTRLDESCL61_4_OFFSET)
#define DCU1_CTRLDESCL61_5            (DCU1_BASE + DCU_CTRLDESCL61_5_OFFSET)
#define DCU1_CTRLDESCL61_6            (DCU1_BASE + DCU_CTRLDESCL61_6_OFFSET)
#define DCU1_CTRLDESCL61_7            (DCU1_BASE + DCU_CTRLDESCL61_7_OFFSET)
#define DCU1_CTRLDESCL61_8            (DCU1_BASE + DCU_CTRLDESCL61_8_OFFSET)
#define DCU1_CTRLDESCL61_9            (DCU1_BASE + DCU_CTRLDESCL61_9_OFFSET)
#define DCU1_CTRLDESCL62_1            (DCU1_BASE + DCU_CTRLDESCL62_1_OFFSET)
#define DCU1_CTRLDESCL62_2            (DCU1_BASE + DCU_CTRLDESCL62_2_OFFSET)
#define DCU1_CTRLDESCL62_3            (DCU1_BASE + DCU_CTRLDESCL62_3_OFFSET)
#define DCU1_CTRLDESCL62_4            (DCU1_BASE + DCU_CTRLDESCL62_4_OFFSET)
#define DCU1_CTRLDESCL62_5            (DCU1_BASE + DCU_CTRLDESCL62_5_OFFSET)
#define DCU1_CTRLDESCL62_6            (DCU1_BASE + DCU_CTRLDESCL62_6_OFFSET)
#define DCU1_CTRLDESCL62_7            (DCU1_BASE + DCU_CTRLDESCL62_7_OFFSET)
#define DCU1_CTRLDESCL62_8            (DCU1_BASE + DCU_CTRLDESCL62_8_OFFSET)
#define DCU1_CTRLDESCL62_9            (DCU1_BASE + DCU_CTRLDESCL62_9_OFFSET)
#define DCU1_CTRLDESCL63_1            (DCU1_BASE + DCU_CTRLDESCL63_1_OFFSET)
#define DCU1_CTRLDESCL63_2            (DCU1_BASE + DCU_CTRLDESCL63_2_OFFSET)
#define DCU1_CTRLDESCL63_3            (DCU1_BASE + DCU_CTRLDESCL63_3_OFFSET)
#define DCU1_CTRLDESCL63_4            (DCU1_BASE + DCU_CTRLDESCL63_4_OFFSET)
#define DCU1_CTRLDESCL63_5            (DCU1_BASE + DCU_CTRLDESCL63_5_OFFSET)
#define DCU1_CTRLDESCL63_6            (DCU1_BASE + DCU_CTRLDESCL63_6_OFFSET)
#define DCU1_CTRLDESCL63_7            (DCU1_BASE + DCU_CTRLDESCL63_7_OFFSET)
#define DCU1_CTRLDESCL63_8            (DCU1_BASE + DCU_CTRLDESCL63_8_OFFSET)
#define DCU1_CTRLDESCL63_9            (DCU1_BASE + DCU_CTRLDESCL63_9_OFFSET)




/* Field definitions for CTRLDESCCURSOR1 */
#define DCU_CTRLDESCCURSOR1_HEIGHT_SHIFT               (16)
#define DCU_CTRLDESCCURSOR1_HEIGHT_MASK                ((0x000007FF) << (DCU_CTRLDESCCURSOR1_HEIGHT_SHIFT)) 

#define DCU_CTRLDESCCURSOR1_WIDTH_SHIFT                (0)
#define DCU_CTRLDESCCURSOR1_WIDTH_MASK                 ((0x000007FF) << (DCU_CTRLDESCCURSOR1_WIDTH_SHIFT)) 



/* Field definitions for CTRLDESCCURSOR2 */
#define DCU_CTRLDESCCURSOR2_POSY_SHIFT                 (16)
#define DCU_CTRLDESCCURSOR2_POSY_MASK                  ((0x000007FF) << (DCU_CTRLDESCCURSOR2_POSY_SHIFT)) 

#define DCU_CTRLDESCCURSOR2_POSX_SHIFT                 (0)
#define DCU_CTRLDESCCURSOR2_POSX_MASK                  ((0x000007FF) << (DCU_CTRLDESCCURSOR2_POSX_SHIFT)) 



/* Field definitions for CTRLDESCCURSOR3 */
#define DCU_CTRLDESCCURSOR3_CUR_EN_SHIFT               (31)  
#define DCU_CTRLDESCCURSOR3_CUR_EN_MASK                ((1) << (DCU_CTRLDESCCURSOR3_CUR_EN_SHIFT)) 

#define DCU_CTRLDESCCURSOR3_DEFAULT_CURSOR_COLOR_SHIFT (0)
#define DCU_CTRLDESCCURSOR3_DEFAULT_CURSOR_COLOR_MASK  ((0x00FFFFFF) << (DCU_CTRLDESCCURSOR3_DEFAULT_CURSOR_COLOR_SHIFT)) 



/* Field definitions for CTRLDESCCURSOR4 */
#define DCU_CTRLDESCCURSOR4_HWC_BLINK_OFF_SHIFT        (16)
#define DCU_CTRLDESCCURSOR4_HWC_BLINK_OFF_MASK         ((0x000000FF) << (DCU_CTRLDESCCURSOR4_HWC_BLINK_OFF_SHIFT)) 

#define DCU_CTRLDESCCURSOR4_EN_BLINK_SHIFT             (8)  
#define DCU_CTRLDESCCURSOR4_EN_BLINK_MASK              ((1) << (DCU_CTRLDESCCURSOR4_EN_BLINK_SHIFT)) 

#define DCU_CTRLDESCCURSOR4_HWC_BLINK_ON_SHIFT         (0)
#define DCU_CTRLDESCCURSOR4_HWC_BLINK_ON_MASK          ((0x000000FF) << (DCU_CTRLDESCCURSOR4_HWC_BLINK_ON_SHIFT)) 



/* Field definitions for DCU_MODE */
#define DCU_DCU_MODE_DCU_SW_RESET_SHIFT         (31)  
#define DCU_DCU_MODE_DCU_SW_RESET_MASK          ((1) << (DCU_DCU_MODE_DCU_SW_RESET_SHIFT)) 

#define DCU_DCU_MODE_EN_DITHER_SHIFT         (30)  
#define DCU_DCU_MODE_EN_DITHER_MASK          ((1) << (DCU_DCU_MODE_EN_DITHER_SHIFT)) 

#define DCU_DCU_MODE_ADDB_SHIFT         (28)  
#define DCU_DCU_MODE_ADDB_MASK          ((0x00000003) << (DCU_DCU_MODE_ADDB_SHIFT)) 

#define DCU_DCU_MODE_ADDG_SHIFT         (26)  
#define DCU_DCU_MODE_ADDG_MASK          ((0x00000003) << (DCU_DCU_MODE_ADDG_SHIFT)) 

#define DCU_DCU_MODE_ADDR_SHIFT         (24)  
#define DCU_DCU_MODE_ADDR_MASK          ((0x00000003) << (DCU_DCU_MODE_ADDR_SHIFT)) 

#define DCU_DCU_MODE_DDR_MODE_SHIFT         (23)  
#define DCU_DCU_MODE_DDR_MODE_MASK          ((1) << (DCU_DCU_MODE_DDR_MODE_SHIFT)) 

#define DCU_DCU_MODE_BLEND_ITER_SHIFT         (20)  
#define DCU_DCU_MODE_BLEND_ITER_MASK          ((0x00000007) << (DCU_DCU_MODE_BLEND_ITER_SHIFT)) 

#define DCU_DCU_MODE_RASTER_EN_SHIFT            (14)  
#define DCU_DCU_MODE_RASTER_EN_MASK             ((1) << (DCU_DCU_MODE_RASTER_EN_SHIFT)) 

#define DCU_DCU_MODE_TAG_EN_SHIFT               (6)  
#define DCU_DCU_MODE_TAG_EN_MASK                ((1) << (DCU_DCU_MODE_TAG_EN_SHIFT)) 

#define DCU_DCU_MODE_SIG_EN_SHIFT               (5)  
#define DCU_DCU_MODE_SIG_EN_MASK                ((1) << (DCU_DCU_MODE_SIG_EN_SHIFT)) 

#define DCU_DCU_MODE_EN_GAMMA_SHIFT             (2)  
#define DCU_DCU_MODE_EN_GAMMA_MASK              ((1) << (DCU_DCU_MODE_EN_GAMMA_SHIFT)) 

#define DCU_DCU_MODE_DCU_MODE_SHIFT             (0)
#define DCU_DCU_MODE_DCU_MODE_MASK              ((0x00000003) << (DCU_DCU_MODE_DCU_MODE_SHIFT)) 



/* Field definitions for BGND */
#define DCU_BGND_BGND_R_SHIFT               (16)
#define DCU_BGND_BGND_R_MASK                ((0x000000FF) << (DCU_BGND_BGND_R_SHIFT)) 

#define DCU_BGND_BGND_G_SHIFT               (8)
#define DCU_BGND_BGND_G_MASK                ((0x000000FF) << (DCU_BGND_BGND_G_SHIFT)) 

#define DCU_BGND_BGND_B_SHIFT               (0)
#define DCU_BGND_BGND_B_MASK                ((0x000000FF) << (DCU_BGND_BGND_B_SHIFT)) 



/* Field definitions for DISP_SIZE */
#define DCU_DISP_SIZE_DELTA_Y_SHIFT              (16)
#define DCU_DISP_SIZE_DELTA_Y_MASK               ((0x000007FF) << (DCU_DISP_SIZE_DELTA_Y_SHIFT)) 

#define DCU_DISP_SIZE_DELTA_X_SHIFT              (0)
#define DCU_DISP_SIZE_DELTA_X_MASK               ((0x0000007F) << (DCU_DISP_SIZE_DELTA_X_SHIFT)) 



/* Field definitions for HSYN_PARA */
#define DCU_HSYN_PARA_BP_H_SHIFT                 (22)
#define DCU_HSYN_PARA_BP_H_MASK                  ((0x000001FF) << (DCU_HSYN_PARA_BP_H_SHIFT)) 

#define DCU_HSYN_PARA_PW_H_SHIFT                 (11)
#define DCU_HSYN_PARA_PW_H_MASK                  ((0x000001FF) << (DCU_HSYN_PARA_PW_H_SHIFT)) 

#define DCU_HSYN_PARA_FP_H_SHIFT                 (0)
#define DCU_HSYN_PARA_FP_H_MASK                  ((0x000001FF) << (DCU_HSYN_PARA_FP_H_SHIFT)) 



/* Field definitions for VSYN_PARA */
#define DCU_VSYN_PARA_BP_V_SHIFT                 (22)
#define DCU_VSYN_PARA_BP_V_MASK                  ((0x000001FF) << (DCU_VSYN_PARA_BP_V_SHIFT)) 

#define DCU_VSYN_PARA_PW_V_SHIFT                 (11)
#define DCU_VSYN_PARA_PW_V_MASK                  ((0x000001FF) << (DCU_VSYN_PARA_PW_V_SHIFT)) 

#define DCU_VSYN_PARA_FP_V_SHIFT                 (0)
#define DCU_VSYN_PARA_FP_V_MASK                  ((0x000001FF) << (DCU_VSYN_PARA_FP_V_SHIFT)) 



/* Field definitions for SYNPOL */
#define DCU_SYNPOL_INV_PXCK_SHIFT             (6)  
#define DCU_SYNPOL_INV_PXCK_MASK              ((1) << (DCU_SYNPOL_INV_PXCK_SHIFT)) 

#define DCU_SYNPOL_NEG_SHIFT                  (5)  
#define DCU_SYNPOL_NEG_MASK                   ((1) << (DCU_SYNPOL_NEG_SHIFT)) 

#define DCU_SYNPOL_BP_VS_SHIFT                (4)  
#define DCU_SYNPOL_BP_VS_MASK                 ((1) << (DCU_SYNPOL_BP_VS_SHIFT)) 

#define DCU_SYNPOL_BP_HS_SHIFT                (3)  
#define DCU_SYNPOL_BP_HS_MASK                 ((1) << (DCU_SYNPOL_BP_HS_SHIFT)) 

#define DCU_SYNPOL_INV_CS_SHIFT               (2)  
#define DCU_SYNPOL_INV_CS_MASK                ((1) << (DCU_SYNPOL_INV_CS_SHIFT)) 

#define DCU_SYNPOL_INV_VS_SHIFT               (1)  
#define DCU_SYNPOL_INV_VS_MASK                ((1) << (DCU_SYNPOL_INV_VS_SHIFT)) 

#define DCU_SYNPOL_INV_HS_SHIFT               (0)  
#define DCU_SYNPOL_INV_HS_MASK                ((1) << (DCU_SYNPOL_INV_HS_SHIFT)) 



/* Field definitions for THRESHOLD */
#define DCU_THRESHOLD_LS_BF_VS_SHIFT             (16)
#define DCU_THRESHOLD_LS_BF_VS_MASK              ((0x000003FF) << (DCU_THRESHOLD_LS_BF_VS_SHIFT)) 

#define DCU_THRESHOLD_OUT_BUF_HIGH_SHIFT         (8)
#define DCU_THRESHOLD_OUT_BUF_HIGH_MASK          ((0x000000FF) << (DCU_THRESHOLD_OUT_BUF_HIGH_SHIFT)) 

#define DCU_THRESHOLD_OUT_BUF_LOW_SHIFT          (0)
#define DCU_THRESHOLD_OUT_BUF_LOW_MASK           ((0x000000FF) << (DCU_THRESHOLD_OUT_BUF_LOW_SHIFT)) 



/* Field definitions for INT_STATUS */
#define DCU_INT_STATUS_P6_EMPTY_SHIFT      (31)  
#define DCU_INT_STATUS_P6_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P6_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P5_EMPTY_SHIFT      (30)  
#define DCU_INT_STATUS_P5_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P5_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P4_EMPTY_SHIFT      (29)  
#define DCU_INT_STATUS_P4_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P4_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P3_EMPTY_SHIFT      (28)  
#define DCU_INT_STATUS_P3_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P3_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P2_EMPTY_SHIFT      (27)  
#define DCU_INT_STATUS_P2_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P2_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P1_EMPTY_SHIFT      (26)  
#define DCU_INT_STATUS_P1_EMPTY_MASK       ((1) << (DCU_INT_STATUS_P1_EMPTY_SHIFT)) 

#define DCU_INT_STATUS_P6_FIFO_HI_FLAG_SHIFT      (23)  
#define DCU_INT_STATUS_P6_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P6_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P6_FIFO_LO_FLAG_SHIFT      (22)  
#define DCU_INT_STATUS_P6_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P6_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P5_FIFO_HI_FLAG_SHIFT      (21)  
#define DCU_INT_STATUS_P5_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P5_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P5_FIFO_LO_FLAG_SHIFT      (20)  
#define DCU_INT_STATUS_P5_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P5_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P4_FIFO_HI_FLAG_SHIFT      (19)  
#define DCU_INT_STATUS_P4_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P4_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P4_FIFO_LO_FLAG_SHIFT      (18)  
#define DCU_INT_STATUS_P4_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P4_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P3_FIFO_HI_FLAG_SHIFT      (17)  
#define DCU_INT_STATUS_P3_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P3_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P3_FIFO_LO_FLAG_SHIFT      (16)  
#define DCU_INT_STATUS_P3_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P3_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_DMA_TRANS_FINISH_SHIFT     (14)  
#define DCU_INT_STATUS_DMA_TRANS_FINISH_MASK      ((1) << (DCU_INT_STATUS_DMA_TRANS_FINISH_SHIFT)) 

#define DCU_INT_STATUS_LYR_TRANS_FINISH_SHIFT     (12)
#define DCU_INT_STATUS_LYR_TRANS_FINISH_MASK      ((1) << (DCU_INT_STATUS_LYR_TRANS_FINISH_SHIFT)) 
#define DCU_INT_STATUS_IPM_ERROR_SHIFT            (11)  
#define DCU_INT_STATUS_IPM_ERROR_MASK             ((1) << (DCU_INT_STATUS_IPM_ERROR_SHIFT)) 

#define DCU_INT_STATUS_PROG_END_SHIFT             (10)  
#define DCU_INT_STATUS_PROG_END_MASK              ((1) << (DCU_INT_STATUS_PROG_END_SHIFT)) 

#define DCU_INT_STATUS_P2_FIFO_HI_FLAG_SHIFT      (9)  
#define DCU_INT_STATUS_P2_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P2_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P2_FIFO_LO_FLAG_SHIFT      (8)  
#define DCU_INT_STATUS_P2_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P2_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P1_FIFO_HI_FLAG_SHIFT      (7)  
#define DCU_INT_STATUS_P1_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_STATUS_P1_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_STATUS_P1_FIFO_LO_FLAG_SHIFT      (6)  
#define DCU_INT_STATUS_P1_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_STATUS_P1_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_STATUS_CRC_OVERFLOW_SHIFT         (5)  
#define DCU_INT_STATUS_CRC_OVERFLOW_MASK          ((1) << (DCU_INT_STATUS_CRC_OVERFLOW_SHIFT)) 

#define DCU_INT_STATUS_CRC_READY_SHIFT            (4)  
#define DCU_INT_STATUS_CRC_READY_MASK             ((1) << (DCU_INT_STATUS_CRC_READY_SHIFT)) 

#define DCU_INT_STATUS_VS_BLANK_SHIFT             (3)  
#define DCU_INT_STATUS_VS_BLANK_MASK              ((1) << (DCU_INT_STATUS_VS_BLANK_SHIFT)) 

#define DCU_INT_STATUS_LS_BF_VS_SHIFT             (2)  
#define DCU_INT_STATUS_LS_BF_VS_MASK              ((1) << (DCU_INT_STATUS_LS_BF_VS_SHIFT)) 

#define DCU_INT_STATUS_UNDRUN_SHIFT               (1)  
#define DCU_INT_STATUS_UNDRUN_MASK                ((1) << (DCU_INT_STATUS_UNDRUN_SHIFT)) 

#define DCU_INT_STATUS_VSYNC_SHIFT                (0)  
#define DCU_INT_STATUS_VSYNC_MASK                 ((1) << (DCU_INT_STATUS_VSYNC_SHIFT)) 



/* Field definitions for INT_MASK */
#define DCU_INT_MASK_M_P6_EMPTY_SHIFT      (31)  
#define DCU_INT_MASK_M_P6_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P6_EMPTY_SHIFT)) 
                                                                     
#define DCU_INT_MASK_M_P5_EMPTY_SHIFT      (30)                  
#define DCU_INT_MASK_M_P5_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P5_EMPTY_SHIFT)) 
                                                                     
#define DCU_INT_MASK_M_P4_EMPTY_SHIFT      (29)                   
#define DCU_INT_MASK_M_P4_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P4_EMPTY_SHIFT)) 
                                                                     
#define DCU_INT_MASK_M_P3_EMPTY_SHIFT      (28)                    
#define DCU_INT_MASK_M_P3_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P3_EMPTY_SHIFT)) 
                                                                     
#define DCU_INT_MASK_M_P2_EMPTY_SHIFT      (27)                    
#define DCU_INT_MASK_M_P2_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P2_EMPTY_SHIFT)) 
                                                                     
#define DCU_INT_MASK_M_P1_EMPTY_SHIFT      (26)                    
#define DCU_INT_MASK_M_P1_EMPTY_MASK       ((1) << (DCU_INT_MASK_M_P1_EMPTY_SHIFT)) 
                       
#define DCU_INT_MASK_M_P6_FIFO_HI_FLAG_SHIFT      (23)  
#define DCU_INT_MASK_M_P6_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_MASK_M_P6_FIFO_HI_FLAG_SHIFT)) 
                                                                        
#define DCU_INT_MASK_M_P6_FIFO_LO_FLAG_SHIFT      (22)                  
#define DCU_INT_MASK_M_P6_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_MASK_M_P6_FIFO_LO_FLAG_SHIFT)) 
                                                                        
#define DCU_INT_MASK_M_P5_FIFO_HI_FLAG_SHIFT      (21)                  
#define DCU_INT_MASK_M_P5_FIFO_HI_FLAG_MASK       ((1) << (DCU_INT_MASK_M_P5_FIFO_HI_FLAG_SHIFT)) 
                                                                        
#define DCU_INT_MASK_M_P5_FIFO_LO_FLAG_SHIFT      (20)                  
#define DCU_INT_MASK_M_P5_FIFO_LO_FLAG_MASK       ((1) << (DCU_INT_MASK_M_P5_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P4_FIFO_HI_FLAG_SHIFT    (19)  
#define DCU_INT_MASK_M_P4_FIFO_HI_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P4_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P4_FIFO_LO_FLAG_SHIFT    (18)  
#define DCU_INT_MASK_M_P4_FIFO_LO_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P4_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P3_FIFO_HI_FLAG_SHIFT    (17)  
#define DCU_INT_MASK_M_P3_FIFO_HI_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P3_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P3_FIFO_LO_FLAG_SHIFT    (16)  
#define DCU_INT_MASK_M_P3_FIFO_LO_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P3_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_DMA_TRANS_FINISH_SHIFT   (14)  
#define DCU_INT_MASK_M_DMA_TRANS_FINISH_MASK    ((1) << (DCU_INT_MASK_M_DMA_TRANS_FINISH_SHIFT)) 

#define DCU_INT_MASK_M_LYR_TRANS_FINISH_SHIFT   (12)  
#define DCU_INT_MASK_M_LYR_TRANS_FINISH_MASK    ((1) << (DCU_INT_MASK_M_LYR_TRANS_FINISH_SHIFT)) 

#define DCU_INT_MASK_M_IPM_ERROR_SHIFT          (11)  
#define DCU_INT_MASK_M_IPM_ERROR_MASK           ((1) << (DCU_INT_MASK_M_IPM_ERROR_SHIFT)) 

#define DCU_INT_MASK_M_PROG_END_SHIFT           (10)  
#define DCU_INT_MASK_M_PROG_END_MASK            ((1) << (DCU_INT_MASK_M_PROG_END_SHIFT)) 

#define DCU_INT_MASK_M_P2_FIFO_HI_FLAG_SHIFT    (9)  
#define DCU_INT_MASK_M_P2_FIFO_HI_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P2_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P2_FIFO_LO_FLAG_SHIFT    (8)  
#define DCU_INT_MASK_M_P2_FIFO_LO_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P2_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P1_FIFO_HI_FLAG_SHIFT    (7)  
#define DCU_INT_MASK_M_P1_FIFO_HI_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P1_FIFO_HI_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_P1_FIFO_LO_FLAG_SHIFT    (6)  
#define DCU_INT_MASK_M_P1_FIFO_LO_FLAG_MASK     ((1) << (DCU_INT_MASK_M_P1_FIFO_LO_FLAG_SHIFT)) 

#define DCU_INT_MASK_M_CRC_OVERFLOW_SHIFT       (5)  
#define DCU_INT_MASK_M_CRC_OVERFLOW_MASK        ((1) << (DCU_INT_MASK_M_CRC_OVERFLOW_SHIFT)) 

#define DCU_INT_MASK_M_CRC_READY_SHIFT          (4)  
#define DCU_INT_MASK_M_CRC_READY_MASK           ((1) << (DCU_INT_MASK_M_CRC_READY_SHIFT)) 

#define DCU_INT_MASK_M_VS_BLANK_SHIFT           (3)  
#define DCU_INT_MASK_M_VS_BLANK_MASK            ((1) << (DCU_INT_MASK_M_VS_BLANK_SHIFT)) 

#define DCU_INT_MASK_M_LS_BF_VS_SHIFT           (2)  
#define DCU_INT_MASK_M_LS_BF_VS_MASK            ((1) << (DCU_INT_MASK_M_LS_BF_VS_SHIFT)) 

#define DCU_INT_MASK_M_UNDRUN_SHIFT             (1)  
#define DCU_INT_MASK_M_UNDRUN_MASK              ((1) << (DCU_INT_MASK_M_UNDRUN_SHIFT)) 

#define DCU_INT_MASK_M_VSYNC_SHIFT              (0)  
#define DCU_INT_MASK_M_VSYNC_MASK               ((1) << (DCU_INT_MASK_M_VSYNC_SHIFT)) 



/* Field definitions for COLBAR_n */
#define DCU_COLBAR_n_R_SHIFT           (16)
#define DCU_COLBAR_n_R_MASK            ((0x000000FF) << (DCU_COLBAR_n_R_SHIFT)) 

#define DCU_COLBAR_n_G_SHIFT           (8)
#define DCU_COLBAR_n_G_MASK            ((0x000000FF) << (DCU_COLBAR_n_G_SHIFT)) 

#define DCU_COLBAR_n_B_SHIFT           (0)
#define DCU_COLBAR_n_B_MASK            ((0x000000FF) << (DCU_COLBAR_n_B_SHIFT)) 




/* Field definitions for DIV_RATIO */
#define DCU_DIV_RATIO_DIV_RATIO_SHIFT            (0)
#define DCU_DIV_RATIO_DIV_RATIO_MASK             ((0x000000FF) << (DCU_DIV_RATIO_DIV_RATIO_SHIFT)) 



/* Field definitions for SIGN_CALC_1 */
#define DCU_SIGN_CALC_1_SIG_VER_SIZE_SHIFT         (16)
#define DCU_SIGN_CALC_1_SIG_VER_SIZE_MASK          ((0x000007FF) << (DCU_SIGN_CALC_1_SIG_VER_SIZE_SHIFT)) 

#define DCU_SIGN_CALC_1_SIG_HOR_SIZE_SHIFT         (0)
#define DCU_SIGN_CALC_1_SIG_HOR_SIZE_MASK          ((0x000007FF) << (DCU_SIGN_CALC_1_SIG_HOR_SIZE_SHIFT)) 



/* Field definitions for SIGN_CALC_2 */
#define DCU_SIGN_CALC_2_SIG_VER_POS_SHIFT          (16)
#define DCU_SIGN_CALC_2_SIG_VER_POS_MASK           ((0x000007FF) << (DCU_SIGN_CALC_2_SIG_VER_POS_SHIFT)) 

#define DCU_SIGN_CALC_2_SIG_HOR_POS_SHIFT          (0)
#define DCU_SIGN_CALC_2_SIG_HOR_POS_MASK           ((0x000007FF) << (DCU_SIGN_CALC_2_SIG_HOR_POS_SHIFT)) 



/* Field definitions for CRC_VAL */
#define DCU_CRC_VAL_CRC_VAL_SHIFT              (0)
#define DCU_CRC_VAL_CRC_VAL_MASK               ((0xFFFFFFFF) << (DCU_CRC_VAL_CRC_VAL_SHIFT)) 



/* Field definitions for PARR_ERR_STATUS1 */
#define DCU_PARR_ERR_STATUS1_L31_SHIFT         (31)  
#define DCU_PARR_ERR_STATUS1_L31_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L31_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L30_SHIFT         (30)  
#define DCU_PARR_ERR_STATUS1_L30_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L30_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L29_SHIFT         (29)  
#define DCU_PARR_ERR_STATUS1_L29_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L29_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L28_SHIFT         (28)  
#define DCU_PARR_ERR_STATUS1_L28_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L28_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L27_SHIFT         (27)  
#define DCU_PARR_ERR_STATUS1_L27_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L27_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L26_SHIFT         (26)  
#define DCU_PARR_ERR_STATUS1_L26_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L26_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L25_SHIFT         (25)  
#define DCU_PARR_ERR_STATUS1_L25_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L25_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L24_SHIFT         (24)  
#define DCU_PARR_ERR_STATUS1_L24_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L24_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L23_SHIFT         (23)  
#define DCU_PARR_ERR_STATUS1_L23_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L23_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L22_SHIFT         (22)  
#define DCU_PARR_ERR_STATUS1_L22_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L22_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L21_SHIFT         (21)  
#define DCU_PARR_ERR_STATUS1_L21_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L21_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L20_SHIFT         (20)  
#define DCU_PARR_ERR_STATUS1_L20_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L20_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L19_SHIFT         (19)  
#define DCU_PARR_ERR_STATUS1_L19_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L19_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L18_SHIFT         (18)  
#define DCU_PARR_ERR_STATUS1_L18_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L18_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L17_SHIFT         (17)  
#define DCU_PARR_ERR_STATUS1_L17_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L17_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L16_SHIFT         (16)  
#define DCU_PARR_ERR_STATUS1_L16_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L16_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L15_SHIFT         (15)  
#define DCU_PARR_ERR_STATUS1_L15_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L15_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L14_SHIFT         (14)  
#define DCU_PARR_ERR_STATUS1_L14_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L14_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L13_SHIFT         (13)  
#define DCU_PARR_ERR_STATUS1_L13_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L13_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L12_SHIFT         (12)  
#define DCU_PARR_ERR_STATUS1_L12_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L12_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L11_SHIFT         (11)  
#define DCU_PARR_ERR_STATUS1_L11_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L11_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L10_SHIFT         (10)  
#define DCU_PARR_ERR_STATUS1_L10_MASK          ((1) << (DCU_PARR_ERR_STATUS1_L10_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L9_SHIFT          (9)  
#define DCU_PARR_ERR_STATUS1_L9_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L9_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L8_SHIFT          (8)  
#define DCU_PARR_ERR_STATUS1_L8_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L8_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L7_SHIFT          (7)  
#define DCU_PARR_ERR_STATUS1_L7_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L7_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L6_SHIFT          (6)  
#define DCU_PARR_ERR_STATUS1_L6_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L6_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L5_SHIFT          (5)  
#define DCU_PARR_ERR_STATUS1_L5_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L5_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L4_SHIFT          (4)  
#define DCU_PARR_ERR_STATUS1_L4_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L4_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L3_SHIFT          (3)  
#define DCU_PARR_ERR_STATUS1_L3_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L3_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L2_SHIFT          (2)  
#define DCU_PARR_ERR_STATUS1_L2_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L2_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L1_SHIFT          (1)  
#define DCU_PARR_ERR_STATUS1_L1_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L1_SHIFT)) 

#define DCU_PARR_ERR_STATUS1_L0_SHIFT          (0)  
#define DCU_PARR_ERR_STATUS1_L0_MASK           ((1) << (DCU_PARR_ERR_STATUS1_L0_SHIFT)) 



/* Field definitions for PARR_ERR_STATUS2 */
#define DCU_PARR_ERR_STATUS2_L63_SHIFT         (31)  
#define DCU_PARR_ERR_STATUS2_L63_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L63_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L62_SHIFT         (30)  
#define DCU_PARR_ERR_STATUS2_L62_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L62_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L61_SHIFT         (29)  
#define DCU_PARR_ERR_STATUS2_L61_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L61_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L60_SHIFT         (28)  
#define DCU_PARR_ERR_STATUS2_L60_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L60_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L59_SHIFT         (27)  
#define DCU_PARR_ERR_STATUS2_L59_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L59_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L58_SHIFT         (26)  
#define DCU_PARR_ERR_STATUS2_L58_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L58_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L57_SHIFT         (25)  
#define DCU_PARR_ERR_STATUS2_L57_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L57_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L56_SHIFT         (24)  
#define DCU_PARR_ERR_STATUS2_L56_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L56_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L55_SHIFT         (23)  
#define DCU_PARR_ERR_STATUS2_L55_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L55_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L54_SHIFT         (22)  
#define DCU_PARR_ERR_STATUS2_L54_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L54_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L53_SHIFT         (21)  
#define DCU_PARR_ERR_STATUS2_L53_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L53_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L52_SHIFT         (20)  
#define DCU_PARR_ERR_STATUS2_L52_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L52_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L51_SHIFT         (19)  
#define DCU_PARR_ERR_STATUS2_L51_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L51_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L50_SHIFT         (18)  
#define DCU_PARR_ERR_STATUS2_L50_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L50_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L49_SHIFT         (17)  
#define DCU_PARR_ERR_STATUS2_L49_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L49_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L48_SHIFT         (16)  
#define DCU_PARR_ERR_STATUS2_L48_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L48_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L47_SHIFT         (15)  
#define DCU_PARR_ERR_STATUS2_L47_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L47_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L46_SHIFT         (14)  
#define DCU_PARR_ERR_STATUS2_L46_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L46_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L45_SHIFT         (13)  
#define DCU_PARR_ERR_STATUS2_L45_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L45_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L44_SHIFT         (12)  
#define DCU_PARR_ERR_STATUS2_L44_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L44_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L43_SHIFT         (11)  
#define DCU_PARR_ERR_STATUS2_L43_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L43_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L42_SHIFT         (10)  
#define DCU_PARR_ERR_STATUS2_L42_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L42_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L41_SHIFT         (9)  
#define DCU_PARR_ERR_STATUS2_L41_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L41_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L40_SHIFT         (8)  
#define DCU_PARR_ERR_STATUS2_L40_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L40_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L39_SHIFT         (7)  
#define DCU_PARR_ERR_STATUS2_L39_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L39_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L38_SHIFT         (6)  
#define DCU_PARR_ERR_STATUS2_L38_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L38_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L37_SHIFT         (5)  
#define DCU_PARR_ERR_STATUS2_L37_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L37_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L36_SHIFT         (4)  
#define DCU_PARR_ERR_STATUS2_L36_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L36_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L35_SHIFT         (3)  
#define DCU_PARR_ERR_STATUS2_L35_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L35_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L34_SHIFT         (2)  
#define DCU_PARR_ERR_STATUS2_L34_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L34_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L33_SHIFT         (1)  
#define DCU_PARR_ERR_STATUS2_L33_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L33_SHIFT)) 

#define DCU_PARR_ERR_STATUS2_L32_SHIFT         (0)  
#define DCU_PARR_ERR_STATUS2_L32_MASK          ((1) << (DCU_PARR_ERR_STATUS2_L32_SHIFT)) 



/* Field definitions for PARR_ERR_STATUS3 */
#define DCU_PARR_ERR_STATUS3_RLE_ERR_SHIFT              (3)  
#define DCU_PARR_ERR_STATUS3_RLE_ERR_MASK               ((1) << (DCU_PARR_ERR_STATUS3_RLE_ERR_SHIFT)) 

#define DCU_PARR_ERR_STATUS3_HWC_ERR_SHIFT              (2)  
#define DCU_PARR_ERR_STATUS3_HWC_ERR_MASK               ((1) << (DCU_PARR_ERR_STATUS3_HWC_ERR_SHIFT)) 

#define DCU_PARR_ERR_STATUS3_SIG_ERR_SHIFT              (1)  
#define DCU_PARR_ERR_STATUS3_SIG_ERR_MASK               ((1) << (DCU_PARR_ERR_STATUS3_SIG_ERR_SHIFT)) 

#define DCU_PARR_ERR_STATUS3_DISP_ERR_SHIFT             (0)  
#define DCU_PARR_ERR_STATUS3_DISP_ERR_MASK              ((1) << (DCU_PARR_ERR_STATUS3_DISP_ERR_SHIFT)) 



/* Field definitions for MASK_PARR_ERR_STATUS1 */
#define DCU_MASK_PARR_ERR_STATUS1_M_L31_SHIFT       (31)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L31_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L31_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L30_SHIFT       (30)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L30_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L30_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L29_SHIFT       (29)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L29_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L29_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L28_SHIFT       (28)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L28_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L28_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L27_SHIFT       (27)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L27_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L27_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L26_SHIFT       (26)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L26_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L26_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L25_SHIFT       (25)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L25_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L25_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L24_SHIFT       (24)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L24_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L24_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L23_SHIFT       (23)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L23_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L23_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L22_SHIFT       (22)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L22_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L22_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L21_SHIFT       (21)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L21_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L21_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L20_SHIFT       (20)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L20_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L20_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L19_SHIFT       (19)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L19_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L19_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L18_SHIFT       (18)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L18_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L18_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L17_SHIFT       (17)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L17_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L17_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L16_SHIFT       (16)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L16_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L16_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L15_SHIFT       (15)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L15_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L15_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L14_SHIFT       (14)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L14_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L14_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L13_SHIFT       (13)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L13_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L13_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L12_SHIFT       (12)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L12_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L12_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L11_SHIFT       (11)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L11_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L11_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L10_SHIFT       (10)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L10_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L10_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L9_SHIFT        (9)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L9_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L9_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L8_SHIFT        (8)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L8_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L8_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L7_SHIFT        (7)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L7_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L7_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L6_SHIFT        (6)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L6_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L6_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L5_SHIFT        (5)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L5_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L5_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L4_SHIFT        (4)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L4_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L4_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L3_SHIFT        (3)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L3_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L3_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L2_SHIFT        (2)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L2_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L2_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L1_SHIFT        (1)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L1_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L1_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS1_M_L0_SHIFT        (0)  
#define DCU_MASK_PARR_ERR_STATUS1_M_L0_MASK         ((1) << (DCU_MASK_PARR_ERR_STATUS1_M_L0_SHIFT)) 



/* Field definitions for MASK_PARR_ERR_STATUS2 */
#define DCU_MASK_PARR_ERR_STATUS2_M_L63_SHIFT       (31)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L63_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L63_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L62_SHIFT       (30)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L62_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L62_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L61_SHIFT       (29)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L61_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L61_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L60_SHIFT       (28)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L60_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L60_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L59_SHIFT       (27)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L59_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L59_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L58_SHIFT       (26)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L58_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L58_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L57_SHIFT       (25)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L57_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L57_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L56_SHIFT       (24)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L56_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L56_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L55_SHIFT       (23)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L55_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L55_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L54_SHIFT       (22)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L54_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L54_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L53_SHIFT       (21)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L53_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L53_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L52_SHIFT       (20)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L52_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L52_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L51_SHIFT       (19)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L51_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L51_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L50_SHIFT       (18)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L50_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L50_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L49_SHIFT       (17)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L49_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L49_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L48_SHIFT       (16)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L48_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L48_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L47_SHIFT       (15)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L47_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L47_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L46_SHIFT       (14)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L46_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L46_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L45_SHIFT       (13)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L45_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L45_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L44_SHIFT       (12)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L44_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L44_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L43_SHIFT       (11)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L43_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L43_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L42_SHIFT       (10)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L42_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L42_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L41_SHIFT       (9)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L41_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L41_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L40_SHIFT       (8)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L40_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L40_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L39_SHIFT       (7)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L39_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L39_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L38_SHIFT       (6)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L38_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L38_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L37_SHIFT       (5)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L37_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L37_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L36_SHIFT       (4)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L36_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L36_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L35_SHIFT       (3)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L35_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L35_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L34_SHIFT       (2)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L34_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L34_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L33_SHIFT       (1)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L33_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L33_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS2_M_L32_SHIFT       (0)  
#define DCU_MASK_PARR_ERR_STATUS2_M_L32_MASK        ((1) << (DCU_MASK_PARR_ERR_STATUS2_M_L32_SHIFT)) 



/* Field definitions for MASK_PARR_ERR_STATUS3 */
#define DCU_MASK_PARR_ERR_STATUS3_M_RLE_ERR_SHIFT            (3)  
#define DCU_MASK_PARR_ERR_STATUS3_M_RLE_ERR_MASK             ((1) << (DCU_MASK_PARR_ERR_STATUS3_M_RLE_ERR_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS3_M_HWC_ERR_SHIFT            (2)  
#define DCU_MASK_PARR_ERR_STATUS3_M_HWC_ERR_MASK             ((1) << (DCU_MASK_PARR_ERR_STATUS3_M_HWC_ERR_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS3_M_SIG_ERR_SHIFT            (1)  
#define DCU_MASK_PARR_ERR_STATUS3_M_SIG_ERR_MASK             ((1) << (DCU_MASK_PARR_ERR_STATUS3_M_SIG_ERR_SHIFT)) 

#define DCU_MASK_PARR_ERR_STATUS3_M_DISP_ERR_SHIFT           (0)  
#define DCU_MASK_PARR_ERR_STATUS3_M_DISP_ERR_MASK            ((1) << (DCU_MASK_PARR_ERR_STATUS3_M_DISP_ERR_SHIFT)) 



/* Field definitions for THRESHOLD_INP_BUF_1 */
#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_HI_SHIFT        (24)
#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_LO_SHIFT        (16)
#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_1_INP_BUF_P2_LO_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_HI_SHIFT        (8)
#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_LO_SHIFT        (0)
#define DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_1_INP_BUF_P1_LO_SHIFT)) 



/* Field definitions for THRESHOLD_INP_BUF_2 */
#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_HI_SHIFT        (24)
#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_LO_SHIFT        (16)
#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_2_INP_BUF_P4_LO_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_HI_SHIFT        (8)
#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_LO_SHIFT        (0)
#define DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_2_INP_BUF_P3_LO_SHIFT)) 



/* Field definitions for THRESHOLD_INP_BUF_3 */
#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_HI_SHIFT        (24)
#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_LO_SHIFT        (16)
#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_3_INP_BUF_P6_LO_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_HI_SHIFT        (8)
#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_HI_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_HI_SHIFT)) 

#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_LO_SHIFT        (0)
#define DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_LO_MASK         ((0x0000007F) << (DCU_THRESHOLD_INP_BUF_3_INP_BUF_P5_LO_SHIFT)) 



/* Field definitions for LUMA_COMP */
#define DCU_LUMA_COMP_Y_RED_SHIFT                (22)
#define DCU_LUMA_COMP_Y_RED_MASK                 ((0x000003FF) << (DCU_LUMA_COMP_Y_RED_SHIFT)) 

#define DCU_LUMA_COMP_Y_GREEN_SHIFT              (11)
#define DCU_LUMA_COMP_Y_GREEN_MASK               ((0x000003FF) << (DCU_LUMA_COMP_Y_GREEN_SHIFT)) 

#define DCU_LUMA_COMP_Y_BLUE_SHIFT               (0)
#define DCU_LUMA_COMP_Y_BLUE_MASK                ((0x000003FF) << (DCU_LUMA_COMP_Y_BLUE_SHIFT)) 



/* Field definitions for CHROMA_RED */
#define DCU_CHROMA_RED_CR_RED_SHIFT               (16)
#define DCU_CHROMA_RED_CR_RED_MASK                ((0x000007FF) << (DCU_CHROMA_RED_CR_RED_SHIFT)) 

#define DCU_CHROMA_RED_CB_GREEN_SHIFT             (0)
#define DCU_CHROMA_RED_CB_GREEN_MASK              ((0x00000FFF) << (DCU_CHROMA_RED_CB_GREEN_SHIFT)) 



/* Field definitions for CHROMA_GREEN */
#define DCU_CHROMA_GREEN_CR_GREEN_SHIFT             (16)
#define DCU_CHROMA_GREEN_CR_GREEN_MASK              ((0x000007FF) << (DCU_CHROMA_GREEN_CR_GREEN_SHIFT)) 

#define DCU_CHROMA_GREEN_CB_GREEN_SHIFT             (0)
#define DCU_CHROMA_GREEN_CB_GREEN_MASK              ((0x00000FFF) << (DCU_CHROMA_GREEN_CB_GREEN_SHIFT)) 



/* Field definitions for CHROMA_BLUE */
#define DCU_CHROMA_BLUE_CR_BLUE_SHIFT              (16)
#define DCU_CHROMA_BLUE_CR_BLUE_MASK               ((0x000007FF) << (DCU_CHROMA_BLUE_CR_BLUE_SHIFT)) 

#define DCU_CHROMA_BLUE_CB_BLUE_SHIFT              (0)
#define DCU_CHROMA_BLUE_CB_BLUE_MASK               ((0x00000FFF) << (DCU_CHROMA_BLUE_CB_BLUE_SHIFT)) 



/* Field definitions for CRC_POS */
#define DCU_CRC_POS_CRC_POS_SHIFT              (0)
#define DCU_CRC_POS_CRC_POS_MASK               ((0xFFFFFFFF) << (DCU_CRC_POS_CRC_POS_SHIFT)) 



/* Field definitions for LYR_INTPOL_EN */
#define DCU_LYR_INTPOL_EN_EN_SHIFT        (0)  
#define DCU_LYR_INTPOL_EN_EN_MASK         ((1) << (DCU_LYR_INTPOL_EN_EN_SHIFT)) 



/* Field definitions for LYR_LUMA_COMP */
#define DCU_LYR_LUMA_COMP_Y_RED_SHIFT        (22)  
#define DCU_LYR_LUMA_COMP_Y_RED_MASK         ((0x000003FF) << (DCU_LYR_LUMA_COMP_Y_RED_SHIFT)) 

#define DCU_LYR_LUMA_COMP_Y_GREEN_SHIFT        (11)  
#define DCU_LYR_LUMA_COMP_Y_GREEN_MASK         ((0x000003FF) << (DCU_LYR_LUMA_COMP_Y_GREEN_SHIFT)) 

#define DCU_LYR_LUMA_COMP_Y_BLUE_SHIFT        (0)  
#define DCU_LYR_LUMA_COMP_Y_BLUE_MASK         ((0x000003FF) << (DCU_LYR_LUMA_COMP_Y_BLUE_SHIFT)) 


/* Field definitions for LYR_CHROMA_RED */
#define DCU_LYR_CHROMA_RED_CR_RED_SHIFT               (16)
#define DCU_LYR_CHROMA_RED_CR_RED_MASK                ((0x000007FF) << (DCU_LYR_CHROMA_RED_CR_RED_SHIFT)) 

#define DCU_LYR_CHROMA_RED_CB_RED_SHIFT               (0)
#define DCU_LYR_CHROMA_RED_CB_RED_MASK                ((0x00000FFF) << (DCU_LYR_CHROMA_RED_CB_RED_SHIFT)) 



/* Field definitions for LYR_CHROMA_GREEN */
#define DCU_LYR_CHROMA_GREEN_CR_GREEN_SHIFT               (16)
#define DCU_LYR_CHROMA_GREEN_CR_GREEN_MASK                ((0x000007FF) << (DCU_LYR_CHROMA_GREEN_CR_GREEN_SHIFT)) 

#define DCU_LYR_CHROMA_GREEN_CB_GREEN_SHIFT               (0)
#define DCU_LYR_CHROMA_GREEN_CB_GREEN_MASK                ((0x00000FFF) << (DCU_LYR_CHROMA_GREEN_CB_GREEN_SHIFT)) 


/* Field definitions for LYR_CHROMA_BLUE */
#define DCU_LYR_CHROMA_BLUE_CR_BLUE_SHIFT               (16)
#define DCU_LYR_CHROMA_BLUE_CR_BLUE_MASK                ((0x000007FF) << (DCU_LYR_CHROMA_BLUE_CR_BLUE_SHIFT)) 

#define DCU_LYR_CHROMA_BLUE_CB_BLUE_SHIFT               (0)
#define DCU_LYR_CHROMA_BLUE_CB_BLUE_MASK                ((0x00000FFF) << (DCU_LYR_CHROMA_BLUE_CB_BLUE_SHIFT)) 

/* Field definitions for COMP_IMSIZE */
#define DCU_COMP_IMSIZE_SIZE_SHIFT          (0)
#define DCU_COMP_IMSIZE_SIZE_MASK           ((0x003FFFFF) << (DCU_COMP_IMSIZE_SIZE_SHIFT)) 



/* Field definitions for UPDATE_MODE */
#define DCU_UPDATE_MODE_MODE_SHIFT          (31)  
#define DCU_UPDATE_MODE_MODE_MASK           ((1) << (DCU_UPDATE_MODE_MODE_SHIFT)) 

#define DCU_UPDATE_MODE_READREG_SHIFT     (30)  
#define DCU_UPDATE_MODE_READREG_MASK      ((1) << (DCU_UPDATE_MODE_READREG_SHIFT)) 



/* Field definitions for UNDERRUN */
#define DCU_UNDERRUN_LINE_SHIFT          (16)  
#define DCU_UNDERRUN_LINE_MASK           ((0x000007FF) << (DCU_UNDERRUN_LINE_SHIFT)) 

#define DCU_UNDERRUN_PIXEL_SHIFT          (0)  
#define DCU_UNDERRUN_PIXEL_MASK           ((0x000007FF) << (DCU_UNDERRUN_PIXEL_SHIFT)) 



/* Field definitions for GPR */
#define DCU_GPR_HLB_SHIFT     (31)  
#define DCU_GPR_HLB_MASK      ((1) << (DCU_GPR_HLB_SHIFT)) 



/* Field definitions for SLR_L0 */
#define DCU_SLR_L0_WEN_L0_1_SHIFT     (31)  
#define DCU_SLR_L0_WEN_L0_1_MASK      ((1) << (DCU_SLR_L0_WEN_L0_1_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_2_SHIFT     (30)  
#define DCU_SLR_L0_WEN_L0_2_MASK      ((1) << (DCU_SLR_L0_WEN_L0_2_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_3_SHIFT     (29)  
#define DCU_SLR_L0_WEN_L0_3_MASK      ((1) << (DCU_SLR_L0_WEN_L0_3_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_4_SHIFT     (28)  
#define DCU_SLR_L0_WEN_L0_4_MASK      ((1) << (DCU_SLR_L0_WEN_L0_4_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_1_SHIFT     (27)  
#define DCU_SLR_L0_SLB_L0_1_MASK      ((1) << (DCU_SLR_L0_SLB_L0_1_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_2_SHIFT     (26)  
#define DCU_SLR_L0_SLB_L0_2_MASK      ((1) << (DCU_SLR_L0_SLB_L0_2_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_3_SHIFT     (25)  
#define DCU_SLR_L0_SLB_L0_3_MASK      ((1) << (DCU_SLR_L0_SLB_L0_3_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_4_SHIFT     (24)  
#define DCU_SLR_L0_SLB_L0_4_MASK      ((1) << (DCU_SLR_L0_SLB_L0_4_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_5_SHIFT     (23)  
#define DCU_SLR_L0_WEN_L0_5_MASK      ((1) << (DCU_SLR_L0_WEN_L0_5_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_6_SHIFT     (22)  
#define DCU_SLR_L0_WEN_L0_6_MASK      ((1) << (DCU_SLR_L0_WEN_L0_6_SHIFT)) 

#define DCU_SLR_L0_WEN_L0_7_SHIFT     (21)  
#define DCU_SLR_L0_WEN_L0_7_MASK      ((1) << (DCU_SLR_L0_WEN_L0_7_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_5_SHIFT     (19)  
#define DCU_SLR_L0_SLB_L0_5_MASK      ((1) << (DCU_SLR_L0_SLB_L0_5_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_6_SHIFT     (18)  
#define DCU_SLR_L0_SLB_L0_6_MASK      ((1) << (DCU_SLR_L0_SLB_L0_6_SHIFT)) 

#define DCU_SLR_L0_SLB_L0_7_SHIFT     (17)  
#define DCU_SLR_L0_SLB_L0_7_MASK      ((1) << (DCU_SLR_L0_SLB_L0_7_SHIFT)) 



/* Field definitions for SLR_L1 */
#define DCU_SLR_L1_WEN_L1_1_SHIFT     (31)  
#define DCU_SLR_L1_WEN_L1_1_MASK      ((1) << (DCU_SLR_L1_WEN_L1_1_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_2_SHIFT     (30)  
#define DCU_SLR_L1_WEN_L1_2_MASK      ((1) << (DCU_SLR_L1_WEN_L1_2_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_3_SHIFT     (29)  
#define DCU_SLR_L1_WEN_L1_3_MASK      ((1) << (DCU_SLR_L1_WEN_L1_3_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_4_SHIFT     (28)  
#define DCU_SLR_L1_WEN_L1_4_MASK      ((1) << (DCU_SLR_L1_WEN_L1_4_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_1_SHIFT     (27)  
#define DCU_SLR_L1_SLB_L1_1_MASK      ((1) << (DCU_SLR_L1_SLB_L1_1_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_2_SHIFT     (26)  
#define DCU_SLR_L1_SLB_L1_2_MASK      ((1) << (DCU_SLR_L1_SLB_L1_2_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_3_SHIFT     (25)  
#define DCU_SLR_L1_SLB_L1_3_MASK      ((1) << (DCU_SLR_L1_SLB_L1_3_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_4_SHIFT     (24)  
#define DCU_SLR_L1_SLB_L1_4_MASK      ((1) << (DCU_SLR_L1_SLB_L1_4_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_5_SHIFT     (23)  
#define DCU_SLR_L1_WEN_L1_5_MASK      ((1) << (DCU_SLR_L1_WEN_L1_5_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_6_SHIFT     (22)  
#define DCU_SLR_L1_WEN_L1_6_MASK      ((1) << (DCU_SLR_L1_WEN_L1_6_SHIFT)) 

#define DCU_SLR_L1_WEN_L1_7_SHIFT     (21)  
#define DCU_SLR_L1_WEN_L1_7_MASK      ((1) << (DCU_SLR_L1_WEN_L1_7_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_5_SHIFT     (19)  
#define DCU_SLR_L1_SLB_L1_5_MASK      ((1) << (DCU_SLR_L1_SLB_L1_5_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_6_SHIFT     (18)  
#define DCU_SLR_L1_SLB_L1_6_MASK      ((1) << (DCU_SLR_L1_SLB_L1_6_SHIFT)) 

#define DCU_SLR_L1_SLB_L1_7_SHIFT     (17)  
#define DCU_SLR_L1_SLB_L1_7_MASK      ((1) << (DCU_SLR_L1_SLB_L1_7_SHIFT)) 



/* Field definitions for SLR_DISP_SIZE */
#define DCU_SLR_DISP_SIZE_WEN_DISP_SHIFT     (31)  
#define DCU_SLR_DISP_SIZE_WEN_DISP_MASK      ((1) << (DCU_SLR_DISP_SIZE_WEN_DISP_SHIFT)) 

#define DCU_SLR_DISP_SIZE_SLB_DISP_SHIFT     (27)  
#define DCU_SLR_DISP_SIZE_SLB_DISP_MASK      ((1) << (DCU_SLR_DISP_SIZE_SLB_DISP_SHIFT)) 



/* Field definitions for SLR_HVSYNC_PARA */
#define DCU_SLR_HVSYNC_PARA_WEN_HSYNC_SHIFT     (31)  
#define DCU_SLR_HVSYNC_PARA_WEN_HSYNC_MASK      ((1) << (DCU_SLR_HVSYNC_PARA_WEN_HSYNC_SHIFT)) 

#define DCU_SLR_HVSYNC_PARA_WEN_VSYNC_SHIFT     (30)  
#define DCU_SLR_HVSYNC_PARA_WEN_VSYNC_MASK      ((1) << (DCU_SLR_HVSYNC_PARA_WEN_VSYNC_SHIFT)) 

#define DCU_SLR_HVSYNC_PARA_SLB_HSYNC_SHIFT     (27)  
#define DCU_SLR_HVSYNC_PARA_SLB_HSYNC_MASK      ((1) << (DCU_SLR_HVSYNC_PARA_SLB_HSYNC_SHIFT)) 

#define DCU_SLR_HVSYNC_PARA_SLB_VSYNC_SHIFT     (26)  
#define DCU_SLR_HVSYNC_PARA_SLB_VSYNC_MASK      ((1) << (DCU_SLR_HVSYNC_PARA_SLB_VSYNC_SHIFT)) 



/* Field definitions for SLR_POL */
#define DCU_SLR_POL_WEN_POL_SHIFT     (31)  
#define DCU_SLR_POL_WEN_POL_MASK      ((1) << (DCU_SLR_POL_WEN_POL_SHIFT)) 

#define DCU_SLR_POL_SLB_POL_SHIFT     (27)  
#define DCU_SLR_POL_SLB_POL_MASK      ((1) << (DCU_SLR_POL_SLB_POL_SHIFT)) 



/* Field definitions for SLR_L0TRANSP */
#define DCU_SLR_T0TRANSP_WEN_L0_8_SHIFT     (31)  
#define DCU_SLR_T0TRANSP_WEN_L0_8_MASK      ((1) << (DCU_SLR_T0TRANSP_WEN_L0_8_SHIFT)) 

#define DCU_SLR_T0TRANSP_WEN_L0_9_SHIFT     (30)  
#define DCU_SLR_T0TRANSP_WEN_L0_9_MASK      ((1) << (DCU_SLR_T0TRANSP_WEN_L0_9_SHIFT)) 

#define DCU_SLR_T0TRANSP_SLB_L0_8_SHIFT     (27)  
#define DCU_SLR_T0TRANSP_SLB_L0_8_MASK      ((1) << (DCU_SLR_T0TRANSP_SLB_L0_8_SHIFT)) 
                         
#define DCU_SLR_T0TRANSP_SLB_L0_9_SHIFT     (26)  
#define DCU_SLR_T0TRANSP_SLB_L0_9_MASK      ((1) << (DCU_SLR_T0TRANSP_SLB_L0_9_SHIFT)) 



/* Field definitions for SLR_L1TRANSP */
#define DCU_SLR_T1TRANSP_WEN_L1_8_SHIFT     (31)  
#define DCU_SLR_T1TRANSP_WEN_L1_8_MASK      ((1) << (DCU_SLR_T1TRANSP_WEN_L1_8_SHIFT)) 

#define DCU_SLR_T1TRANSP_WEN_L1_9_SHIFT     (30)  
#define DCU_SLR_T1TRANSP_WEN_L1_9_MASK      ((1) << (DCU_SLR_T1TRANSP_WEN_L1_9_SHIFT)) 

#define DCU_SLR_T1TRANSP_SLB_L1_8_SHIFT     (27)  
#define DCU_SLR_T1TRANSP_SLB_L1_8_MASK      ((1) << (DCU_SLR_T1TRANSP_SLB_L1_8_SHIFT)) 
                         
#define DCU_SLR_T1TRANSP_SLB_L1_9_SHIFT     (26)  
#define DCU_SLR_T1TRANSP_SLB_L1_9_MASK      ((1) << (DCU_SLR_T1TRANSP_SLB_L1_9_SHIFT)) 



/* Field definitions for CTRLDESCLn_1 */
#define DCU_CTRLDESCLn_1_HEIGHT_SHIFT                 (16)
#define DCU_CTRLDESCLn_1_HEIGHT_MASK                  ((0x000007FF) << (DCU_CTRLDESCLn_1_HEIGHT_SHIFT)) 

#define DCU_CTRLDESCLn_1_WIDTH_SHIFT                 (0)
#define DCU_CTRLDESCLn_1_WIDTH_MASK                  ((0x000007FF) << (DCU_CTRLDESCLn_1_WIDTH_SHIFT)) 



/* Field definitions for CTRLDESCLn_2 */
#define DCU_CTRLDESCLn_2_POSY_SHIFT                 (16)
#define DCU_CTRLDESCLn_2_POSY_MASK                  ((0x000007FF) << (DCU_CTRLDESCLn_2_POSY_SHIFT)) 

#define DCU_CTRLDESCLn_2_POSX_SHIFT                 (0)
#define DCU_CTRLDESCLn_2_POSX_MASK                  ((0x000007FF) << (DCU_CTRLDESCLn_2_POSX_SHIFT)) 



/* Field definitions for CTRLDESCLn_3 */
#define DCU_CTRLDESCLn_3_ADDR_SHIFT                 (0)
#define DCU_CTRLDESCLn_3_ADDR_MASK                  ((0xFFFFFFFF) << (DCU_CTRLDESCLn_3_ADDR_SHIFT)) 


/* Field definitions for CTRLDESCLn_4 */
#define DCU_CTRLDESCLn_4_EN_SHIFT                   (31)  
#define DCU_CTRLDESCLn_4_EN_MASK                    ((1) << (DCU_CTRLDESCLn_4_EN_SHIFT)) 

#define DCU_CTRLDESCLn_4_TILE_EN_SHIFT              (30)  
#define DCU_CTRLDESCLn_4_TILE_EN_MASK               ((1) << (DCU_CTRLDESCLn_4_TILE_EN_SHIFT)) 

#define DCU_CTRLDESCLn_4_DATA_SEL_SHIFT             (29)  
#define DCU_CTRLDESCLn_4_DATA_SEL_MASK              ((1) << (DCU_CTRLDESCLn_4_DATA_SEL_SHIFT)) 

#define DCU_CTRLDESCLn_4_SAFETY_EN_SHIFT            (28)  
#define DCU_CTRLDESCLn_4_SAFETY_EN_MASK             ((1) << (DCU_CTRLDESCLn_4_SAFETY_EN_SHIFT)) 

#define DCU_CTRLDESCLn_4_TRANS_SHIFT                (20)
#define DCU_CTRLDESCLn_4_TRANS_MASK                 ((0x000000FF) << (DCU_CTRLDESCLn_4_TRANS_SHIFT)) 

#define DCU_CTRLDESCLn_4_BPP_SHIFT                  (16)
#define DCU_CTRLDESCLn_4_BPP_MASK                   ((0x0000000F) << (DCU_CTRLDESCLn_4_BPP_SHIFT)) 

#define DCU_CTRLDESCLn_4_EN_RLE_SHIFT                  (15)
#define DCU_CTRLDESCLn_4_EN_RLE_MASK                   ((1) << (DCU_CTRLDESCLn_4_EN_RLE_SHIFT)) 

#define DCU_CTRLDESCLn_4_LUOFFS_SHIFT               (4)
#define DCU_CTRLDESCLn_4_LUOFFS_MASK                ((0x000007FF) << (DCU_CTRLDESCLn_4_LUOFFS_SHIFT)) 

#define DCU_CTRLDESCLn_4_BB_SHIFT                   (2)  
#define DCU_CTRLDESCLn_4_BB_MASK                    ((1) << (DCU_CTRLDESCLn_4_BB_SHIFT)) 

#define DCU_CTRLDESCLn_4_AB_SHIFT                   (0)
#define DCU_CTRLDESCLn_4_AB_MASK                    ((0x00000003) << (DCU_CTRLDESCLn_4_AB_SHIFT)) 



/* Field definitions for CTRLDESCLn_5 */
#define DCU_CTRLDESCLn_5_CKMAX_R_SHIFT              (16)
#define DCU_CTRLDESCLn_5_CKMAX_R_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_5_CKMAX_R_SHIFT)) 

#define DCU_CTRLDESCLn_5_CKMAX_G_SHIFT              (8)
#define DCU_CTRLDESCLn_5_CKMAX_G_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_5_CKMAX_G_SHIFT)) 

#define DCU_CTRLDESCLn_5_CKMAX_B_SHIFT              (0)
#define DCU_CTRLDESCLn_5_CKMAX_B_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_5_CKMAX_B_SHIFT)) 



/* Field definitions for CTRLDESCLn_6 */
#define DCU_CTRLDESCLn_6_CKMIN_R_SHIFT              (16)
#define DCU_CTRLDESCLn_6_CKMIN_R_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_6_CKMIN_R_SHIFT)) 

#define DCU_CTRLDESCLn_6_CKMIN_G_SHIFT              (8)
#define DCU_CTRLDESCLn_6_CKMIN_G_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_6_CKMIN_G_SHIFT)) 

#define DCU_CTRLDESCLn_6_CKMIN_B_SHIFT              (0)
#define DCU_CTRLDESCLn_6_CKMIN_B_MASK               ((0x000000FF) << (DCU_CTRLDESCLn_6_CKMIN_B_SHIFT)) 



/* Field definitions for CTRLDESCLn_7 */
#define DCU_CTRLDESCLn_7_TILE_VER_SIZE_SHIFT        (16)
#define DCU_CTRLDESCLn_7_TILE_VER_SIZE_MASK         ((0x000007FF) << (DCU_CTRLDESCLn_7_TILE_VER_SIZE_SHIFT)) 

#define DCU_CTRLDESCLn_7_TILE_HOR_SIZE_SHIFT        (0)
#define DCU_CTRLDESCLn_7_TILE_HOR_SIZE_MASK         ((0x0000007F) << (DCU_CTRLDESCLn_7_TILE_HOR_SIZE_SHIFT)) 



/* Field definitions for CTRLDESCLn_8 */
#define DCU_CTRLDESCLn_8_COLOR_SHIFT            (0)
#define DCU_CTRLDESCLn_8_COLOR_MASK             ((0x00FFFFFF) << (DCU_CTRLDESCLn_8_COLOR_SHIFT)) 



/* Field definitions for CTRLDESCLn_9 */
#define DCU_CTRLDESCLn_9_COLOR_SHIFT            (0)
#define DCU_CTRLDESCLn_9_COLOR_MASK             ((0x00FFFFFF) << (DCU_CTRLDESCLn_9_COLOR_SHIFT)) 


/*** End of bit definitions ***/

/*** define base address ***/
#define DCU0_BASE		0x40058000
#define DCU1_BASE		0x400D8000

#define DCU             (*(volatile struct DCUx_tag *)       0x40028000UL)
#define DCU1            (*(volatile struct DCUx_tag *)       0x40038000UL)
//#define DCU_0 			 (*(volatile struct DCU_tag *) 0x40028000UL)

#endif
